"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.9
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""


import unittest
import unittest.mock
import datetime
import fattureincloud_python_sdk
from fattureincloud_python_sdk.rest import RESTResponse
import functions
from fattureincloud_python_sdk.api.received_documents_api import ReceivedDocumentsApi
from fattureincloud_python_sdk.model.attachment_data import AttachmentData
from fattureincloud_python_sdk.model.create_received_document_response import CreateReceivedDocumentResponse
from fattureincloud_python_sdk.model.get_received_document_response import GetReceivedDocumentResponse
from fattureincloud_python_sdk.model.list_received_documents_response import ListReceivedDocumentsResponse
from fattureincloud_python_sdk.model.modify_received_document_response import ModifyReceivedDocumentResponse
from fattureincloud_python_sdk.model.received_document import ReceivedDocument
from fattureincloud_python_sdk.model.received_document_entity import ReceivedDocumentEntity
from fattureincloud_python_sdk.model.received_document_type import ReceivedDocumentType
from fattureincloud_python_sdk.model.upload_received_document_attachment_response import UploadReceivedDocumentAttachmentResponse
from fattureincloud_python_sdk.model.payment_account import PaymentAccount
from fattureincloud_python_sdk.model.received_document_info import ReceivedDocumentInfo
from fattureincloud_python_sdk.model.received_document_info_default_values import ReceivedDocumentInfoDefaultValues
from fattureincloud_python_sdk.model.received_document_info_items_default_values import ReceivedDocumentInfoItemsDefaultValues
from fattureincloud_python_sdk.model.received_document_totals import ReceivedDocumentTotals
from fattureincloud_python_sdk.model.vat_type import VatType
from fattureincloud_python_sdk.model.get_existing_received_document_totals_response import GetExistingReceivedDocumentTotalsResponse
from fattureincloud_python_sdk.model.get_new_received_document_totals_response import GetNewReceivedDocumentTotalsResponse
from fattureincloud_python_sdk.model.get_received_document_pre_create_info_response import GetReceivedDocumentPreCreateInfoResponse
from fattureincloud_python_sdk.model.received_document_items_list_item import ReceivedDocumentItemsListItem


class TestReceivedDocumentsApi(unittest.TestCase):
    """ReceivedDocumentsApi unit test stubs"""

    def setUp(self):
        self.api = ReceivedDocumentsApi()

    def tearDown(self):
        pass

    def test_create_received_document(self):
        resp = {
            'status': 200,
            'data': b'{"data": {"id": 1, "type": "expense", "entity": {"id": 1, "name": "name_example"}, "date": "2022-01-01", "category": "category_example", "description": "description_example", "amount_net": 3.14, "amount_vat": 3.14, "amount_withholding_tax": 3.14, "amount_other_withholding_tax": 3.14, "amortization": 3.14, "rc_center": "rc_center_example", "invoice_number": "invoice_number_example", "is_marked": true, "is_detailed": true, "e_invoice": true, "tax_deductibility": 0.0, "vat_deductibility": 0.0, "items_list": [{"id": 1, "product_id": 1, "code": "code_example", "name": "name_example", "measure": "measure_example", "net_price": 3.14, "category": "category_example", "qty": 3.14, "vat": {"id": 1, "value": 22.0, "description": "Non imponibile art. 123", "notes": "IVA non imponibile ai sensi dell articolo 123, comma 2", "e_invoice": true, "ei_type": "2", "ei_description": "ei_description_example", "is_disabled": true}, "stock": 3.14}]}}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.POST = unittest.mock.MagicMock(return_value = mock_resp)
        expected = CreateReceivedDocumentResponse(data = ReceivedDocument( id=2, type=ReceivedDocumentType("expense"), entity=ReceivedDocumentEntity( id=1, name="name_example", ), date=datetime.datetime.strptime("2022-01-01", '%Y-%m-%d').date(), category="category_example", description="description_example", amount_net=3.14, amount_vat=3.14, amount_withholding_tax=3.14, amount_other_withholding_tax=3.14, amortization=3.14, rc_center="rc_center_example", invoice_number="invoice_number_example", is_marked=True, is_detailed=True, e_invoice=True, tax_deductibility=0.0, vat_deductibility=0.0, items_list=[ ReceivedDocumentItemsListItem( id=1, product_id=1, code="code_example", name="name_example", measure="measure_example", net_price=3.14, category="category_example", qty=3.14, vat=VatType( id=1, value=22.0, description="Non imponibile art. 123", notes="IVA non imponibile ai sensi dell articolo 123, comma 2", e_invoice=True, ei_type="2", ei_description="ei_description_example", is_disabled=True ), stock=3.14)]) )
        actual = self.api.create_received_document(2)
        actual.data.id = 2
        assert actual == expected

    def test_delete_received_document(self):
        resp = {
            'status': 200,
            'data': b'{}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.DELETE = unittest.mock.MagicMock(return_value = mock_resp)
        actual = self.api.delete_received_document(2, 12345)
        assert actual == None

    def test_delete_received_document_attachment(self):
        resp = {
            'status': 200,
            'data': b'{}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.DELETE = unittest.mock.MagicMock(return_value = mock_resp)
        actual = self.api.delete_received_document_attachment(2, 12345)
        assert actual == None

    def test_get_existing_received_document_totals(self):
        resp = {
            'status': 200,
            'data': b'{"data": {"amount_net": 10.0, "amount_rivalsa": 0.0, "amount_net_with_rivalsa": 10.0, "amount_cassa": 3.14, "taxable_amount": 0.0, "amount_vat": 22.0, "amount_gross": 12.2, "amount_due": 12.2, "payments_sum": 12.2}}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.POST = unittest.mock.MagicMock(return_value = mock_resp)
        expected = GetExistingReceivedDocumentTotalsResponse(data = ReceivedDocumentTotals( amount_net=12.0, amount_rivalsa=0.0, amount_net_with_rivalsa=10.0, amount_cassa=3.14, taxable_amount=0.0, amount_vat=22.0, amount_gross=12.2, amount_due=12.2, payments_sum=12.2 ) )
        actual = self.api.get_existing_received_document_totals(2, 12345)
        actual.data.amount_net = 12.0
        assert actual == expected

    def test_get_new_received_document_totals(self):
        resp = {
            'status': 200,
            'data': b'{"data": {"amount_net": 10.0, "amount_rivalsa": 0.0, "amount_net_with_rivalsa": 10.0, "amount_cassa": 3.14, "taxable_amount": 0.0, "amount_vat": 22.0, "amount_gross": 12.2, "amount_due": 12.2, "payments_sum": 12.2}}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.POST = unittest.mock.MagicMock(return_value = mock_resp)
        expected = GetNewReceivedDocumentTotalsResponse(data = ReceivedDocumentTotals( amount_net=12.0, amount_rivalsa=0.0, amount_net_with_rivalsa=10.0, amount_cassa=3.14, taxable_amount=0.0, amount_vat=22.0, amount_gross=12.2, amount_due=12.2, payments_sum=12.2 ) )
        actual = self.api.get_new_received_document_totals(2)
        actual.data.amount_net = 12.0
        assert actual == expected

    def test_get_received_document(self):
        resp = {
            'status': 200,
            'data': b'{"data": {"id": 1, "type": "expense", "entity": {"id": 1, "name": "name_example"}, "date": "2022-01-01", "category": "category_example", "description": "description_example", "amount_net": 3.14, "amount_vat": 3.14, "amount_withholding_tax": 3.14, "amount_other_withholding_tax": 3.14, "amortization": 3.14, "rc_center": "rc_center_example", "invoice_number": "invoice_number_example", "is_marked": true, "is_detailed": true, "e_invoice": true, "tax_deductibility": 0.0, "vat_deductibility": 0.0, "items_list": [{"id": 1, "product_id": 1, "code": "code_example", "name": "name_example", "measure": "measure_example", "net_price": 3.14, "category": "category_example", "qty": 3.14, "vat": {"id": 1, "value": 22.0, "description": "Non imponibile art. 123", "notes": "IVA non imponibile ai sensi dell articolo 123, comma 2", "e_invoice": true, "ei_type": "2", "ei_description": "ei_description_example", "is_disabled": true}, "stock": 3.14}]}}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.GET = unittest.mock.MagicMock(return_value = mock_resp)
        expected = GetReceivedDocumentResponse(data = ReceivedDocument( id=2, type=ReceivedDocumentType("expense"), entity=ReceivedDocumentEntity( id=1, name="name_example", ), date=datetime.datetime.strptime("2022-01-01", '%Y-%m-%d').date(), category="category_example", description="description_example", amount_net=3.14, amount_vat=3.14, amount_withholding_tax=3.14, amount_other_withholding_tax=3.14, amortization=3.14, rc_center="rc_center_example", invoice_number="invoice_number_example", is_marked=True, is_detailed=True, e_invoice=True, tax_deductibility=0.0, vat_deductibility=0.0, items_list=[ ReceivedDocumentItemsListItem( id=1, product_id=1, code="code_example", name="name_example", measure="measure_example", net_price=3.14, category="category_example", qty=3.14, vat=VatType( id=1, value=22.0, description="Non imponibile art. 123", notes="IVA non imponibile ai sensi dell articolo 123, comma 2", e_invoice=True, ei_type="2", ei_description="ei_description_example", is_disabled=True ), stock=3.14)]) )
        actual = self.api.get_received_document(2, 12345)
        actual.data.id = 2
        assert actual == expected

    def test_get_received_document_pre_create_info(self):
        resp = {
            'status': 200,
            'data': b'{"data": {"default_values": {"detailed": true}, "items_default_values": {"vat": 22.0}, "countries_list": ["IT", "US"], "payment_accounts_list": [{"id": 1, "name": "bank"}], "categories_list": ["cat5", "cat6"], "vat_types_list": [{"value": 22.0}]}}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.GET = unittest.mock.MagicMock(return_value = mock_resp)
        expected = GetReceivedDocumentPreCreateInfoResponse(data = ReceivedDocumentInfo( default_values=ReceivedDocumentInfoDefaultValues( detailed=True ), items_default_values=ReceivedDocumentInfoItemsDefaultValues( vat=22.0 ), countries_list=[ "IT", "US" ], payment_accounts_list=[ PaymentAccount( id=1, name="bank" ) ], categories_list=[ "cat5", "cat6" ], vat_types_list=[ VatType( value=22.0 ) ] ) )
        actual = self.api.get_received_document_pre_create_info(2, "expense")
        assert actual == expected

    def test_list_received_documents(self):
        resp = {
            'status': 200,
            'data': b'{"data": [{"id": 1, "type": "expense", "entity": {"id": 1, "name": "name_example"}, "date": "2022-01-01", "category": "category_example", "description": "description_example", "amount_net": 3.14, "amount_vat": 3.14, "amount_withholding_tax": 3.14, "amount_other_withholding_tax": 3.14, "amortization": 3.14, "rc_center": "rc_center_example", "invoice_number": "invoice_number_example", "is_marked": true, "is_detailed": true, "e_invoice": true, "tax_deductibility": 0.0, "vat_deductibility": 0.0, "items_list": [{"id": 1, "product_id": 1, "code": "code_example", "name": "name_example", "measure": "measure_example", "net_price": 3.14, "category": "category_example", "qty": 3.14, "vat": {"id": 1, "value": 22.0, "description": "Non imponibile art. 123", "notes": "IVA non imponibile ai sensi dell articolo 123, comma 2", "e_invoice": true, "ei_type": "2", "ei_description": "ei_description_example", "is_disabled": true}, "stock": 3.14}]},{"id": 1, "type": "expense", "entity": {"id": 1, "name": "name_example"}, "date": "2022-01-01", "category": "category_example", "description": "description_example", "amount_net": 3.14, "amount_vat": 3.14, "amount_withholding_tax": 3.14, "amount_other_withholding_tax": 3.14, "amortization": 3.14, "rc_center": "rc_center_example", "invoice_number": "invoice_number_example", "is_marked": true, "is_detailed": true, "e_invoice": true, "tax_deductibility": 0.0, "vat_deductibility": 0.0, "items_list": [{"id": 1, "product_id": 1, "code": "code_example", "name": "name_example", "measure": "measure_example", "net_price": 3.14, "category": "category_example", "qty": 3.14, "vat": {"id": 1, "value": 22.0, "description": "Non imponibile art. 123", "notes": "IVA non imponibile ai sensi dell articolo 123, comma 2", "e_invoice": true, "ei_type": "2", "ei_description": "ei_description_example", "is_disabled": true}, "stock": 3.14}]}]}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.GET = unittest.mock.MagicMock(return_value = mock_resp)
        expected = ListReceivedDocumentsResponse(data = [ReceivedDocument( id=2, type=ReceivedDocumentType("expense"), entity=ReceivedDocumentEntity( id=1, name="name_example", ), date=datetime.datetime.strptime("2022-01-01", '%Y-%m-%d').date(), category="category_example", description="description_example", amount_net=3.14, amount_vat=3.14, amount_withholding_tax=3.14, amount_other_withholding_tax=3.14, amortization=3.14, rc_center="rc_center_example", invoice_number="invoice_number_example", is_marked=True, is_detailed=True, e_invoice=True, tax_deductibility=0.0, vat_deductibility=0.0, items_list=[ ReceivedDocumentItemsListItem( id=1, product_id=1, code="code_example", name="name_example", measure="measure_example", net_price=3.14, category="category_example", qty=3.14, vat=VatType( id=1, value=22.0, description="Non imponibile art. 123", notes="IVA non imponibile ai sensi dell articolo 123, comma 2", e_invoice=True, ei_type="2", ei_description="ei_description_example", is_disabled=True ), stock=3.14)]),ReceivedDocument( id=2, type=ReceivedDocumentType("expense"), entity=ReceivedDocumentEntity( id=1, name="name_example", ), date=datetime.datetime.strptime("2022-01-01", '%Y-%m-%d').date(), category="category_example", description="description_example", amount_net=3.14, amount_vat=3.14, amount_withholding_tax=3.14, amount_other_withholding_tax=3.14, amortization=3.14, rc_center="rc_center_example", invoice_number="invoice_number_example", is_marked=True, is_detailed=True, e_invoice=True, tax_deductibility=0.0, vat_deductibility=0.0, items_list=[ ReceivedDocumentItemsListItem( id=1, product_id=1, code="code_example", name="name_example", measure="measure_example", net_price=3.14, category="category_example", qty=3.14, vat=VatType( id=1, value=22.0, description="Non imponibile art. 123", notes="IVA non imponibile ai sensi dell articolo 123, comma 2", e_invoice=True, ei_type="2", ei_description="ei_description_example", is_disabled=True ), stock=3.14)])] )
        actual = self.api.list_received_documents(2, "expense")
        actual.data[0].id = 2
        actual.data[1].id = 2
        assert actual == expected

    def test_modify_received_document(self):
        resp = {
            'status': 200,
            'data': b'{"data": {"id": 1, "type": "expense", "entity": {"id": 1, "name": "name_example"}, "date": "2022-01-01", "category": "category_example", "description": "description_example", "amount_net": 3.14, "amount_vat": 3.14, "amount_withholding_tax": 3.14, "amount_other_withholding_tax": 3.14, "amortization": 3.14, "rc_center": "rc_center_example", "invoice_number": "invoice_number_example", "is_marked": true, "is_detailed": true, "e_invoice": true, "tax_deductibility": 0.0, "vat_deductibility": 0.0, "items_list": [{"id": 1, "product_id": 1, "code": "code_example", "name": "name_example", "measure": "measure_example", "net_price": 3.14, "category": "category_example", "qty": 3.14, "vat": {"id": 1, "value": 22.0, "description": "Non imponibile art. 123", "notes": "IVA non imponibile ai sensi dell articolo 123, comma 2", "e_invoice": true, "ei_type": "2", "ei_description": "ei_description_example", "is_disabled": true}, "stock": 3.14}]}}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.PUT = unittest.mock.MagicMock(return_value = mock_resp)
        expected = ModifyReceivedDocumentResponse(data = ReceivedDocument( id=2, type=ReceivedDocumentType("expense"), entity=ReceivedDocumentEntity( id=1, name="name_example", ), date=datetime.datetime.strptime("2022-01-01", '%Y-%m-%d').date(), category="category_example", description="description_example", amount_net=3.14, amount_vat=3.14, amount_withholding_tax=3.14, amount_other_withholding_tax=3.14, amortization=3.14, rc_center="rc_center_example", invoice_number="invoice_number_example", is_marked=True, is_detailed=True, e_invoice=True, tax_deductibility=0.0, vat_deductibility=0.0, items_list=[ ReceivedDocumentItemsListItem( id=1, product_id=1, code="code_example", name="name_example", measure="measure_example", net_price=3.14, category="category_example", qty=3.14, vat=VatType( id=1, value=22.0, description="Non imponibile art. 123", notes="IVA non imponibile ai sensi dell articolo 123, comma 2", e_invoice=True, ei_type="2", ei_description="ei_description_example", is_disabled=True ), stock=3.14)]) )
        actual = self.api.modify_received_document(2, 12345)
        actual.data.id = 2
        assert actual == expected

    def test_upload_received_document_attachment(self):
        resp = {
            'status': 200,
            'data': b'{"data": {"attachment_token": "aisdfvbgablsi9876r8o3qw36"}}',
            'reason': "OK"
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value = None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value = None)

        self.api.api_client.rest_client.POST = unittest.mock.MagicMock(return_value = mock_resp)
        expected = UploadReceivedDocumentAttachmentResponse(data = AttachmentData(attachment_token = "aisdfvbgablsi9876r8o3qw36"))
        actual = self.api.upload_received_document_attachment(2)
        assert actual == expected


if __name__ == '__main__':
    unittest.main()
