# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.33
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from fattureincloud_python_sdk.models.create_supplier_request import (
    CreateSupplierRequest,
)
from fattureincloud_python_sdk.models.create_supplier_response import (
    CreateSupplierResponse,
)
from fattureincloud_python_sdk.models.get_supplier_response import GetSupplierResponse
from fattureincloud_python_sdk.models.list_suppliers_response import (
    ListSuppliersResponse,
)
from fattureincloud_python_sdk.models.modify_supplier_request import (
    ModifySupplierRequest,
)
from fattureincloud_python_sdk.models.modify_supplier_response import (
    ModifySupplierResponse,
)

from fattureincloud_python_sdk.api_client import ApiClient, RequestSerialized
from fattureincloud_python_sdk.api_response import ApiResponse
from fattureincloud_python_sdk.rest import RESTResponseType


class SuppliersApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_supplier(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        create_supplier_request: Annotated[
            Optional[CreateSupplierRequest], Field(description="The supplier to create")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateSupplierResponse:
        """Create Supplier

        Creates a new supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param create_supplier_request: The supplier to create
        :type create_supplier_request: CreateSupplierRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_supplier_serialize(
            company_id=company_id,
            create_supplier_request=create_supplier_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CreateSupplierResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_supplier_with_http_info(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        create_supplier_request: Annotated[
            Optional[CreateSupplierRequest], Field(description="The supplier to create")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateSupplierResponse]:
        """Create Supplier

        Creates a new supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param create_supplier_request: The supplier to create
        :type create_supplier_request: CreateSupplierRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_supplier_serialize(
            company_id=company_id,
            create_supplier_request=create_supplier_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CreateSupplierResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_supplier_without_preload_content(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        create_supplier_request: Annotated[
            Optional[CreateSupplierRequest], Field(description="The supplier to create")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Supplier

        Creates a new supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param create_supplier_request: The supplier to create
        :type create_supplier_request: CreateSupplierRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_supplier_serialize(
            company_id=company_id,
            create_supplier_request=create_supplier_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CreateSupplierResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _create_supplier_serialize(
        self,
        company_id,
        create_supplier_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if company_id is not None:
            _path_params["company_id"] = company_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_supplier_request is not None:
            _body_params = create_supplier_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["OAuth2AuthenticationCodeFlow"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/c/{company_id}/entities/suppliers",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_supplier(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Supplier

        Deletes the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_supplier_with_http_info(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Supplier

        Deletes the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_supplier_without_preload_content(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Supplier

        Deletes the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_supplier_serialize(
        self,
        company_id,
        supplier_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if company_id is not None:
            _path_params["company_id"] = company_id
        if supplier_id is not None:
            _path_params["supplier_id"] = supplier_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # authentication setting
        _auth_settings: List[str] = ["OAuth2AuthenticationCodeFlow"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/c/{company_id}/entities/suppliers/{supplier_id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_supplier(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetSupplierResponse:
        """Get Supplier

        Gets the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            fields=fields,
            fieldset=fieldset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetSupplierResponse",
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_supplier_with_http_info(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetSupplierResponse]:
        """Get Supplier

        Gets the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            fields=fields,
            fieldset=fieldset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetSupplierResponse",
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_supplier_without_preload_content(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Supplier

        Gets the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            fields=fields,
            fieldset=fieldset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "GetSupplierResponse",
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_supplier_serialize(
        self,
        company_id,
        supplier_id,
        fields,
        fieldset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if company_id is not None:
            _path_params["company_id"] = company_id
        if supplier_id is not None:
            _path_params["supplier_id"] = supplier_id
        # process the query parameters
        if fields is not None:

            _query_params.append(("fields", fields))

        if fieldset is not None:

            _query_params.append(("fieldset", fieldset))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["OAuth2AuthenticationCodeFlow"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/c/{company_id}/entities/suppliers/{supplier_id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def list_suppliers(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        page: Annotated[
            Optional[StrictInt], Field(description="The page to retrieve.")
        ] = None,
        per_page: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="The size of the page."),
        ] = None,
        q: Annotated[
            Optional[StrictStr], Field(description="Query for filtering the results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListSuppliersResponse:
        """List Suppliers

        Lists the suppliers.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param page: The page to retrieve.
        :type page: int
        :param per_page: The size of the page.
        :type per_page: int
        :param q: Query for filtering the results.
        :type q: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_suppliers_serialize(
            company_id=company_id,
            fields=fields,
            fieldset=fieldset,
            sort=sort,
            page=page,
            per_page=per_page,
            q=q,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListSuppliersResponse",
            "401": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_suppliers_with_http_info(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        page: Annotated[
            Optional[StrictInt], Field(description="The page to retrieve.")
        ] = None,
        per_page: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="The size of the page."),
        ] = None,
        q: Annotated[
            Optional[StrictStr], Field(description="Query for filtering the results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListSuppliersResponse]:
        """List Suppliers

        Lists the suppliers.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param page: The page to retrieve.
        :type page: int
        :param per_page: The size of the page.
        :type per_page: int
        :param q: Query for filtering the results.
        :type q: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_suppliers_serialize(
            company_id=company_id,
            fields=fields,
            fieldset=fieldset,
            sort=sort,
            page=page,
            per_page=per_page,
            q=q,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListSuppliersResponse",
            "401": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_suppliers_without_preload_content(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        page: Annotated[
            Optional[StrictInt], Field(description="The page to retrieve.")
        ] = None,
        per_page: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="The size of the page."),
        ] = None,
        q: Annotated[
            Optional[StrictStr], Field(description="Query for filtering the results.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Suppliers

        Lists the suppliers.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param page: The page to retrieve.
        :type page: int
        :param per_page: The size of the page.
        :type per_page: int
        :param q: Query for filtering the results.
        :type q: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._list_suppliers_serialize(
            company_id=company_id,
            fields=fields,
            fieldset=fieldset,
            sort=sort,
            page=page,
            per_page=per_page,
            q=q,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ListSuppliersResponse",
            "401": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _list_suppliers_serialize(
        self,
        company_id,
        fields,
        fieldset,
        sort,
        page,
        per_page,
        q,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if company_id is not None:
            _path_params["company_id"] = company_id
        # process the query parameters
        if fields is not None:

            _query_params.append(("fields", fields))

        if fieldset is not None:

            _query_params.append(("fieldset", fieldset))

        if sort is not None:

            _query_params.append(("sort", sort))

        if page is not None:

            _query_params.append(("page", page))

        if per_page is not None:

            _query_params.append(("per_page", per_page))

        if q is not None:

            _query_params.append(("q", q))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["OAuth2AuthenticationCodeFlow"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/c/{company_id}/entities/suppliers",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def modify_supplier(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        modify_supplier_request: Annotated[
            Optional[ModifySupplierRequest],
            Field(
                description="The modified Supplier. First level parameters are managed in delta mode."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ModifySupplierResponse:
        """Modify Supplier

        Modifies the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param modify_supplier_request: The modified Supplier. First level parameters are managed in delta mode.
        :type modify_supplier_request: ModifySupplierRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._modify_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            modify_supplier_request=modify_supplier_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ModifySupplierResponse",
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def modify_supplier_with_http_info(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        modify_supplier_request: Annotated[
            Optional[ModifySupplierRequest],
            Field(
                description="The modified Supplier. First level parameters are managed in delta mode."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ModifySupplierResponse]:
        """Modify Supplier

        Modifies the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param modify_supplier_request: The modified Supplier. First level parameters are managed in delta mode.
        :type modify_supplier_request: ModifySupplierRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._modify_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            modify_supplier_request=modify_supplier_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ModifySupplierResponse",
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def modify_supplier_without_preload_content(
        self,
        company_id: Annotated[StrictInt, Field(description="The ID of the company.")],
        supplier_id: Annotated[StrictInt, Field(description="The ID of the supplier.")],
        modify_supplier_request: Annotated[
            Optional[ModifySupplierRequest],
            Field(
                description="The modified Supplier. First level parameters are managed in delta mode."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Modify Supplier

        Modifies the specified supplier.

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param supplier_id: The ID of the supplier. (required)
        :type supplier_id: int
        :param modify_supplier_request: The modified Supplier. First level parameters are managed in delta mode.
        :type modify_supplier_request: ModifySupplierRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._modify_supplier_serialize(
            company_id=company_id,
            supplier_id=supplier_id,
            modify_supplier_request=modify_supplier_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "ModifySupplierResponse",
            "401": None,
            "404": None,
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _modify_supplier_serialize(
        self,
        company_id,
        supplier_id,
        modify_supplier_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if company_id is not None:
            _path_params["company_id"] = company_id
        if supplier_id is not None:
            _path_params["supplier_id"] = supplier_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if modify_supplier_request is not None:
            _body_params = modify_supplier_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["OAuth2AuthenticationCodeFlow"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/c/{company_id}/entities/suppliers/{supplier_id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
