# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.33
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fattureincloud_python_sdk.models.original_document_type import OriginalDocumentType
from fattureincloud_python_sdk.models.vat_kind import VatKind
from typing import Optional, Set
from typing_extensions import Self


class IssuedDocumentEiData(BaseModel):
    """
    Issued document e-invoice data [Only if e_invoice=true]
    """  # noqa: E501

    vat_kind: Optional[VatKind] = None
    original_document_type: Optional[OriginalDocumentType] = None
    od_number: Optional[StrictStr] = Field(
        default=None, description="E-invoice original document number"
    )
    od_date: Optional[date] = Field(
        default=None, description="E-invoice original document date"
    )
    cig: Optional[StrictStr] = Field(default=None, description="E-invoice CIG")
    cup: Optional[StrictStr] = Field(default=None, description="E-invoice CUP")
    payment_method: Optional[StrictStr] = Field(
        default=None,
        description="E-invoice payment method [required for e-invoices] (see [here](https://www.fatturapa.gov.it/export/documenti/fatturapa/v1.2.2/Rappresentazione_Tabellare_FattOrdinaria_V1.2.2.pdf) for the accepted values of ModalitaPagamento)",
    )
    bank_name: Optional[StrictStr] = Field(
        default=None, description="E-invoice bank name"
    )
    bank_iban: Optional[StrictStr] = Field(
        default=None, description="E-invoice bank IBAN"
    )
    bank_beneficiary: Optional[StrictStr] = Field(
        default=None, description="E-invoice bank beneficiary"
    )
    invoice_number: Optional[StrictStr] = Field(
        default=None, description="E-invoice invoice number"
    )
    invoice_date: Optional[date] = Field(
        default=None, description="E-invoice invoice date"
    )
    __properties: ClassVar[List[str]] = [
        "vat_kind",
        "original_document_type",
        "od_number",
        "od_date",
        "cig",
        "cup",
        "payment_method",
        "bank_name",
        "bank_iban",
        "bank_beneficiary",
        "invoice_number",
        "invoice_date",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuedDocumentEiData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuedDocumentEiData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "vat_kind": obj.get("vat_kind"),
                "original_document_type": obj.get("original_document_type"),
                "od_number": obj.get("od_number"),
                "od_date": obj.get("od_date"),
                "cig": obj.get("cig"),
                "cup": obj.get("cup"),
                "payment_method": obj.get("payment_method"),
                "bank_name": obj.get("bank_name"),
                "bank_iban": obj.get("bank_iban"),
                "bank_beneficiary": obj.get("bank_beneficiary"),
                "invoice_number": obj.get("invoice_number"),
                "invoice_date": obj.get("invoice_date"),
            }
        )
        return _obj
