# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.33
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fattureincloud_python_sdk.models.currency import Currency
from fattureincloud_python_sdk.models.document_template import DocumentTemplate
from fattureincloud_python_sdk.models.issued_document_pre_create_info_default_values import (
    IssuedDocumentPreCreateInfoDefaultValues,
)
from fattureincloud_python_sdk.models.issued_document_pre_create_info_extra_data_default_values import (
    IssuedDocumentPreCreateInfoExtraDataDefaultValues,
)
from fattureincloud_python_sdk.models.issued_document_pre_create_info_items_default_values import (
    IssuedDocumentPreCreateInfoItemsDefaultValues,
)
from fattureincloud_python_sdk.models.language import Language
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from fattureincloud_python_sdk.models.payment_method import PaymentMethod
from fattureincloud_python_sdk.models.vat_type import VatType
from typing import Optional, Set
from typing_extensions import Self


class IssuedDocumentPreCreateInfo(BaseModel):
    """
    IssuedDocumentPreCreateInfo
    """  # noqa: E501

    numerations: Optional[Dict[str, Dict[str, StrictInt]]] = None
    dn_numerations: Optional[Dict[str, Dict[str, StrictInt]]] = None
    default_values: Optional[IssuedDocumentPreCreateInfoDefaultValues] = None
    extra_data_default_values: Optional[
        IssuedDocumentPreCreateInfoExtraDataDefaultValues
    ] = None
    items_default_values: Optional[IssuedDocumentPreCreateInfoItemsDefaultValues] = None
    countries_list: Optional[List[StrictStr]] = Field(
        default=None, description="Countries list"
    )
    currencies_list: Optional[List[Currency]] = Field(
        default=None, description="Currencies list"
    )
    templates_list: Optional[List[DocumentTemplate]] = Field(
        default=None, description="Document templates list"
    )
    dn_templates_list: Optional[List[DocumentTemplate]] = Field(
        default=None, description="Delivery note templates list"
    )
    ai_templates_list: Optional[List[DocumentTemplate]] = Field(
        default=None, description="Accompanying invoice templates list"
    )
    payment_methods_list: Optional[List[PaymentMethod]] = Field(
        default=None, description="Payment methods list"
    )
    payment_accounts_list: Optional[List[Optional[PaymentAccount]]] = Field(
        default=None, description="Payment accounts list"
    )
    vat_types_list: Optional[List[Optional[VatType]]] = Field(
        default=None, description="Vat types list"
    )
    languages_list: Optional[List[Language]] = Field(
        default=None, description="Languages list"
    )
    __properties: ClassVar[List[str]] = [
        "numerations",
        "dn_numerations",
        "default_values",
        "extra_data_default_values",
        "items_default_values",
        "countries_list",
        "currencies_list",
        "templates_list",
        "dn_templates_list",
        "ai_templates_list",
        "payment_methods_list",
        "payment_accounts_list",
        "vat_types_list",
        "languages_list",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuedDocumentPreCreateInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_values
        if self.default_values:
            _dict["default_values"] = self.default_values.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extra_data_default_values
        if self.extra_data_default_values:
            _dict["extra_data_default_values"] = (
                self.extra_data_default_values.to_dict()
            )
        # override the default output from pydantic by calling `to_dict()` of items_default_values
        if self.items_default_values:
            _dict["items_default_values"] = self.items_default_values.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in currencies_list (list)
        _items = []
        if self.currencies_list:
            for _item in self.currencies_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["currencies_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in templates_list (list)
        _items = []
        if self.templates_list:
            for _item in self.templates_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["templates_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dn_templates_list (list)
        _items = []
        if self.dn_templates_list:
            for _item in self.dn_templates_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["dn_templates_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ai_templates_list (list)
        _items = []
        if self.ai_templates_list:
            for _item in self.ai_templates_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["ai_templates_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payment_methods_list (list)
        _items = []
        if self.payment_methods_list:
            for _item in self.payment_methods_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["payment_methods_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payment_accounts_list (list)
        _items = []
        if self.payment_accounts_list:
            for _item in self.payment_accounts_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["payment_accounts_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vat_types_list (list)
        _items = []
        if self.vat_types_list:
            for _item in self.vat_types_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["vat_types_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in languages_list (list)
        _items = []
        if self.languages_list:
            for _item in self.languages_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["languages_list"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuedDocumentPreCreateInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "numerations": obj.get("numerations"),
                "dn_numerations": obj.get("dn_numerations"),
                "default_values": (
                    IssuedDocumentPreCreateInfoDefaultValues.from_dict(
                        obj["default_values"]
                    )
                    if obj.get("default_values") is not None
                    else None
                ),
                "extra_data_default_values": (
                    IssuedDocumentPreCreateInfoExtraDataDefaultValues.from_dict(
                        obj["extra_data_default_values"]
                    )
                    if obj.get("extra_data_default_values") is not None
                    else None
                ),
                "items_default_values": (
                    IssuedDocumentPreCreateInfoItemsDefaultValues.from_dict(
                        obj["items_default_values"]
                    )
                    if obj.get("items_default_values") is not None
                    else None
                ),
                "countries_list": obj.get("countries_list"),
                "currencies_list": (
                    [Currency.from_dict(_item) for _item in obj["currencies_list"]]
                    if obj.get("currencies_list") is not None
                    else None
                ),
                "templates_list": (
                    [
                        DocumentTemplate.from_dict(_item)
                        for _item in obj["templates_list"]
                    ]
                    if obj.get("templates_list") is not None
                    else None
                ),
                "dn_templates_list": (
                    [
                        DocumentTemplate.from_dict(_item)
                        for _item in obj["dn_templates_list"]
                    ]
                    if obj.get("dn_templates_list") is not None
                    else None
                ),
                "ai_templates_list": (
                    [
                        DocumentTemplate.from_dict(_item)
                        for _item in obj["ai_templates_list"]
                    ]
                    if obj.get("ai_templates_list") is not None
                    else None
                ),
                "payment_methods_list": (
                    [
                        PaymentMethod.from_dict(_item)
                        for _item in obj["payment_methods_list"]
                    ]
                    if obj.get("payment_methods_list") is not None
                    else None
                ),
                "payment_accounts_list": (
                    [
                        PaymentAccount.from_dict(_item)
                        for _item in obj["payment_accounts_list"]
                    ]
                    if obj.get("payment_accounts_list") is not None
                    else None
                ),
                "vat_types_list": (
                    [VatType.from_dict(_item) for _item in obj["vat_types_list"]]
                    if obj.get("vat_types_list") is not None
                    else None
                ),
                "languages_list": (
                    [Language.from_dict(_item) for _item in obj["languages_list"]]
                    if obj.get("languages_list") is not None
                    else None
                ),
            }
        )
        return _obj
