# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.1.0
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
    field_validator,
)
from typing import Any, ClassVar, Dict, List, Optional, Union
from fattureincloud_python_sdk.models.currency import Currency
from fattureincloud_python_sdk.models.document_template import DocumentTemplate
from fattureincloud_python_sdk.models.entity import Entity
from fattureincloud_python_sdk.models.issued_document_ei_data import (
    IssuedDocumentEiData,
)
from fattureincloud_python_sdk.models.issued_document_extra_data import (
    IssuedDocumentExtraData,
)
from fattureincloud_python_sdk.models.issued_document_items_list_item import (
    IssuedDocumentItemsListItem,
)
from fattureincloud_python_sdk.models.issued_document_payments_list_item import (
    IssuedDocumentPaymentsListItem,
)
from fattureincloud_python_sdk.models.issued_document_type import IssuedDocumentType
from fattureincloud_python_sdk.models.language import Language
from fattureincloud_python_sdk.models.payment_method import PaymentMethod
from fattureincloud_python_sdk.models.show_totals_mode import ShowTotalsMode
from typing import Optional, Set
from typing_extensions import Self


class IssuedDocument(BaseModel):
    """
    IssuedDocument
    """  # noqa: E501

    id: Optional[StrictInt] = Field(default=None, description="Issued document id")
    entity: Optional[Entity] = None
    type: Optional[IssuedDocumentType] = None
    number: Optional[StrictInt] = Field(
        default=None,
        description="Issued document number [If not specified, next number is used]",
    )
    numeration: Optional[StrictStr] = Field(
        default=None,
        description="Issued document numeration [Not available if type=delivery_note]",
    )
    var_date: Optional[date] = Field(
        default=None,
        description="Issued document date [defaults to today's date]",
        alias="date",
    )
    year: Optional[StrictInt] = Field(default=None, description="Issued document year")
    currency: Optional[Currency] = None
    language: Optional[Language] = None
    subject: Optional[StrictStr] = Field(
        default=None, description="Issued document subject"
    )
    visible_subject: Optional[StrictStr] = Field(
        default=None, description="Issued document visible subject"
    )
    rc_center: Optional[StrictStr] = Field(
        default=None,
        description="Issued document revenue center [or cost center if type=supplier_order].",
    )
    notes: Optional[StrictStr] = Field(
        default=None, description="Issued document extra notes"
    )
    rivalsa: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description='Issued document "Rivalsa INPS" percentual value'
    )
    cassa: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description='Issued document "Cassa previdenziale" percentual value',
    )
    amount_cassa: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="[Read Only] Issued document cassa amount."
    )
    cassa_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Issued document cassa taxable percentage"
    )
    amount_cassa_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="[Can be set only if cassa_taxable is NULL] Issued document cassa taxable amount",
    )
    cassa2: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description='Issued document "Cassa previdenziale 2" percentual value',
    )
    amount_cassa2: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="[Read Only] Issued document cassa2 amount"
    )
    cassa2_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Issued document cassa2 taxable percentage"
    )
    amount_cassa2_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="[Can be set only if cassa2_taxable is NULL] Issued document cassa2 taxable amount",
    )
    global_cassa_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Issued document global cassa taxable percentage"
    )
    amount_global_cassa_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="[Can be set only if global_cassa_taxable is NULL] Issued document global cassa taxable amount",
    )
    withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="Issued document withholding tax (ritenuta d'acconto) percentual value",
    )
    withholding_tax_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="Issued document withholding tax taxable (imponibile) percentual value",
    )
    other_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="Issued document other withholding tax (altra ritenuta) percentual value",
    )
    stamp_duty: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Issued document stamp duty value [0 if not present]"
    )
    payment_method: Optional[PaymentMethod] = None
    use_split_payment: Optional[StrictBool] = Field(
        default=None, description="Issued document uses split payment"
    )
    use_gross_prices: Optional[StrictBool] = Field(
        default=None, description="Issued document uses gross prices"
    )
    e_invoice: Optional[StrictBool] = Field(
        default=None, description="Issued document is an e-invoice."
    )
    ei_data: Optional[IssuedDocumentEiData] = None
    ei_cassa_type: Optional[StrictStr] = Field(
        default=None, description="E-invoice cassa type"
    )
    ei_cassa2_type: Optional[StrictStr] = Field(
        default=None, description="E-invoice cassa2 type"
    )
    ei_withholding_tax_causal: Optional[StrictStr] = Field(
        default=None, description="E-invoice withholding tax causal"
    )
    ei_other_withholding_tax_type: Optional[StrictStr] = Field(
        default=None, description="E-invoice other withholding tax type"
    )
    ei_other_withholding_tax_causal: Optional[StrictStr] = Field(
        default=None, description="E-invoice other withholding tax causal"
    )
    items_list: Optional[List[IssuedDocumentItemsListItem]] = None
    payments_list: Optional[List[IssuedDocumentPaymentsListItem]] = None
    template: Optional[DocumentTemplate] = None
    delivery_note_template: Optional[DocumentTemplate] = None
    acc_inv_template: Optional[DocumentTemplate] = None
    h_margins: Optional[StrictInt] = Field(
        default=None, description="Issued document PDF horizontal margins"
    )
    v_margins: Optional[StrictInt] = Field(
        default=None, description="Issued document PDF vertical margins"
    )
    show_payments: Optional[StrictBool] = Field(
        default=None,
        description="Show the expiration dates of the payments on the document",
    )
    show_payment_method: Optional[StrictBool] = Field(
        default=None, description="Show the payment method details on the document"
    )
    show_totals: Optional[ShowTotalsMode] = None
    show_notification_button: Optional[StrictBool] = Field(
        default=None, description="Show notification button in the PDF"
    )
    show_tspay_button: Optional[StrictBool] = Field(
        default=None, description="Show ts pay button in the PDF"
    )
    delivery_note: Optional[StrictBool] = Field(
        default=None, description="Issued document has delivery note"
    )
    accompanying_invoice: Optional[StrictBool] = Field(
        default=None, description="Issued document has an accompanying invoice"
    )
    dn_number: Optional[StrictInt] = Field(
        default=None, description="Issued document attached delivery note number"
    )
    dn_date: Optional[date] = Field(
        default=None, description="Issued document attached delivery note date"
    )
    dn_ai_packages_number: Optional[StrictStr] = Field(
        default=None,
        description="Issued document attached delivery note number of packages",
    )
    dn_ai_weight: Optional[StrictStr] = Field(
        default=None,
        description="Issued document attached delivery note package weight",
    )
    dn_ai_causal: Optional[StrictStr] = Field(
        default=None, description="Issued document attached delivery note causal"
    )
    dn_ai_destination: Optional[StrictStr] = Field(
        default=None, description="Issued document attached delivery note destination"
    )
    dn_ai_transporter: Optional[StrictStr] = Field(
        default=None, description="Issued document attached delivery note transporter"
    )
    dn_ai_notes: Optional[StrictStr] = Field(
        default=None, description="Issued document attached delivery note notes"
    )
    is_marked: Optional[StrictBool] = Field(
        default=None, description="Issued document is marked"
    )
    amount_net: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="[Read only] Issued document total net amount"
    )
    amount_vat: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="[Read Only] Issued document total vat amount"
    )
    amount_gross: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="[Read Only] Issued document total gross amount"
    )
    amount_due_discount: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Issued document amount due discount"
    )
    amount_rivalsa: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="[Read Only] Issued document rivalsa amount"
    )
    amount_rivalsa_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Issued document taxable rivalsa amount"
    )
    amount_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="[Read Only] Issued document withholding tax amount (ritenuta d'acconto).",
    )
    amount_withholding_tax_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Issued document taxable withholding tax amount"
    )
    amount_other_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="[Read Only] Issued document other withholding tax amount (altra ritenuta)",
    )
    amount_other_withholding_tax_taxable: Optional[Union[StrictFloat, StrictInt]] = (
        Field(
            default=None,
            description="Issued document taxable other withholding tax amount",
        )
    )
    amount_enasarco_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Issued document taxable enasarco amount"
    )
    extra_data: Optional[IssuedDocumentExtraData] = None
    seen_date: Optional[date] = Field(
        default=None, description="Issued document seen date"
    )
    next_due_date: Optional[date] = Field(
        default=None, description="Issued document date of the next not paid payment"
    )
    url: Optional[StrictStr] = Field(
        default=None,
        description="[Temporary] [Read Only] Issued document url of the document PDF file",
    )
    dn_url: Optional[StrictStr] = Field(
        default=None,
        description="[Temporary] [Read Only] Issued document url of the attached delivery note PDF file",
    )
    ai_url: Optional[StrictStr] = Field(
        default=None,
        description="[Temporary] [Read Only] Issued document url of the accompanying invoice PDF file",
    )
    attachment_url: Optional[StrictStr] = Field(
        default=None,
        description="[Temporary] [Read Only] Issued document url of the attached file",
    )
    attachment_token: Optional[StrictStr] = Field(
        default=None,
        description="[Write Only] Issued document attachment token returned by POST /issued_documents/attachment",
    )
    ei_raw: Optional[Dict[str, Any]] = Field(
        default=None,
        description="Issued document advanced raw attributes for e-invoices",
    )
    ei_status: Optional[StrictStr] = Field(
        default=None,
        description="[Read only] Status of the e-invoice.   * **attempt** - We are trying to send the invoice, please wait up to 2 hours   * **missing** - The invoice is missing   * **not_sent** - The invoice has yet to be sent   * **sent** - The invoice was sent   * **pending** - The checks for the digital signature and sending are in progress   * **processing** - The SDI is delivering the invoice to the customer   * **error** - An error occurred while handling the invoice, please try to resend it or contact support   * **discarded** - The invoice has been rejected by the SDI, so it must be corrected and re-sent   * **not_delivered** - The SDI was unable to deliver the invoice   * **accepted** - The customer accepted the invoice   * **rejected** - The customer rejected the invoice, so it must be corrected   * **no_response** - A response has not yet been received whithin the deadline, contact the customer to ascertain the status of the invoice   * **manual_accepted** - The customer accepted the invoice   * **manual_rejected** - The customer rejected the invoice ",
    )
    locked: Optional[StrictBool] = Field(
        default=None, description="Issued Document can't be edited"
    )
    created_at: Optional[StrictStr] = Field(
        default=None, description="Issued document creation date"
    )
    updated_at: Optional[StrictStr] = Field(
        default=None, description="Issued document last update date"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "entity",
        "type",
        "number",
        "numeration",
        "date",
        "year",
        "currency",
        "language",
        "subject",
        "visible_subject",
        "rc_center",
        "notes",
        "rivalsa",
        "cassa",
        "amount_cassa",
        "cassa_taxable",
        "amount_cassa_taxable",
        "cassa2",
        "amount_cassa2",
        "cassa2_taxable",
        "amount_cassa2_taxable",
        "global_cassa_taxable",
        "amount_global_cassa_taxable",
        "withholding_tax",
        "withholding_tax_taxable",
        "other_withholding_tax",
        "stamp_duty",
        "payment_method",
        "use_split_payment",
        "use_gross_prices",
        "e_invoice",
        "ei_data",
        "ei_cassa_type",
        "ei_cassa2_type",
        "ei_withholding_tax_causal",
        "ei_other_withholding_tax_type",
        "ei_other_withholding_tax_causal",
        "items_list",
        "payments_list",
        "template",
        "delivery_note_template",
        "acc_inv_template",
        "h_margins",
        "v_margins",
        "show_payments",
        "show_payment_method",
        "show_totals",
        "show_notification_button",
        "show_tspay_button",
        "delivery_note",
        "accompanying_invoice",
        "dn_number",
        "dn_date",
        "dn_ai_packages_number",
        "dn_ai_weight",
        "dn_ai_causal",
        "dn_ai_destination",
        "dn_ai_transporter",
        "dn_ai_notes",
        "is_marked",
        "amount_net",
        "amount_vat",
        "amount_gross",
        "amount_due_discount",
        "amount_rivalsa",
        "amount_rivalsa_taxable",
        "amount_withholding_tax",
        "amount_withholding_tax_taxable",
        "amount_other_withholding_tax",
        "amount_other_withholding_tax_taxable",
        "amount_enasarco_taxable",
        "extra_data",
        "seen_date",
        "next_due_date",
        "url",
        "dn_url",
        "ai_url",
        "attachment_url",
        "attachment_token",
        "ei_raw",
        "ei_status",
        "locked",
        "created_at",
        "updated_at",
    ]

    @field_validator("ei_status")
    def ei_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "attempt",
                "missing",
                "not_sent",
                "sent",
                "pending",
                "processing",
                "error",
                "discarded",
                "not_delivered",
                "accepted",
                "rejected",
                "no_response",
                "manual_accepted",
                "manual_rejected",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('attempt', 'missing', 'not_sent', 'sent', 'pending', 'processing', 'error', 'discarded', 'not_delivered', 'accepted', 'rejected', 'no_response', 'manual_accepted', 'manual_rejected')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuedDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "amount_cassa",
                "amount_cassa2",
                "amount_net",
                "amount_vat",
                "amount_gross",
                "amount_rivalsa",
                "amount_withholding_tax",
                "amount_other_withholding_tax",
                "attachment_url",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of currency
        if self.currency:
            _dict["currency"] = self.currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of language
        if self.language:
            _dict["language"] = self.language.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_method
        if self.payment_method:
            _dict["payment_method"] = self.payment_method.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ei_data
        if self.ei_data:
            _dict["ei_data"] = self.ei_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items_list (list)
        _items = []
        if self.items_list:
            for _item in self.items_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["items_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments_list (list)
        _items = []
        if self.payments_list:
            for _item in self.payments_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["payments_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of template
        if self.template:
            _dict["template"] = self.template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_note_template
        if self.delivery_note_template:
            _dict["delivery_note_template"] = self.delivery_note_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of acc_inv_template
        if self.acc_inv_template:
            _dict["acc_inv_template"] = self.acc_inv_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extra_data
        if self.extra_data:
            _dict["extra_data"] = self.extra_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuedDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "entity": (
                    Entity.from_dict(obj["entity"])
                    if obj.get("entity") is not None
                    else None
                ),
                "type": obj.get("type"),
                "number": obj.get("number"),
                "numeration": obj.get("numeration"),
                "date": obj.get("date"),
                "year": obj.get("year"),
                "currency": (
                    Currency.from_dict(obj["currency"])
                    if obj.get("currency") is not None
                    else None
                ),
                "language": (
                    Language.from_dict(obj["language"])
                    if obj.get("language") is not None
                    else None
                ),
                "subject": obj.get("subject"),
                "visible_subject": obj.get("visible_subject"),
                "rc_center": obj.get("rc_center"),
                "notes": obj.get("notes"),
                "rivalsa": obj.get("rivalsa"),
                "cassa": obj.get("cassa"),
                "amount_cassa": obj.get("amount_cassa"),
                "cassa_taxable": obj.get("cassa_taxable"),
                "amount_cassa_taxable": obj.get("amount_cassa_taxable"),
                "cassa2": obj.get("cassa2"),
                "amount_cassa2": obj.get("amount_cassa2"),
                "cassa2_taxable": obj.get("cassa2_taxable"),
                "amount_cassa2_taxable": obj.get("amount_cassa2_taxable"),
                "global_cassa_taxable": obj.get("global_cassa_taxable"),
                "amount_global_cassa_taxable": obj.get("amount_global_cassa_taxable"),
                "withholding_tax": obj.get("withholding_tax"),
                "withholding_tax_taxable": obj.get("withholding_tax_taxable"),
                "other_withholding_tax": obj.get("other_withholding_tax"),
                "stamp_duty": obj.get("stamp_duty"),
                "payment_method": (
                    PaymentMethod.from_dict(obj["payment_method"])
                    if obj.get("payment_method") is not None
                    else None
                ),
                "use_split_payment": obj.get("use_split_payment"),
                "use_gross_prices": obj.get("use_gross_prices"),
                "e_invoice": obj.get("e_invoice"),
                "ei_data": (
                    IssuedDocumentEiData.from_dict(obj["ei_data"])
                    if obj.get("ei_data") is not None
                    else None
                ),
                "ei_cassa_type": obj.get("ei_cassa_type"),
                "ei_cassa2_type": obj.get("ei_cassa2_type"),
                "ei_withholding_tax_causal": obj.get("ei_withholding_tax_causal"),
                "ei_other_withholding_tax_type": obj.get(
                    "ei_other_withholding_tax_type"
                ),
                "ei_other_withholding_tax_causal": obj.get(
                    "ei_other_withholding_tax_causal"
                ),
                "items_list": (
                    [
                        IssuedDocumentItemsListItem.from_dict(_item)
                        for _item in obj["items_list"]
                    ]
                    if obj.get("items_list") is not None
                    else None
                ),
                "payments_list": (
                    [
                        IssuedDocumentPaymentsListItem.from_dict(_item)
                        for _item in obj["payments_list"]
                    ]
                    if obj.get("payments_list") is not None
                    else None
                ),
                "template": (
                    DocumentTemplate.from_dict(obj["template"])
                    if obj.get("template") is not None
                    else None
                ),
                "delivery_note_template": (
                    DocumentTemplate.from_dict(obj["delivery_note_template"])
                    if obj.get("delivery_note_template") is not None
                    else None
                ),
                "acc_inv_template": (
                    DocumentTemplate.from_dict(obj["acc_inv_template"])
                    if obj.get("acc_inv_template") is not None
                    else None
                ),
                "h_margins": obj.get("h_margins"),
                "v_margins": obj.get("v_margins"),
                "show_payments": obj.get("show_payments"),
                "show_payment_method": obj.get("show_payment_method"),
                "show_totals": obj.get("show_totals"),
                "show_notification_button": obj.get("show_notification_button"),
                "show_tspay_button": obj.get("show_tspay_button"),
                "delivery_note": obj.get("delivery_note"),
                "accompanying_invoice": obj.get("accompanying_invoice"),
                "dn_number": obj.get("dn_number"),
                "dn_date": obj.get("dn_date"),
                "dn_ai_packages_number": obj.get("dn_ai_packages_number"),
                "dn_ai_weight": obj.get("dn_ai_weight"),
                "dn_ai_causal": obj.get("dn_ai_causal"),
                "dn_ai_destination": obj.get("dn_ai_destination"),
                "dn_ai_transporter": obj.get("dn_ai_transporter"),
                "dn_ai_notes": obj.get("dn_ai_notes"),
                "is_marked": obj.get("is_marked"),
                "amount_net": obj.get("amount_net"),
                "amount_vat": obj.get("amount_vat"),
                "amount_gross": obj.get("amount_gross"),
                "amount_due_discount": obj.get("amount_due_discount"),
                "amount_rivalsa": obj.get("amount_rivalsa"),
                "amount_rivalsa_taxable": obj.get("amount_rivalsa_taxable"),
                "amount_withholding_tax": obj.get("amount_withholding_tax"),
                "amount_withholding_tax_taxable": obj.get(
                    "amount_withholding_tax_taxable"
                ),
                "amount_other_withholding_tax": obj.get("amount_other_withholding_tax"),
                "amount_other_withholding_tax_taxable": obj.get(
                    "amount_other_withholding_tax_taxable"
                ),
                "amount_enasarco_taxable": obj.get("amount_enasarco_taxable"),
                "extra_data": (
                    IssuedDocumentExtraData.from_dict(obj["extra_data"])
                    if obj.get("extra_data") is not None
                    else None
                ),
                "seen_date": obj.get("seen_date"),
                "next_due_date": obj.get("next_due_date"),
                "url": obj.get("url"),
                "dn_url": obj.get("dn_url"),
                "ai_url": obj.get("ai_url"),
                "attachment_url": obj.get("attachment_url"),
                "attachment_token": obj.get("attachment_token"),
                "ei_raw": obj.get("ei_raw"),
                "ei_status": obj.get("ei_status"),
                "locked": obj.get("locked"),
                "created_at": obj.get("created_at"),
                "updated_at": obj.get("updated_at"),
            }
        )
        return _obj
