# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.1.0
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
)
from typing import Any, ClassVar, Dict, List, Optional, Union
from fattureincloud_python_sdk.models.currency import Currency
from fattureincloud_python_sdk.models.entity import Entity
from fattureincloud_python_sdk.models.received_document_items_list_item import (
    ReceivedDocumentItemsListItem,
)
from fattureincloud_python_sdk.models.received_document_payments_list_item import (
    ReceivedDocumentPaymentsListItem,
)
from fattureincloud_python_sdk.models.received_document_type import ReceivedDocumentType
from typing import Optional, Set
from typing_extensions import Self


class ReceivedDocument(BaseModel):
    """
    ReceivedDocument
    """  # noqa: E501

    id: Optional[StrictInt] = Field(default=None, description="Received document id")
    type: Optional[ReceivedDocumentType] = None
    entity: Optional[Entity] = None
    var_date: Optional[date] = Field(
        default=None,
        description="Received document date [defaults to today's date]",
        alias="date",
    )
    category: Optional[StrictStr] = Field(
        default=None, description="Received document category"
    )
    description: Optional[StrictStr] = Field(
        default=None, description="Received document description"
    )
    amount_net: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Received document total net amount"
    )
    amount_vat: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Received document total vat amount"
    )
    amount_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Received document withholding tax amount"
    )
    amount_other_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Received document other withholding tax amount"
    )
    amount_gross: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="[Read Only] Received document total gross amount"
    )
    amortization: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Received document amortization value"
    )
    rc_center: Optional[StrictStr] = Field(
        default=None, description="Received document revenue center"
    )
    invoice_number: Optional[StrictStr] = Field(
        default=None, description="Received document invoice number"
    )
    is_marked: Optional[StrictBool] = Field(
        default=None, description="Received document is marked"
    )
    is_detailed: Optional[StrictBool] = Field(
        default=None, description="Received document has items"
    )
    e_invoice: Optional[StrictBool] = Field(
        default=None, description="[Read Only] Received document is an e-invoice"
    )
    next_due_date: Optional[date] = Field(
        default=None,
        description="[Read Only] Received document date of the next not paid payment",
    )
    currency: Optional[Currency] = None
    tax_deductibility: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Received document tax deducibility percentage"
    )
    vat_deductibility: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Received document vat deducibility percentage"
    )
    items_list: Optional[List[ReceivedDocumentItemsListItem]] = None
    payments_list: Optional[List[ReceivedDocumentPaymentsListItem]] = None
    attachment_url: Optional[StrictStr] = Field(
        default=None,
        description="[Temporary] [Read Only] Received document url of the attached file",
    )
    attachment_preview_url: Optional[StrictStr] = Field(
        default=None,
        description="[Temporary] [Read Only] Received document url of the attachment preview",
    )
    auto_calculate: Optional[StrictBool] = Field(
        default=None,
        description="Received document total items amount and total payments amount can differ if this field is set to false",
    )
    attachment_token: Optional[StrictStr] = Field(
        default=None,
        description="[Write Only] Received document attachment token returned by POST /received_documents/attachment",
    )
    locked: Optional[StrictBool] = Field(
        default=None, description="Received Document can't be edited"
    )
    created_at: Optional[StrictStr] = Field(
        default=None, description="Received document creation date"
    )
    updated_at: Optional[StrictStr] = Field(
        default=None, description="Received document last update date"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "type",
        "entity",
        "date",
        "category",
        "description",
        "amount_net",
        "amount_vat",
        "amount_withholding_tax",
        "amount_other_withholding_tax",
        "amount_gross",
        "amortization",
        "rc_center",
        "invoice_number",
        "is_marked",
        "is_detailed",
        "e_invoice",
        "next_due_date",
        "currency",
        "tax_deductibility",
        "vat_deductibility",
        "items_list",
        "payments_list",
        "attachment_url",
        "attachment_preview_url",
        "auto_calculate",
        "attachment_token",
        "locked",
        "created_at",
        "updated_at",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReceivedDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "amount_gross",
                "next_due_date",
                "attachment_url",
                "attachment_preview_url",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of currency
        if self.currency:
            _dict["currency"] = self.currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items_list (list)
        _items = []
        if self.items_list:
            for _item in self.items_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["items_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments_list (list)
        _items = []
        if self.payments_list:
            for _item in self.payments_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["payments_list"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReceivedDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "type": obj.get("type"),
                "entity": (
                    Entity.from_dict(obj["entity"])
                    if obj.get("entity") is not None
                    else None
                ),
                "date": obj.get("date"),
                "category": obj.get("category"),
                "description": obj.get("description"),
                "amount_net": obj.get("amount_net"),
                "amount_vat": obj.get("amount_vat"),
                "amount_withholding_tax": obj.get("amount_withholding_tax"),
                "amount_other_withholding_tax": obj.get("amount_other_withholding_tax"),
                "amount_gross": obj.get("amount_gross"),
                "amortization": obj.get("amortization"),
                "rc_center": obj.get("rc_center"),
                "invoice_number": obj.get("invoice_number"),
                "is_marked": obj.get("is_marked"),
                "is_detailed": obj.get("is_detailed"),
                "e_invoice": obj.get("e_invoice"),
                "next_due_date": obj.get("next_due_date"),
                "currency": (
                    Currency.from_dict(obj["currency"])
                    if obj.get("currency") is not None
                    else None
                ),
                "tax_deductibility": obj.get("tax_deductibility"),
                "vat_deductibility": obj.get("vat_deductibility"),
                "items_list": (
                    [
                        ReceivedDocumentItemsListItem.from_dict(_item)
                        for _item in obj["items_list"]
                    ]
                    if obj.get("items_list") is not None
                    else None
                ),
                "payments_list": (
                    [
                        ReceivedDocumentPaymentsListItem.from_dict(_item)
                        for _item in obj["payments_list"]
                    ]
                    if obj.get("payments_list") is not None
                    else None
                ),
                "attachment_url": obj.get("attachment_url"),
                "attachment_preview_url": obj.get("attachment_preview_url"),
                "auto_calculate": obj.get("auto_calculate"),
                "attachment_token": obj.get("attachment_token"),
                "locked": obj.get("locked"),
                "created_at": obj.get("created_at"),
                "updated_at": obj.get("updated_at"),
            }
        )
        return _obj
