# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.1.0
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class CompanyInfoPlanInfoFunctions(BaseModel):
    """
    Access to functions for this company.
    """  # noqa: E501

    archive: Optional[StrictBool] = None
    cerved: Optional[StrictBool] = None
    document_attachments: Optional[StrictBool] = None
    e_invoice: Optional[StrictBool] = None
    genius: Optional[StrictBool] = None
    mail_tracking: Optional[StrictBool] = None
    payment_notifications: Optional[StrictBool] = None
    paypal: Optional[StrictBool] = None
    receipts: Optional[StrictBool] = None
    recurring: Optional[StrictBool] = None
    smtp: Optional[StrictBool] = None
    sofort: Optional[StrictBool] = None
    stock: Optional[StrictBool] = None
    subaccounts: Optional[StrictBool] = None
    tessera_sanitaria: Optional[StrictBool] = None
    ts_digital: Optional[StrictBool] = None
    ts_invoice_trading: Optional[StrictBool] = None
    ts_pay: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = [
        "archive",
        "cerved",
        "document_attachments",
        "e_invoice",
        "genius",
        "mail_tracking",
        "payment_notifications",
        "paypal",
        "receipts",
        "recurring",
        "smtp",
        "sofort",
        "stock",
        "subaccounts",
        "tessera_sanitaria",
        "ts_digital",
        "ts_invoice_trading",
        "ts_pay",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompanyInfoPlanInfoFunctions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompanyInfoPlanInfoFunctions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "archive": obj.get("archive"),
                "cerved": obj.get("cerved"),
                "document_attachments": obj.get("document_attachments"),
                "e_invoice": obj.get("e_invoice"),
                "genius": obj.get("genius"),
                "mail_tracking": obj.get("mail_tracking"),
                "payment_notifications": obj.get("payment_notifications"),
                "paypal": obj.get("paypal"),
                "receipts": obj.get("receipts"),
                "recurring": obj.get("recurring"),
                "smtp": obj.get("smtp"),
                "sofort": obj.get("sofort"),
                "stock": obj.get("stock"),
                "subaccounts": obj.get("subaccounts"),
                "tessera_sanitaria": obj.get("tessera_sanitaria"),
                "ts_digital": obj.get("ts_digital"),
                "ts_invoice_trading": obj.get("ts_invoice_trading"),
                "ts_pay": obj.get("ts_pay"),
            }
        )
        return _obj
