"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.9
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""

import json
import sys
import unittest
import datetime
import fattureincloud_python_sdk
from functions import json_serial
from functions import create_from_json
from fattureincloud_python_sdk.models.issued_document import IssuedDocument
from fattureincloud_python_sdk.models.list_issued_documents_response_page import (
    ListIssuedDocumentsResponsePage,
)
from fattureincloud_python_sdk.models.pagination import Pagination
from fattureincloud_python_sdk.models.issued_document_type import IssuedDocumentType

globals()["IssuedDocument"] = IssuedDocument
globals()["ListIssuedDocumentsResponsePage"] = ListIssuedDocumentsResponsePage
globals()["Pagination"] = Pagination
from fattureincloud_python_sdk.models.list_issued_documents_response import (
    ListIssuedDocumentsResponse,
)


class TestListIssuedDocumentsResponse(unittest.TestCase):
    """ListIssuedDocumentsResponse unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testListIssuedDocumentsResponse(self):
        """Test ListIssuedDocumentsResponse"""
        model = ListIssuedDocumentsResponse(
            data=[
                IssuedDocument(
                    id=1,
                    type=IssuedDocumentType("invoice"),
                    number=1,
                    numeration="/A",
                    date=datetime.datetime.strptime("2022-01-01", "%Y-%m-%d").date(),
                    year=1,
                    subject="subject_example",
                    visible_subject="visible_subject_example",
                    rc_center="rc_center_example",
                    notes="notes_example",
                    rivalsa=0.0,
                    cassa=0.0,
                    cassa_taxable=0.0,
                    amount_cassa_taxable=3.14,
                    cassa2=0.0,
                    cassa2_taxable=0.0,
                    amount_cassa2_taxable=3.14,
                    global_cassa_taxable=0.0,
                    amount_global_cassa_taxable=3.14,
                ),
                IssuedDocument(
                    id=2,
                    type=IssuedDocumentType("invoice"),
                    number=2,
                    numeration="/A",
                    date=datetime.datetime.strptime("2022-01-02", "%Y-%m-%d").date(),
                    year=1,
                    subject="subject_example",
                    visible_subject="visible_subject_example",
                    rc_center="rc_center_example",
                    notes="notes_example",
                    rivalsa=0.0,
                    cassa=0.0,
                    cassa_taxable=0.0,
                    amount_cassa_taxable=3.14,
                    cassa2=0.0,
                    cassa2_taxable=0.0,
                    amount_cassa2_taxable=3.14,
                    global_cassa_taxable=0.0,
                    amount_global_cassa_taxable=3.14,
                ),
            ],
            current_page=10,
            first_page_url="http://url.com",
            last_page=10,
            last_page_url="http://url.com",
            next_page_url="http://url.com",
            path="http://url.com",
            per_page=10,
            prev_page_url="http://url.com",
            to=10,
            total=10,
        )
        expected_json = '{"current_page": 10, "first_page_url": "http://url.com", "last_page": 10, "last_page_url": "http://url.com", "next_page_url": "http://url.com", "path": "http://url.com", "per_page": 10, "prev_page_url": "http://url.com", "to": 10, "total": 10, "data": [{"id": 1, "type": "invoice", "number": 1, "numeration": "/A", "date": "2022-01-01", "year": 1, "subject": "subject_example", "visible_subject": "visible_subject_example", "rc_center": "rc_center_example", "notes": "notes_example", "rivalsa": 0.0, "cassa": 0.0, "cassa_taxable": 0.0, "amount_cassa_taxable": 3.14, "cassa2": 0.0, "cassa2_taxable": 0.0, "amount_cassa2_taxable": 3.14, "global_cassa_taxable": 0.0, "amount_global_cassa_taxable": 3.14}, {"id": 2, "type": "invoice", "number": 2, "numeration": "/A", "date": "2022-01-02", "year": 1, "subject": "subject_example", "visible_subject": "visible_subject_example", "rc_center": "rc_center_example", "notes": "notes_example", "rivalsa": 0.0, "cassa": 0.0, "cassa_taxable": 0.0, "amount_cassa_taxable": 3.14, "cassa2": 0.0, "cassa2_taxable": 0.0, "amount_cassa2_taxable": 3.14, "global_cassa_taxable": 0.0, "amount_global_cassa_taxable": 3.14}]}'
        actual_json = json.dumps(model.to_dict(), default=json_serial)
        assert actual_json == expected_json


if __name__ == "__main__":
    unittest.main()
