# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.1.2
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fattureincloud_python_sdk.models.email_data_default_sender_email import (
    EmailDataDefaultSenderEmail,
)
from fattureincloud_python_sdk.models.sender_email import SenderEmail
from typing import Optional, Set
from typing_extensions import Self


class EmailData(BaseModel):
    """
    EmailData
    """  # noqa: E501

    recipient_email: Optional[StrictStr] = Field(
        default=None, description="Email recipient"
    )
    default_sender_email: Optional[EmailDataDefaultSenderEmail] = None
    sender_emails_list: Optional[List[SenderEmail]] = Field(
        default=None,
        description="List of all emails from which the document can be sent",
    )
    cc_email: Optional[StrictStr] = Field(
        default=None, description="Email cc [by default is the logged company email]"
    )
    subject: Optional[StrictStr] = Field(default=None, description="Email subject")
    body: Optional[StrictStr] = Field(default=None, description="Email body")
    document_exists: Optional[StrictBool] = Field(
        default=None, description="Document exists if it is not a delivery note"
    )
    delivery_note_exists: Optional[StrictBool] = Field(
        default=None, description="Document is a delivery note"
    )
    attachment_exists: Optional[StrictBool] = Field(
        default=None, description="Document has attachment"
    )
    accompanying_invoice_exists: Optional[StrictBool] = Field(
        default=None, description="Document has accompanying invoice"
    )
    default_attach_pdf: Optional[StrictBool] = Field(
        default=None, description="Attach document pdf"
    )
    __properties: ClassVar[List[str]] = [
        "recipient_email",
        "default_sender_email",
        "sender_emails_list",
        "cc_email",
        "subject",
        "body",
        "document_exists",
        "delivery_note_exists",
        "attachment_exists",
        "accompanying_invoice_exists",
        "default_attach_pdf",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_sender_email
        if self.default_sender_email:
            _dict["default_sender_email"] = self.default_sender_email.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sender_emails_list (list)
        _items = []
        if self.sender_emails_list:
            for _item_sender_emails_list in self.sender_emails_list:
                if _item_sender_emails_list:
                    _items.append(_item_sender_emails_list.to_dict())
            _dict["sender_emails_list"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "recipient_email": obj.get("recipient_email"),
                "default_sender_email": (
                    EmailDataDefaultSenderEmail.from_dict(obj["default_sender_email"])
                    if obj.get("default_sender_email") is not None
                    else None
                ),
                "sender_emails_list": (
                    [
                        SenderEmail.from_dict(_item)
                        for _item in obj["sender_emails_list"]
                    ]
                    if obj.get("sender_emails_list") is not None
                    else None
                ),
                "cc_email": obj.get("cc_email"),
                "subject": obj.get("subject"),
                "body": obj.get("body"),
                "document_exists": obj.get("document_exists"),
                "delivery_note_exists": obj.get("delivery_note_exists"),
                "attachment_exists": obj.get("attachment_exists"),
                "accompanying_invoice_exists": obj.get("accompanying_invoice_exists"),
                "default_attach_pdf": obj.get("default_attach_pdf"),
            }
        )
        return _obj
