# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.1.2
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
)
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self


class IssuedDocumentExtraData(BaseModel):
    """
    Issued document extra data [TS fields follow the technical specifications provided by \"Sistema Tessera Sanitaria\"]
    """  # noqa: E501

    multifatture_sent: Optional[StrictInt] = None
    ts_communication: Optional[StrictBool] = Field(
        default=None, description='Send issued document to "Sistema Tessera Sanitaria"'
    )
    ts_flag_tipo_spesa: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description='Issued document ts "tipo spesa" [TK, FC, FV, SV,SP, AD, AS, ECG, SR]',
    )
    ts_pagamento_tracciato: Optional[StrictBool] = Field(
        default=None, description="Issued document ts traced payment"
    )
    ts_tipo_spesa: Optional[StrictStr] = Field(
        default=None,
        description="Can be [ 'TK', 'FC', 'FV', 'SV', 'SP', 'AD', 'AS', 'SR', 'CT', 'PI', 'IC', 'AA' ]. Refer to the technical specifications to learn more.",
    )
    ts_opposizione: Optional[StrictBool] = Field(
        default=None, description='Issued document ts "opposizione"'
    )
    ts_status: Optional[StrictInt] = Field(
        default=None, description="Issued document ts status"
    )
    ts_file_id: Optional[StrictStr] = Field(
        default=None, description="Issued document ts file id"
    )
    ts_sent_date: Optional[date] = Field(
        default=None, description="Issued document ts sent date"
    )
    ts_full_amount: Optional[StrictBool] = Field(
        default=None, description="Issued document ts total amount"
    )
    imported_by: Optional[StrictStr] = Field(
        default=None, description="Issued document imported by software"
    )
    __properties: ClassVar[List[str]] = [
        "multifatture_sent",
        "ts_communication",
        "ts_flag_tipo_spesa",
        "ts_pagamento_tracciato",
        "ts_tipo_spesa",
        "ts_opposizione",
        "ts_status",
        "ts_file_id",
        "ts_sent_date",
        "ts_full_amount",
        "imported_by",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuedDocumentExtraData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuedDocumentExtraData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "multifatture_sent": obj.get("multifatture_sent"),
                "ts_communication": obj.get("ts_communication"),
                "ts_flag_tipo_spesa": obj.get("ts_flag_tipo_spesa"),
                "ts_pagamento_tracciato": obj.get("ts_pagamento_tracciato"),
                "ts_tipo_spesa": obj.get("ts_tipo_spesa"),
                "ts_opposizione": obj.get("ts_opposizione"),
                "ts_status": obj.get("ts_status"),
                "ts_file_id": obj.get("ts_file_id"),
                "ts_sent_date": obj.get("ts_sent_date"),
                "ts_full_amount": obj.get("ts_full_amount"),
                "imported_by": obj.get("imported_by"),
            }
        )
        return _obj
