# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.1.2
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
)
from typing import Any, ClassVar, Dict, List, Optional, Union
from fattureincloud_python_sdk.models.vat_type import VatType
from typing import Optional, Set
from typing_extensions import Self


class TaxProfile(BaseModel):
    """
    TaxProfile
    """  # noqa: E501

    company_type: Optional[StrictStr] = Field(
        default=None, description="The company type"
    )
    company_subtype: Optional[StrictStr] = Field(
        default=None, description="The company subtype"
    )
    profession: Optional[StrictStr] = Field(default=None, description="The profession")
    regime: Optional[StrictStr] = Field(default=None, description="The applied regime")
    rivalsa_name: Optional[StrictStr] = Field(
        default=None, description="The name of the rivalsa"
    )
    default_rivalsa: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The default rivalsa amount"
    )
    cassa_name: Optional[StrictStr] = Field(
        default=None, description="The name of the cassa"
    )
    default_cassa: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The default cassa amount"
    )
    default_cassa_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The default taxable amount for the cassa"
    )
    cassa2_name: Optional[StrictStr] = Field(
        default=None, description="The name of the second cassa"
    )
    default_cassa2: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The default second cassa amount"
    )
    default_cassa2_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The default taxable amount for the second cassa"
    )
    default_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The default withholding tax"
    )
    default_withholding_tax_taxable: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The default taxable amount for the withholding tax"
    )
    default_other_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The default other withholding tax"
    )
    enasarco: Optional[StrictBool] = Field(
        default=None, description="If it has enasarco"
    )
    enasarco_type: Optional[StrictStr] = Field(
        default=None, description="The enasarco type"
    )
    contributions_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The contributions percentage"
    )
    profit_coefficient: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="The profit coefficient"
    )
    med: Optional[StrictBool] = Field(
        default=None, description="If the health card system is active"
    )
    default_vat: Optional[VatType] = None
    __properties: ClassVar[List[str]] = [
        "company_type",
        "company_subtype",
        "profession",
        "regime",
        "rivalsa_name",
        "default_rivalsa",
        "cassa_name",
        "default_cassa",
        "default_cassa_taxable",
        "cassa2_name",
        "default_cassa2",
        "default_cassa2_taxable",
        "default_withholding_tax",
        "default_withholding_tax_taxable",
        "default_other_withholding_tax",
        "enasarco",
        "enasarco_type",
        "contributions_percentage",
        "profit_coefficient",
        "med",
        "default_vat",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaxProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_vat
        if self.default_vat:
            _dict["default_vat"] = self.default_vat.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaxProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "company_type": obj.get("company_type"),
                "company_subtype": obj.get("company_subtype"),
                "profession": obj.get("profession"),
                "regime": obj.get("regime"),
                "rivalsa_name": obj.get("rivalsa_name"),
                "default_rivalsa": obj.get("default_rivalsa"),
                "cassa_name": obj.get("cassa_name"),
                "default_cassa": obj.get("default_cassa"),
                "default_cassa_taxable": obj.get("default_cassa_taxable"),
                "cassa2_name": obj.get("cassa2_name"),
                "default_cassa2": obj.get("default_cassa2"),
                "default_cassa2_taxable": obj.get("default_cassa2_taxable"),
                "default_withholding_tax": obj.get("default_withholding_tax"),
                "default_withholding_tax_taxable": obj.get(
                    "default_withholding_tax_taxable"
                ),
                "default_other_withholding_tax": obj.get(
                    "default_other_withholding_tax"
                ),
                "enasarco": obj.get("enasarco"),
                "enasarco_type": obj.get("enasarco_type"),
                "contributions_percentage": obj.get("contributions_percentage"),
                "profit_coefficient": obj.get("profit_coefficient"),
                "med": obj.get("med"),
                "default_vat": (
                    VatType.from_dict(obj["default_vat"])
                    if obj.get("default_vat") is not None
                    else None
                ),
            }
        )
        return _obj
