# FattureInCloud Python SDK

[![PyPI](https://img.shields.io/pypi/v/fattureincloud-python-sdk?color=g)](https://pypi.org/project/fattureincloud-python-sdk/) ![unit tests](https://github.com/fattureincloud/fattureincloud-python-sdk/actions/workflows/validate.yaml/badge.svg)

# fattureincloud-python-sdk
Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy. 

The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.1.5
- Package version: 2.1.3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.fattureincloud.it](https://www.fattureincloud.it)

## Requirements.

Python >= 3.7

## Installation & Usage
### pip install

You can install our python package directly using:

```sh
pip install fattureincloud-python-sdk
```
(you may need to run `pip` with root permission: `sudo pip install fattureincloud-python-sdk`)

Then import the package:
```python
import fattureincloud_python_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import fattureincloud_python_sdk
from fattureincloud_python_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api-v2.fattureincloud.it
# See configuration.py for a list of all supported configuration parameters.
configuration = fattureincloud_python_sdk.Configuration(
    host = "https://api-v2.fattureincloud.it"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
with fattureincloud_python_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = fattureincloud_python_sdk.ArchiveApi(api_client)
    company_id = 12345 # int | The ID of the company.
    create_archive_document_request = {"data":{"date":"2021-08-20","category":"Altri documenti","description":"spesa 1","attachment_token":"ibfjdbf94ey9w94g3w894qbasrga"}} # CreateArchiveDocumentRequest | The Archive Document. (optional)

    try:
        # Create Archive Document
        api_response = api_instance.create_archive_document(company_id, create_archive_document_request=create_archive_document_request)
        print("The response of ArchiveApi->create_archive_document:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ArchiveApi->create_archive_document: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api-v2.fattureincloud.it*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ArchiveApi* | [**create_archive_document**](docs/ArchiveApi.md#create_archive_document) | **POST** /c/{company_id}/archive | Create Archive Document
*ArchiveApi* | [**delete_archive_document**](docs/ArchiveApi.md#delete_archive_document) | **DELETE** /c/{company_id}/archive/{document_id} | Delete Archive Document
*ArchiveApi* | [**get_archive_document**](docs/ArchiveApi.md#get_archive_document) | **GET** /c/{company_id}/archive/{document_id} | Get Archive Document
*ArchiveApi* | [**list_archive_documents**](docs/ArchiveApi.md#list_archive_documents) | **GET** /c/{company_id}/archive | List Archive Documents
*ArchiveApi* | [**modify_archive_document**](docs/ArchiveApi.md#modify_archive_document) | **PUT** /c/{company_id}/archive/{document_id} | Modify Archive Document
*ArchiveApi* | [**upload_archive_document_attachment**](docs/ArchiveApi.md#upload_archive_document_attachment) | **POST** /c/{company_id}/archive/attachment | Upload Archive Document Attachment
*CashbookApi* | [**create_cashbook_entry**](docs/CashbookApi.md#create_cashbook_entry) | **POST** /c/{company_id}/cashbook | Create Cashbook Entry
*CashbookApi* | [**delete_cashbook_entry**](docs/CashbookApi.md#delete_cashbook_entry) | **DELETE** /c/{company_id}/cashbook/{document_id} | Delete Cashbook Entry
*CashbookApi* | [**get_cashbook_entry**](docs/CashbookApi.md#get_cashbook_entry) | **GET** /c/{company_id}/cashbook/{document_id} | Get Cashbook Entry
*CashbookApi* | [**list_cashbook_entries**](docs/CashbookApi.md#list_cashbook_entries) | **GET** /c/{company_id}/cashbook | List Cashbook Entries
*CashbookApi* | [**modify_cashbook_entry**](docs/CashbookApi.md#modify_cashbook_entry) | **PUT** /c/{company_id}/cashbook/{document_id} | Modify Cashbook Entry
*ClientsApi* | [**create_client**](docs/ClientsApi.md#create_client) | **POST** /c/{company_id}/entities/clients | Create Client
*ClientsApi* | [**delete_client**](docs/ClientsApi.md#delete_client) | **DELETE** /c/{company_id}/entities/clients/{client_id} | Delete Client
*ClientsApi* | [**get_client**](docs/ClientsApi.md#get_client) | **GET** /c/{company_id}/entities/clients/{client_id} | Get Client
*ClientsApi* | [**get_client_info**](docs/ClientsApi.md#get_client_info) | **GET** /c/{company_id}/entities/clients/info | Get Client info
*ClientsApi* | [**list_clients**](docs/ClientsApi.md#list_clients) | **GET** /c/{company_id}/entities/clients | List Clients
*ClientsApi* | [**modify_client**](docs/ClientsApi.md#modify_client) | **PUT** /c/{company_id}/entities/clients/{client_id} | Modify Client
*CompaniesApi* | [**get_company_info**](docs/CompaniesApi.md#get_company_info) | **GET** /c/{company_id}/company/info | Get Company Info
*CompaniesApi* | [**get_company_plan_usage**](docs/CompaniesApi.md#get_company_plan_usage) | **GET** /c/{company_id}/company/plan_usage | Get Company Plan Usage
*EmailsApi* | [**list_emails**](docs/EmailsApi.md#list_emails) | **GET** /c/{company_id}/emails | List Emails
*InfoApi* | [**list_archive_categories**](docs/InfoApi.md#list_archive_categories) | **GET** /c/{company_id}/info/archive_categories | List Archive Categories
*InfoApi* | [**list_cities**](docs/InfoApi.md#list_cities) | **GET** /info/cities | List Cities
*InfoApi* | [**list_cost_centers**](docs/InfoApi.md#list_cost_centers) | **GET** /c/{company_id}/info/cost_centers | List Cost Centers
*InfoApi* | [**list_countries**](docs/InfoApi.md#list_countries) | **GET** /info/countries | List Countries
*InfoApi* | [**list_currencies**](docs/InfoApi.md#list_currencies) | **GET** /info/currencies | List Currencies
*InfoApi* | [**list_delivery_notes_default_causals**](docs/InfoApi.md#list_delivery_notes_default_causals) | **GET** /info/dn_causals | List Delivery Notes Default Causals
*InfoApi* | [**list_detailed_countries**](docs/InfoApi.md#list_detailed_countries) | **GET** /info/detailed_countries | List Detailed Countries
*InfoApi* | [**list_languages**](docs/InfoApi.md#list_languages) | **GET** /info/languages | List Languages
*InfoApi* | [**list_payment_accounts**](docs/InfoApi.md#list_payment_accounts) | **GET** /c/{company_id}/info/payment_accounts | List Payment Accounts
*InfoApi* | [**list_payment_methods**](docs/InfoApi.md#list_payment_methods) | **GET** /c/{company_id}/info/payment_methods | List Payment Methods
*InfoApi* | [**list_product_categories**](docs/InfoApi.md#list_product_categories) | **GET** /c/{company_id}/info/product_categories | List Product Categories
*InfoApi* | [**list_received_document_categories**](docs/InfoApi.md#list_received_document_categories) | **GET** /c/{company_id}/info/received_document_categories | List Received Document Categories
*InfoApi* | [**list_revenue_centers**](docs/InfoApi.md#list_revenue_centers) | **GET** /c/{company_id}/info/revenue_centers | List Revenue Centers
*InfoApi* | [**list_templates**](docs/InfoApi.md#list_templates) | **GET** /info/templates | List Templates
*InfoApi* | [**list_units_of_measure**](docs/InfoApi.md#list_units_of_measure) | **GET** /info/measures | List Units of Measure
*InfoApi* | [**list_vat_types**](docs/InfoApi.md#list_vat_types) | **GET** /c/{company_id}/info/vat_types | List Vat Types
*IssuedDocumentsApi* | [**create_issued_document**](docs/IssuedDocumentsApi.md#create_issued_document) | **POST** /c/{company_id}/issued_documents | Create Issued Document
*IssuedDocumentsApi* | [**delete_bin_issued_document**](docs/IssuedDocumentsApi.md#delete_bin_issued_document) | **DELETE** /c/{company_id}/bin/issued_documents/{document_id} | 
*IssuedDocumentsApi* | [**delete_issued_document**](docs/IssuedDocumentsApi.md#delete_issued_document) | **DELETE** /c/{company_id}/issued_documents/{document_id} | Delete Issued Document
*IssuedDocumentsApi* | [**delete_issued_document_attachment**](docs/IssuedDocumentsApi.md#delete_issued_document_attachment) | **DELETE** /c/{company_id}/issued_documents/{document_id}/attachment | Delete Issued Document Attachment
*IssuedDocumentsApi* | [**get_bin_issued_document**](docs/IssuedDocumentsApi.md#get_bin_issued_document) | **GET** /c/{company_id}/bin/issued_documents/{document_id} | Get Bin Issued Documents List
*IssuedDocumentsApi* | [**get_email_data**](docs/IssuedDocumentsApi.md#get_email_data) | **GET** /c/{company_id}/issued_documents/{document_id}/email | Get Email Data
*IssuedDocumentsApi* | [**get_existing_issued_document_totals**](docs/IssuedDocumentsApi.md#get_existing_issued_document_totals) | **POST** /c/{company_id}/issued_documents/{document_id}/totals | Get Existing Issued Document Totals
*IssuedDocumentsApi* | [**get_issued_document**](docs/IssuedDocumentsApi.md#get_issued_document) | **GET** /c/{company_id}/issued_documents/{document_id} | Get Issued Document
*IssuedDocumentsApi* | [**get_issued_document_pre_create_info**](docs/IssuedDocumentsApi.md#get_issued_document_pre_create_info) | **GET** /c/{company_id}/issued_documents/info | Get Issued Document Pre-Create Info
*IssuedDocumentsApi* | [**get_new_issued_document_totals**](docs/IssuedDocumentsApi.md#get_new_issued_document_totals) | **POST** /c/{company_id}/issued_documents/totals | Get New Issued Document Totals
*IssuedDocumentsApi* | [**join_issued_documents**](docs/IssuedDocumentsApi.md#join_issued_documents) | **GET** /c/{company_id}/issued_documents/join | Join Issued Documents
*IssuedDocumentsApi* | [**list_bin_issued_documents**](docs/IssuedDocumentsApi.md#list_bin_issued_documents) | **GET** /c/{company_id}/bin/issued_documents | Get Bin Issued Documents List
*IssuedDocumentsApi* | [**list_issued_documents**](docs/IssuedDocumentsApi.md#list_issued_documents) | **GET** /c/{company_id}/issued_documents | List Issued Documents
*IssuedDocumentsApi* | [**modify_issued_document**](docs/IssuedDocumentsApi.md#modify_issued_document) | **PUT** /c/{company_id}/issued_documents/{document_id} | Modify Issued Document
*IssuedDocumentsApi* | [**recover_bin_issued_document**](docs/IssuedDocumentsApi.md#recover_bin_issued_document) | **POST** /c/{company_id}/bin/issued_documents/{document_id}/recover | 
*IssuedDocumentsApi* | [**schedule_email**](docs/IssuedDocumentsApi.md#schedule_email) | **POST** /c/{company_id}/issued_documents/{document_id}/email | Schedule Email
*IssuedDocumentsApi* | [**transform_issued_document**](docs/IssuedDocumentsApi.md#transform_issued_document) | **GET** /c/{company_id}/issued_documents/transform | Transform Issued Document
*IssuedDocumentsApi* | [**upload_issued_document_attachment**](docs/IssuedDocumentsApi.md#upload_issued_document_attachment) | **POST** /c/{company_id}/issued_documents/attachment | Upload Issued Document Attachment
*IssuedEInvoicesApi* | [**get_e_invoice_rejection_reason**](docs/IssuedEInvoicesApi.md#get_e_invoice_rejection_reason) | **GET** /c/{company_id}/issued_documents/{document_id}/e_invoice/error_reason | Get E-Invoice Rejection Reason
*IssuedEInvoicesApi* | [**get_e_invoice_xml**](docs/IssuedEInvoicesApi.md#get_e_invoice_xml) | **GET** /c/{company_id}/issued_documents/{document_id}/e_invoice/xml | Get E-Invoice XML
*IssuedEInvoicesApi* | [**send_e_invoice**](docs/IssuedEInvoicesApi.md#send_e_invoice) | **POST** /c/{company_id}/issued_documents/{document_id}/e_invoice/send | Send E-Invoice
*IssuedEInvoicesApi* | [**verify_e_invoice_xml**](docs/IssuedEInvoicesApi.md#verify_e_invoice_xml) | **GET** /c/{company_id}/issued_documents/{document_id}/e_invoice/xml_verify | Verify E-Invoice XML
*PriceListsApi* | [**get_price_list_items**](docs/PriceListsApi.md#get_price_list_items) | **GET** /c/{company_id}/price_lists/{price_list_id}/items | Get PriceList Items List
*PriceListsApi* | [**get_price_lists**](docs/PriceListsApi.md#get_price_lists) | **GET** /c/{company_id}/price_lists | Get PriceLists
*ProductsApi* | [**create_product**](docs/ProductsApi.md#create_product) | **POST** /c/{company_id}/products | Create Product
*ProductsApi* | [**delete_product**](docs/ProductsApi.md#delete_product) | **DELETE** /c/{company_id}/products/{product_id} | Delete Product
*ProductsApi* | [**get_product**](docs/ProductsApi.md#get_product) | **GET** /c/{company_id}/products/{product_id} | Get Product
*ProductsApi* | [**list_products**](docs/ProductsApi.md#list_products) | **GET** /c/{company_id}/products | List Products
*ProductsApi* | [**modify_product**](docs/ProductsApi.md#modify_product) | **PUT** /c/{company_id}/products/{product_id} | Modify Product
*ReceiptsApi* | [**create_receipt**](docs/ReceiptsApi.md#create_receipt) | **POST** /c/{company_id}/receipts | Create Receipt
*ReceiptsApi* | [**delete_receipt**](docs/ReceiptsApi.md#delete_receipt) | **DELETE** /c/{company_id}/receipts/{document_id} | Delete Receipt
*ReceiptsApi* | [**get_receipt**](docs/ReceiptsApi.md#get_receipt) | **GET** /c/{company_id}/receipts/{document_id} | Get Receipt
*ReceiptsApi* | [**get_receipt_pre_create_info**](docs/ReceiptsApi.md#get_receipt_pre_create_info) | **GET** /c/{company_id}/receipts/info | Get Receipt Pre-Create Info
*ReceiptsApi* | [**get_receipts_monthly_totals**](docs/ReceiptsApi.md#get_receipts_monthly_totals) | **GET** /c/{company_id}/receipts/monthly_totals | Get Receipts Monthly Totals
*ReceiptsApi* | [**list_receipts**](docs/ReceiptsApi.md#list_receipts) | **GET** /c/{company_id}/receipts | List Receipts
*ReceiptsApi* | [**modify_receipt**](docs/ReceiptsApi.md#modify_receipt) | **PUT** /c/{company_id}/receipts/{document_id} | Modify Receipt
*ReceivedDocumentsApi* | [**create_received_document**](docs/ReceivedDocumentsApi.md#create_received_document) | **POST** /c/{company_id}/received_documents | Create Received Document
*ReceivedDocumentsApi* | [**delete_bin_received_document**](docs/ReceivedDocumentsApi.md#delete_bin_received_document) | **DELETE** /c/{company_id}/bin/received_documents/{document_id} | 
*ReceivedDocumentsApi* | [**delete_received_document**](docs/ReceivedDocumentsApi.md#delete_received_document) | **DELETE** /c/{company_id}/received_documents/{document_id} | Delete Received Document
*ReceivedDocumentsApi* | [**delete_received_document_attachment**](docs/ReceivedDocumentsApi.md#delete_received_document_attachment) | **DELETE** /c/{company_id}/received_documents/{document_id}/attachment | Delete Received Document Attachment
*ReceivedDocumentsApi* | [**get_bin_received_document**](docs/ReceivedDocumentsApi.md#get_bin_received_document) | **GET** /c/{company_id}/bin/received_documents/{document_id} | Get Bin Received Documents List
*ReceivedDocumentsApi* | [**get_existing_received_document_totals**](docs/ReceivedDocumentsApi.md#get_existing_received_document_totals) | **POST** /c/{company_id}/received_documents/{document_id}/totals | Get Existing Received Document Totals
*ReceivedDocumentsApi* | [**get_new_received_document_totals**](docs/ReceivedDocumentsApi.md#get_new_received_document_totals) | **POST** /c/{company_id}/received_documents/totals | Get New Received Document Totals
*ReceivedDocumentsApi* | [**get_received_document**](docs/ReceivedDocumentsApi.md#get_received_document) | **GET** /c/{company_id}/received_documents/{document_id} | Get Received Document
*ReceivedDocumentsApi* | [**get_received_document_pre_create_info**](docs/ReceivedDocumentsApi.md#get_received_document_pre_create_info) | **GET** /c/{company_id}/received_documents/info | Get Received Document Pre-Create Info
*ReceivedDocumentsApi* | [**list_bin_received_documents**](docs/ReceivedDocumentsApi.md#list_bin_received_documents) | **GET** /c/{company_id}/bin/received_documents | Get Bin Received Documents List
*ReceivedDocumentsApi* | [**list_received_documents**](docs/ReceivedDocumentsApi.md#list_received_documents) | **GET** /c/{company_id}/received_documents | List Received Documents
*ReceivedDocumentsApi* | [**modify_received_document**](docs/ReceivedDocumentsApi.md#modify_received_document) | **PUT** /c/{company_id}/received_documents/{document_id} | Modify Received Document
*ReceivedDocumentsApi* | [**recover_bin_received_document**](docs/ReceivedDocumentsApi.md#recover_bin_received_document) | **POST** /c/{company_id}/bin/received_documents/{document_id}/recover | 
*ReceivedDocumentsApi* | [**upload_received_document_attachment**](docs/ReceivedDocumentsApi.md#upload_received_document_attachment) | **POST** /c/{company_id}/received_documents/attachment | Upload Received Document Attachment
*SettingsApi* | [**create_payment_account**](docs/SettingsApi.md#create_payment_account) | **POST** /c/{company_id}/settings/payment_accounts | Create Payment Account
*SettingsApi* | [**create_payment_method**](docs/SettingsApi.md#create_payment_method) | **POST** /c/{company_id}/settings/payment_methods | Create Payment Method
*SettingsApi* | [**create_vat_type**](docs/SettingsApi.md#create_vat_type) | **POST** /c/{company_id}/settings/vat_types | Create Vat Type
*SettingsApi* | [**delete_payment_account**](docs/SettingsApi.md#delete_payment_account) | **DELETE** /c/{company_id}/settings/payment_accounts/{payment_account_id} | Delete Payment Account
*SettingsApi* | [**delete_payment_method**](docs/SettingsApi.md#delete_payment_method) | **DELETE** /c/{company_id}/settings/payment_methods/{payment_method_id} | Delete Payment Method
*SettingsApi* | [**delete_vat_type**](docs/SettingsApi.md#delete_vat_type) | **DELETE** /c/{company_id}/settings/vat_types/{vat_type_id} | Delete Vat Type
*SettingsApi* | [**get_payment_account**](docs/SettingsApi.md#get_payment_account) | **GET** /c/{company_id}/settings/payment_accounts/{payment_account_id} | Get Payment Account
*SettingsApi* | [**get_payment_method**](docs/SettingsApi.md#get_payment_method) | **GET** /c/{company_id}/settings/payment_methods/{payment_method_id} | Get Payment Method
*SettingsApi* | [**get_tax_profile**](docs/SettingsApi.md#get_tax_profile) | **GET** /c/{company_id}/settings/tax_profile | Get Tax Profile
*SettingsApi* | [**get_vat_type**](docs/SettingsApi.md#get_vat_type) | **GET** /c/{company_id}/settings/vat_types/{vat_type_id} | Get Vat Type
*SettingsApi* | [**modify_payment_account**](docs/SettingsApi.md#modify_payment_account) | **PUT** /c/{company_id}/settings/payment_accounts/{payment_account_id} | Modify Payment Account
*SettingsApi* | [**modify_payment_method**](docs/SettingsApi.md#modify_payment_method) | **PUT** /c/{company_id}/settings/payment_methods/{payment_method_id} | Modify Payment Method
*SettingsApi* | [**modify_vat_type**](docs/SettingsApi.md#modify_vat_type) | **PUT** /c/{company_id}/settings/vat_types/{vat_type_id} | Modify Vat Type
*SuppliersApi* | [**create_supplier**](docs/SuppliersApi.md#create_supplier) | **POST** /c/{company_id}/entities/suppliers | Create Supplier
*SuppliersApi* | [**delete_supplier**](docs/SuppliersApi.md#delete_supplier) | **DELETE** /c/{company_id}/entities/suppliers/{supplier_id} | Delete Supplier
*SuppliersApi* | [**get_supplier**](docs/SuppliersApi.md#get_supplier) | **GET** /c/{company_id}/entities/suppliers/{supplier_id} | Get Supplier
*SuppliersApi* | [**list_suppliers**](docs/SuppliersApi.md#list_suppliers) | **GET** /c/{company_id}/entities/suppliers | List Suppliers
*SuppliersApi* | [**modify_supplier**](docs/SuppliersApi.md#modify_supplier) | **PUT** /c/{company_id}/entities/suppliers/{supplier_id} | Modify Supplier
*TaxesApi* | [**create_f24**](docs/TaxesApi.md#create_f24) | **POST** /c/{company_id}/taxes | Create F24
*TaxesApi* | [**delete_f24**](docs/TaxesApi.md#delete_f24) | **DELETE** /c/{company_id}/taxes/{document_id} | Delete F24
*TaxesApi* | [**delete_f24_attachment**](docs/TaxesApi.md#delete_f24_attachment) | **DELETE** /c/{company_id}/taxes/{document_id}/attachment | Delete F24 Attachment
*TaxesApi* | [**get_f24**](docs/TaxesApi.md#get_f24) | **GET** /c/{company_id}/taxes/{document_id} | Get F24
*TaxesApi* | [**list_f24**](docs/TaxesApi.md#list_f24) | **GET** /c/{company_id}/taxes | List F24
*TaxesApi* | [**modify_f24**](docs/TaxesApi.md#modify_f24) | **PUT** /c/{company_id}/taxes/{document_id} | Modify F24
*TaxesApi* | [**upload_f24_attachment**](docs/TaxesApi.md#upload_f24_attachment) | **POST** /c/{company_id}/taxes/attachment | Upload F24 Attachment
*UserApi* | [**get_user_info**](docs/UserApi.md#get_user_info) | **GET** /user/info | Get User Info
*UserApi* | [**list_user_companies**](docs/UserApi.md#list_user_companies) | **GET** /user/companies | List User Companies
*WebhooksApi* | [**create_webhooks_subscription**](docs/WebhooksApi.md#create_webhooks_subscription) | **POST** /c/{company_id}/subscriptions | Create a Webhook Subscription
*WebhooksApi* | [**delete_webhooks_subscription**](docs/WebhooksApi.md#delete_webhooks_subscription) | **DELETE** /c/{company_id}/subscriptions/{subscription_id} | Delete Webhooks Subscription
*WebhooksApi* | [**get_webhooks_subscription**](docs/WebhooksApi.md#get_webhooks_subscription) | **GET** /c/{company_id}/subscriptions/{subscription_id} | Get Webhooks Subscription
*WebhooksApi* | [**list_webhooks_subscriptions**](docs/WebhooksApi.md#list_webhooks_subscriptions) | **GET** /c/{company_id}/subscriptions | List Webhooks Subscriptions
*WebhooksApi* | [**modify_webhooks_subscription**](docs/WebhooksApi.md#modify_webhooks_subscription) | **PUT** /c/{company_id}/subscriptions/{subscription_id} | Modify Webhooks Subscription
*WebhooksApi* | [**verify_webhooks_subscription**](docs/WebhooksApi.md#verify_webhooks_subscription) | **POST** /c/{company_id}/subscriptions/{subscription_id}/verify | Verify Webhooks Subscription


## Documentation For Models

 - [ArchiveDocument](docs/ArchiveDocument.md)
 - [AttachmentData](docs/AttachmentData.md)
 - [CashbookEntry](docs/CashbookEntry.md)
 - [CashbookEntryDocument](docs/CashbookEntryDocument.md)
 - [CashbookEntryKind](docs/CashbookEntryKind.md)
 - [CashbookEntryType](docs/CashbookEntryType.md)
 - [City](docs/City.md)
 - [Client](docs/Client.md)
 - [ClientType](docs/ClientType.md)
 - [Company](docs/Company.md)
 - [CompanyInfo](docs/CompanyInfo.md)
 - [CompanyInfoAccessInfo](docs/CompanyInfoAccessInfo.md)
 - [CompanyInfoPlanInfo](docs/CompanyInfoPlanInfo.md)
 - [CompanyInfoPlanInfoFunctions](docs/CompanyInfoPlanInfoFunctions.md)
 - [CompanyInfoPlanInfoFunctionsStatus](docs/CompanyInfoPlanInfoFunctionsStatus.md)
 - [CompanyInfoPlanInfoLimits](docs/CompanyInfoPlanInfoLimits.md)
 - [CompanyPlanUsage](docs/CompanyPlanUsage.md)
 - [CompanyType](docs/CompanyType.md)
 - [ControlledCompany](docs/ControlledCompany.md)
 - [CreateArchiveDocumentRequest](docs/CreateArchiveDocumentRequest.md)
 - [CreateArchiveDocumentResponse](docs/CreateArchiveDocumentResponse.md)
 - [CreateCashbookEntryRequest](docs/CreateCashbookEntryRequest.md)
 - [CreateCashbookEntryResponse](docs/CreateCashbookEntryResponse.md)
 - [CreateClientRequest](docs/CreateClientRequest.md)
 - [CreateClientResponse](docs/CreateClientResponse.md)
 - [CreateF24Request](docs/CreateF24Request.md)
 - [CreateF24Response](docs/CreateF24Response.md)
 - [CreateIssuedDocumentRequest](docs/CreateIssuedDocumentRequest.md)
 - [CreateIssuedDocumentResponse](docs/CreateIssuedDocumentResponse.md)
 - [CreatePaymentAccountRequest](docs/CreatePaymentAccountRequest.md)
 - [CreatePaymentAccountResponse](docs/CreatePaymentAccountResponse.md)
 - [CreatePaymentMethodRequest](docs/CreatePaymentMethodRequest.md)
 - [CreatePaymentMethodResponse](docs/CreatePaymentMethodResponse.md)
 - [CreateProductRequest](docs/CreateProductRequest.md)
 - [CreateProductResponse](docs/CreateProductResponse.md)
 - [CreateReceiptRequest](docs/CreateReceiptRequest.md)
 - [CreateReceiptResponse](docs/CreateReceiptResponse.md)
 - [CreateReceivedDocumentRequest](docs/CreateReceivedDocumentRequest.md)
 - [CreateReceivedDocumentResponse](docs/CreateReceivedDocumentResponse.md)
 - [CreateSupplierRequest](docs/CreateSupplierRequest.md)
 - [CreateSupplierResponse](docs/CreateSupplierResponse.md)
 - [CreateVatTypeRequest](docs/CreateVatTypeRequest.md)
 - [CreateVatTypeResponse](docs/CreateVatTypeResponse.md)
 - [CreateWebhooksSubscriptionRequest](docs/CreateWebhooksSubscriptionRequest.md)
 - [CreateWebhooksSubscriptionResponse](docs/CreateWebhooksSubscriptionResponse.md)
 - [Currency](docs/Currency.md)
 - [DetailedCountry](docs/DetailedCountry.md)
 - [DocumentTemplate](docs/DocumentTemplate.md)
 - [EInvoiceRejectionReason](docs/EInvoiceRejectionReason.md)
 - [Email](docs/Email.md)
 - [EmailAttachment](docs/EmailAttachment.md)
 - [EmailData](docs/EmailData.md)
 - [EmailDataDefaultSenderEmail](docs/EmailDataDefaultSenderEmail.md)
 - [EmailRecipientStatus](docs/EmailRecipientStatus.md)
 - [EmailSchedule](docs/EmailSchedule.md)
 - [EmailScheduleInclude](docs/EmailScheduleInclude.md)
 - [EmailStatus](docs/EmailStatus.md)
 - [Entity](docs/Entity.md)
 - [EntityClientPreCreateInfo](docs/EntityClientPreCreateInfo.md)
 - [EntityType](docs/EntityType.md)
 - [EventType](docs/EventType.md)
 - [F24](docs/F24.md)
 - [F24Status](docs/F24Status.md)
 - [FattureInCloudPlanType](docs/FattureInCloudPlanType.md)
 - [FunctionStatus](docs/FunctionStatus.md)
 - [GetArchiveDocumentResponse](docs/GetArchiveDocumentResponse.md)
 - [GetBinIssuedDocumentResponse](docs/GetBinIssuedDocumentResponse.md)
 - [GetBinReceivedDocumentResponse](docs/GetBinReceivedDocumentResponse.md)
 - [GetCashbookEntryResponse](docs/GetCashbookEntryResponse.md)
 - [GetClientResponse](docs/GetClientResponse.md)
 - [GetCompanyInfoResponse](docs/GetCompanyInfoResponse.md)
 - [GetCompanyPlanUsageResponse](docs/GetCompanyPlanUsageResponse.md)
 - [GetEInvoiceRejectionReasonResponse](docs/GetEInvoiceRejectionReasonResponse.md)
 - [GetEmailDataResponse](docs/GetEmailDataResponse.md)
 - [GetEntityClientPreCreateInfoResponse](docs/GetEntityClientPreCreateInfoResponse.md)
 - [GetExistingIssuedDocumentTotalsRequest](docs/GetExistingIssuedDocumentTotalsRequest.md)
 - [GetExistingIssuedDocumentTotalsResponse](docs/GetExistingIssuedDocumentTotalsResponse.md)
 - [GetExistingReceivedDocumentTotalsRequest](docs/GetExistingReceivedDocumentTotalsRequest.md)
 - [GetExistingReceivedDocumentTotalsResponse](docs/GetExistingReceivedDocumentTotalsResponse.md)
 - [GetF24Response](docs/GetF24Response.md)
 - [GetIssuedDocumentPreCreateInfoResponse](docs/GetIssuedDocumentPreCreateInfoResponse.md)
 - [GetIssuedDocumentResponse](docs/GetIssuedDocumentResponse.md)
 - [GetNewIssuedDocumentTotalsRequest](docs/GetNewIssuedDocumentTotalsRequest.md)
 - [GetNewIssuedDocumentTotalsResponse](docs/GetNewIssuedDocumentTotalsResponse.md)
 - [GetNewReceivedDocumentTotalsRequest](docs/GetNewReceivedDocumentTotalsRequest.md)
 - [GetNewReceivedDocumentTotalsResponse](docs/GetNewReceivedDocumentTotalsResponse.md)
 - [GetPaymentAccountResponse](docs/GetPaymentAccountResponse.md)
 - [GetPaymentMethodResponse](docs/GetPaymentMethodResponse.md)
 - [GetPriceListItemsResponse](docs/GetPriceListItemsResponse.md)
 - [GetProductResponse](docs/GetProductResponse.md)
 - [GetReceiptPreCreateInfoResponse](docs/GetReceiptPreCreateInfoResponse.md)
 - [GetReceiptResponse](docs/GetReceiptResponse.md)
 - [GetReceiptsMonthlyTotalsResponse](docs/GetReceiptsMonthlyTotalsResponse.md)
 - [GetReceivedDocumentPreCreateInfoResponse](docs/GetReceivedDocumentPreCreateInfoResponse.md)
 - [GetReceivedDocumentResponse](docs/GetReceivedDocumentResponse.md)
 - [GetSupplierResponse](docs/GetSupplierResponse.md)
 - [GetTaxProfileResponse](docs/GetTaxProfileResponse.md)
 - [GetUserInfoResponse](docs/GetUserInfoResponse.md)
 - [GetUserInfoResponseEmailConfirmationState](docs/GetUserInfoResponseEmailConfirmationState.md)
 - [GetUserInfoResponseInfo](docs/GetUserInfoResponseInfo.md)
 - [GetVatTypeResponse](docs/GetVatTypeResponse.md)
 - [GetWebhooksSubscriptionResponse](docs/GetWebhooksSubscriptionResponse.md)
 - [IssuedDocument](docs/IssuedDocument.md)
 - [IssuedDocumentEiData](docs/IssuedDocumentEiData.md)
 - [IssuedDocumentExtraData](docs/IssuedDocumentExtraData.md)
 - [IssuedDocumentItemsListItem](docs/IssuedDocumentItemsListItem.md)
 - [IssuedDocumentOptions](docs/IssuedDocumentOptions.md)
 - [IssuedDocumentPaymentsListItem](docs/IssuedDocumentPaymentsListItem.md)
 - [IssuedDocumentPaymentsListItemPaymentTerms](docs/IssuedDocumentPaymentsListItemPaymentTerms.md)
 - [IssuedDocumentPreCreateInfo](docs/IssuedDocumentPreCreateInfo.md)
 - [IssuedDocumentPreCreateInfoDefaultValues](docs/IssuedDocumentPreCreateInfoDefaultValues.md)
 - [IssuedDocumentPreCreateInfoExtraDataDefaultValues](docs/IssuedDocumentPreCreateInfoExtraDataDefaultValues.md)
 - [IssuedDocumentPreCreateInfoItemsDefaultValues](docs/IssuedDocumentPreCreateInfoItemsDefaultValues.md)
 - [IssuedDocumentStatus](docs/IssuedDocumentStatus.md)
 - [IssuedDocumentTotals](docs/IssuedDocumentTotals.md)
 - [IssuedDocumentType](docs/IssuedDocumentType.md)
 - [JoinIssuedDocumentsResponse](docs/JoinIssuedDocumentsResponse.md)
 - [Language](docs/Language.md)
 - [ListArchiveCategoriesResponse](docs/ListArchiveCategoriesResponse.md)
 - [ListArchiveDocumentsResponse](docs/ListArchiveDocumentsResponse.md)
 - [ListArchiveDocumentsResponsePage](docs/ListArchiveDocumentsResponsePage.md)
 - [ListBinIssuedDocuments](docs/ListBinIssuedDocuments.md)
 - [ListBinReceivedDocuments](docs/ListBinReceivedDocuments.md)
 - [ListCashbookEntriesResponse](docs/ListCashbookEntriesResponse.md)
 - [ListCitiesResponse](docs/ListCitiesResponse.md)
 - [ListClientsResponse](docs/ListClientsResponse.md)
 - [ListClientsResponsePage](docs/ListClientsResponsePage.md)
 - [ListCostCentersResponse](docs/ListCostCentersResponse.md)
 - [ListCountriesResponse](docs/ListCountriesResponse.md)
 - [ListCurrenciesResponse](docs/ListCurrenciesResponse.md)
 - [ListDeliveryNotesDefaultCausalsResponse](docs/ListDeliveryNotesDefaultCausalsResponse.md)
 - [ListDetailedCountriesResponse](docs/ListDetailedCountriesResponse.md)
 - [ListEmailsResponse](docs/ListEmailsResponse.md)
 - [ListEmailsResponsePage](docs/ListEmailsResponsePage.md)
 - [ListF24Response](docs/ListF24Response.md)
 - [ListF24ResponseAggregatedData](docs/ListF24ResponseAggregatedData.md)
 - [ListF24ResponseAggregation](docs/ListF24ResponseAggregation.md)
 - [ListF24ResponsePage](docs/ListF24ResponsePage.md)
 - [ListIssuedDocumentsResponse](docs/ListIssuedDocumentsResponse.md)
 - [ListIssuedDocumentsResponsePage](docs/ListIssuedDocumentsResponsePage.md)
 - [ListLanguagesResponse](docs/ListLanguagesResponse.md)
 - [ListPaymentAccountsResponse](docs/ListPaymentAccountsResponse.md)
 - [ListPaymentMethodsResponse](docs/ListPaymentMethodsResponse.md)
 - [ListPriceListsResponse](docs/ListPriceListsResponse.md)
 - [ListProductCategoriesResponse](docs/ListProductCategoriesResponse.md)
 - [ListProductsResponse](docs/ListProductsResponse.md)
 - [ListProductsResponsePage](docs/ListProductsResponsePage.md)
 - [ListReceiptsResponse](docs/ListReceiptsResponse.md)
 - [ListReceiptsResponsePage](docs/ListReceiptsResponsePage.md)
 - [ListReceivedDocumentCategoriesResponse](docs/ListReceivedDocumentCategoriesResponse.md)
 - [ListReceivedDocumentsResponse](docs/ListReceivedDocumentsResponse.md)
 - [ListReceivedDocumentsResponsePage](docs/ListReceivedDocumentsResponsePage.md)
 - [ListRevenueCentersResponse](docs/ListRevenueCentersResponse.md)
 - [ListSuppliersResponse](docs/ListSuppliersResponse.md)
 - [ListSuppliersResponsePage](docs/ListSuppliersResponsePage.md)
 - [ListTemplatesResponse](docs/ListTemplatesResponse.md)
 - [ListUnitsOfMeasureResponse](docs/ListUnitsOfMeasureResponse.md)
 - [ListUserCompaniesResponse](docs/ListUserCompaniesResponse.md)
 - [ListUserCompaniesResponseData](docs/ListUserCompaniesResponseData.md)
 - [ListVatTypesResponse](docs/ListVatTypesResponse.md)
 - [ListWebhooksSubscriptionsResponse](docs/ListWebhooksSubscriptionsResponse.md)
 - [ModifyArchiveDocumentRequest](docs/ModifyArchiveDocumentRequest.md)
 - [ModifyArchiveDocumentResponse](docs/ModifyArchiveDocumentResponse.md)
 - [ModifyCashbookEntryRequest](docs/ModifyCashbookEntryRequest.md)
 - [ModifyCashbookEntryResponse](docs/ModifyCashbookEntryResponse.md)
 - [ModifyClientRequest](docs/ModifyClientRequest.md)
 - [ModifyClientResponse](docs/ModifyClientResponse.md)
 - [ModifyF24Request](docs/ModifyF24Request.md)
 - [ModifyF24Response](docs/ModifyF24Response.md)
 - [ModifyIssuedDocumentRequest](docs/ModifyIssuedDocumentRequest.md)
 - [ModifyIssuedDocumentResponse](docs/ModifyIssuedDocumentResponse.md)
 - [ModifyPaymentAccountRequest](docs/ModifyPaymentAccountRequest.md)
 - [ModifyPaymentAccountResponse](docs/ModifyPaymentAccountResponse.md)
 - [ModifyPaymentMethodRequest](docs/ModifyPaymentMethodRequest.md)
 - [ModifyPaymentMethodResponse](docs/ModifyPaymentMethodResponse.md)
 - [ModifyProductRequest](docs/ModifyProductRequest.md)
 - [ModifyProductResponse](docs/ModifyProductResponse.md)
 - [ModifyReceiptRequest](docs/ModifyReceiptRequest.md)
 - [ModifyReceiptResponse](docs/ModifyReceiptResponse.md)
 - [ModifyReceivedDocumentRequest](docs/ModifyReceivedDocumentRequest.md)
 - [ModifyReceivedDocumentResponse](docs/ModifyReceivedDocumentResponse.md)
 - [ModifySupplierRequest](docs/ModifySupplierRequest.md)
 - [ModifySupplierResponse](docs/ModifySupplierResponse.md)
 - [ModifyVatTypeRequest](docs/ModifyVatTypeRequest.md)
 - [ModifyVatTypeResponse](docs/ModifyVatTypeResponse.md)
 - [ModifyWebhooksSubscriptionRequest](docs/ModifyWebhooksSubscriptionRequest.md)
 - [ModifyWebhooksSubscriptionResponse](docs/ModifyWebhooksSubscriptionResponse.md)
 - [MonthlyTotal](docs/MonthlyTotal.md)
 - [OriginalDocumentType](docs/OriginalDocumentType.md)
 - [Pagination](docs/Pagination.md)
 - [PaymentAccount](docs/PaymentAccount.md)
 - [PaymentAccountType](docs/PaymentAccountType.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [PaymentMethodDetails](docs/PaymentMethodDetails.md)
 - [PaymentMethodType](docs/PaymentMethodType.md)
 - [PaymentTermsType](docs/PaymentTermsType.md)
 - [PermissionLevel](docs/PermissionLevel.md)
 - [Permissions](docs/Permissions.md)
 - [PermissionsFicIssuedDocumentsDetailed](docs/PermissionsFicIssuedDocumentsDetailed.md)
 - [PriceList](docs/PriceList.md)
 - [PriceListItem](docs/PriceListItem.md)
 - [PriceListPricesType](docs/PriceListPricesType.md)
 - [PriceListType](docs/PriceListType.md)
 - [Product](docs/Product.md)
 - [Receipt](docs/Receipt.md)
 - [ReceiptItemsListItem](docs/ReceiptItemsListItem.md)
 - [ReceiptPreCreateInfo](docs/ReceiptPreCreateInfo.md)
 - [ReceiptType](docs/ReceiptType.md)
 - [ReceivedDocument](docs/ReceivedDocument.md)
 - [ReceivedDocumentInfo](docs/ReceivedDocumentInfo.md)
 - [ReceivedDocumentInfoDefaultValues](docs/ReceivedDocumentInfoDefaultValues.md)
 - [ReceivedDocumentInfoItemsDefaultValues](docs/ReceivedDocumentInfoItemsDefaultValues.md)
 - [ReceivedDocumentItemsListItem](docs/ReceivedDocumentItemsListItem.md)
 - [ReceivedDocumentPaymentsListItem](docs/ReceivedDocumentPaymentsListItem.md)
 - [ReceivedDocumentPaymentsListItemPaymentTerms](docs/ReceivedDocumentPaymentsListItemPaymentTerms.md)
 - [ReceivedDocumentTotals](docs/ReceivedDocumentTotals.md)
 - [ReceivedDocumentType](docs/ReceivedDocumentType.md)
 - [ScheduleEmailRequest](docs/ScheduleEmailRequest.md)
 - [SendEInvoiceRequest](docs/SendEInvoiceRequest.md)
 - [SendEInvoiceRequestData](docs/SendEInvoiceRequestData.md)
 - [SendEInvoiceRequestOptions](docs/SendEInvoiceRequestOptions.md)
 - [SendEInvoiceResponse](docs/SendEInvoiceResponse.md)
 - [SendEInvoiceResponseData](docs/SendEInvoiceResponseData.md)
 - [SenderEmail](docs/SenderEmail.md)
 - [ShowTotalsMode](docs/ShowTotalsMode.md)
 - [Supplier](docs/Supplier.md)
 - [SupplierType](docs/SupplierType.md)
 - [TaxProfile](docs/TaxProfile.md)
 - [TransformIssuedDocumentResponse](docs/TransformIssuedDocumentResponse.md)
 - [UploadArchiveAttachmentResponse](docs/UploadArchiveAttachmentResponse.md)
 - [UploadF24AttachmentResponse](docs/UploadF24AttachmentResponse.md)
 - [UploadIssuedDocumentAttachmentResponse](docs/UploadIssuedDocumentAttachmentResponse.md)
 - [UploadReceivedDocumentAttachmentResponse](docs/UploadReceivedDocumentAttachmentResponse.md)
 - [User](docs/User.md)
 - [UserCompanyRole](docs/UserCompanyRole.md)
 - [VatItem](docs/VatItem.md)
 - [VatKind](docs/VatKind.md)
 - [VatType](docs/VatType.md)
 - [VerifyEInvoiceXmlErrorResponse](docs/VerifyEInvoiceXmlErrorResponse.md)
 - [VerifyEInvoiceXmlErrorResponseError](docs/VerifyEInvoiceXmlErrorResponseError.md)
 - [VerifyEInvoiceXmlErrorResponseErrorValidationResult](docs/VerifyEInvoiceXmlErrorResponseErrorValidationResult.md)
 - [VerifyEInvoiceXmlErrorResponseExtra](docs/VerifyEInvoiceXmlErrorResponseExtra.md)
 - [VerifyEInvoiceXmlResponse](docs/VerifyEInvoiceXmlResponse.md)
 - [VerifyEInvoiceXmlResponseData](docs/VerifyEInvoiceXmlResponseData.md)
 - [VerifyWebhooksSubscription](docs/VerifyWebhooksSubscription.md)
 - [VerifyWebhooksSubscriptionRequest](docs/VerifyWebhooksSubscriptionRequest.md)
 - [WebhooksSubscription](docs/WebhooksSubscription.md)
 - [WebhooksSubscriptionConfig](docs/WebhooksSubscriptionConfig.md)
 - [WebhooksSubscriptionMapping](docs/WebhooksSubscriptionMapping.md)
 - [WebhooksSubscriptionVerificationMethod](docs/WebhooksSubscriptionVerificationMethod.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="OAuth2AuthenticationCodeFlow"></a>
### OAuth2AuthenticationCodeFlow

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://api-v2.fattureincloud.it/oauth/authorize
- **Scopes**: 
 - **entity.clients:r**: Read permission to the Clients registry
 - **entity.clients:a**: Write permission to the Clients registry
 - **entity.suppliers:r**: Read permission to the Suppliers registry
 - **entity.suppliers:a**: Write permission to the Suppliers registry
 - **products:r**: Read permission to the Products
 - **products:a**: Write permission to the Products
 - **issued_documents.invoices:r**: Read permission to the issued Invoices
 - **issued_documents.credit_notes:r**: Read permission to the issued Credit Notes
 - **issued_documents.receipts:r**: Read permission to the issued Receipts
 - **issued_documents.orders:r**: Read permission to the issued Orders
 - **issued_documents.quotes:r**: Read permission to the issued Quotes
 - **issued_documents.proformas:r**: Read permission to the issued Proformas
 - **issued_documents.delivery_notes:r**: Read permission to the issued Delivery Notes
 - **issued_documents.work_reports:r**: Read permission to the issued Work Reports
 - **issued_documents.supplier_orders:r**: Read permission to the issued Supplier Orders
 - **issued_documents.self_invoices:r**: Read permission to the issued Self Invoices
 - **issued_documents.invoices:a**: Write permission to the issued Invoices
 - **issued_documents.credit_notes:a**: Write permission to the issued Credit Notes
 - **issued_documents.receipts:a**: Write permission to the issued issued Receipts
 - **issued_documents.orders:a**: Write permission to the issued Orders
 - **issued_documents.quotes:a**: Write permission to the issued Quotes
 - **issued_documents.proformas:a**: Write permission to the issued Proformas
 - **issued_documents.delivery_notes:a**: Write permission to the issued Delivery Notes
 - **issued_documents.work_reports:a**: Write permission to the issued Work Reports
 - **issued_documents.supplier_orders:a**: Write permission to the issued Supplier Orders
 - **issued_documents.self_invoices:a**: Write permission to the issued Self Invoices
 - **received_documents:r**: Read permission to the Received Documents
 - **received_documents:a**: Write permission to the Received Documents
 - **stock:r**: Read permission to the Stock movements
 - **stock:a**: Write permission to the Stock movements
 - **receipts:r**: Read permission to the Receipts
 - **receipts:a**: Write permission to the Receipts
 - **calendar:r**: Read permission to the Calendar
 - **calendar:a**: Write permission to the Calendar
 - **taxes:r**: Read permission to the Taxes
 - **taxes:a**: Write permission to the Taxes
 - **archive:r**: Read permission to the Archive Documents
 - **archive:a**: Read permission to the Archive Documents
 - **emails:r**: Read permission to the Emails
 - **cashbook:r**: Read permission to the Cashbook
 - **cashbook:a**: Write permission to the Cashbook
 - **settings:r**: Read permission to the Settings
 - **settings:a**: Write permission to the Settings
 - **situation:r**: Read permission to the company Situation


## Author

info@fattureincloud.it


