# coding: utf-8

"""
Fatture in Cloud API v2 - API Reference

Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

The version of the OpenAPI document: 2.1.5
Contact: info@fattureincloud.it
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class DetailedCountry(BaseModel):
    """
    DetailedCountry
    """  # noqa: E501

    name: Optional[StrictStr] = Field(default=None, description="Country name")
    settings_name: Optional[StrictStr] = Field(
        default=None, description="Country settings name"
    )
    iso: Optional[StrictStr] = Field(default=None, description="Country iso code")
    fiscal_iso: Optional[StrictStr] = Field(
        default=None, description="Country fiscal iso code"
    )
    uic: Optional[StrictStr] = Field(default=None, description="Country uic")
    __properties: ClassVar[List[str]] = [
        "name",
        "settings_name",
        "iso",
        "fiscal_iso",
        "uic",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DetailedCountry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DetailedCountry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "settings_name": obj.get("settings_name"),
                "iso": obj.get("iso"),
                "fiscal_iso": obj.get("fiscal_iso"),
                "uic": obj.get("uic"),
            }
        )
        return _obj
