# coding: utf-8

"""
Fatture in Cloud API v2 - API Reference

Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

The version of the OpenAPI document: 2.1.5
Contact: info@fattureincloud.it
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from fattureincloud_python_sdk.models.f24_status import F24Status
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from typing import Optional, Set
from typing_extensions import Self


class F24(BaseModel):
    """
    F24
    """  # noqa: E501

    id: Optional[StrictInt] = Field(default=None, description="F24 id")
    due_date: Optional[date] = Field(default=None, description="F24 due date")
    status: Optional[F24Status] = None
    payment_account: Optional[PaymentAccount] = None
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="F24 amount"
    )
    attachment_url: Optional[StrictStr] = Field(
        default=None, description="[Temporary] [Read Only] F24 url of the attached file"
    )
    attachment_token: Optional[StrictStr] = Field(
        default=None,
        description="[Write Only]  F24 attachment token returned by POST /taxes/attachment",
    )
    description: Optional[StrictStr] = Field(
        default=None, description="F24 description"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "due_date",
        "status",
        "payment_account",
        "amount",
        "attachment_url",
        "attachment_token",
        "description",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of F24 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "attachment_url",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payment_account
        if self.payment_account:
            _dict["payment_account"] = self.payment_account.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of F24 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "due_date": obj.get("due_date"),
                "status": obj.get("status"),
                "payment_account": (
                    PaymentAccount.from_dict(obj["payment_account"])
                    if obj.get("payment_account") is not None
                    else None
                ),
                "amount": obj.get("amount"),
                "attachment_url": obj.get("attachment_url"),
                "attachment_token": obj.get("attachment_token"),
                "description": obj.get("description"),
            }
        )
        return _obj
