# coding: utf-8

"""
Fatture in Cloud API v2 - API Reference

Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

The version of the OpenAPI document: 2.1.5
Contact: info@fattureincloud.it
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import json
import unittest

from fattureincloud_python_sdk.models.entity_client_pre_create_info import (
    EntityClientPreCreateInfo,
)
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from fattureincloud_python_sdk.models.payment_account_type import PaymentAccountType
from fattureincloud_python_sdk.models.payment_method import PaymentMethod
from fattureincloud_python_sdk.models.payment_method_type import PaymentMethodType
from fattureincloud_python_sdk.models.price_list import PriceList
from fattureincloud_python_sdk.models.vat_type import VatType
from functions import json_serial


class TestEntityClientPreCreateInfo(unittest.TestCase):
    """EntityClientPreCreateInfo unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testEntityClientPreCreateInfo(self):
        """Test EntityClientPreCreateInfo"""
        model = EntityClientPreCreateInfo(
            countries_list= [
                'Italy'
            ],
            payment_methods_list= [
                PaymentMethod(
                    id=1,
                    name="name_example",
                    type=PaymentMethodType("standard"),
                    is_default=False,
                )
            ],
            payment_accounts_list= [
                PaymentAccount(
                    id=1,
                    name="Conto Banca Intesa",
                    type=PaymentAccountType("standard"),
                    iban="iban_example",
                    sia="sia_example",
                    cuc="cuc_example",
                    virtual=True,
                )
            ],
            vat_types_list= [
                VatType(
                    id=1,
                    value=22.0,
                    description="Non imponibile art. 123",
                    notes="IVA non imponibile ai sensi dell articolo 123, comma 2",
                    e_invoice=True,
                    ei_type="2",
                    ei_description="ei_description_example",
                    is_disabled=True,
                )
            ],
            price_lists= [
                PriceList(
                    id="12345",
                    name="Listino 1",
                    prices_type="net",
                    is_default=True,
                    valid_from="2021-01-01",
                    valid_to="2021-12-31",
                    type="sell",
                )
            ],
        )
        expected_json = '{"countries_list": ["Italy"], "payment_methods_list": [{"id": 1, "name": "name_example", "type": "standard", "is_default": false}], "payment_accounts_list": [{"id": 1, "name": "Conto Banca Intesa", "type": "standard", "iban": "iban_example", "sia": "sia_example", "cuc": "cuc_example", "virtual": true}], "vat_types_list": [{"id": 1, "value": 22.0, "description": "Non imponibile art. 123", "notes": "IVA non imponibile ai sensi dell articolo 123, comma 2", "e_invoice": true, "ei_type": "2", "ei_description": "ei_description_example", "is_disabled": true}], "price_lists": [{"id": "12345", "name": "Listino 1", "prices_type": "net", "is_default": true, "valid_from": "2021-01-01", "valid_to": "2021-12-31", "type": "sell"}]}'
        actual_json = json.dumps(model.to_dict(), default=json_serial)
        assert actual_json == expected_json


if __name__ == "__main__":
    unittest.main()
