# coding: utf-8

"""
Fatture in Cloud API v2 - API Reference

Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

The version of the OpenAPI document: 2.1.5
Contact: info@fattureincloud.it
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import json
import unittest

from fattureincloud_python_sdk.models.list_price_lists_response import (
    ListPriceListsResponse,
)
from fattureincloud_python_sdk.models.price_list import PriceList
from functions import json_serial


class TestListPriceListsResponse(unittest.TestCase):
    """ListPriceListsResponse unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testListPriceListsResponse(self):
        """Test ListPriceListsResponse"""
        model = ListPriceListsResponse(
            data = [
                PriceList(
                    id= '10',
                    name= 'listino',
                    prices_type= 'net',
                    is_default= True,
                    valid_from= '2025-01-01',
                    valid_to= '2025-12-01',
                    type= 'sell'
                ),
                PriceList(
                    id= '11',
                    name= 'listino-test',
                    prices_type= 'gross',
                    is_default= True,
                    valid_from= '2025-01-01',
                    valid_to= '2025-01-01',
                    type= 'purchase'
                )
            ]
        )
        expected_json = '{"data": [{"id": "10", "name": "listino", "prices_type": "net", "is_default": true, "valid_from": "2025-01-01", "valid_to": "2025-12-01", "type": "sell"}, {"id": "11", "name": "listino-test", "prices_type": "gross", "is_default": true, "valid_from": "2025-01-01", "valid_to": "2025-01-01", "type": "purchase"}]}'
        actual_json = json.dumps(model.to_dict(), default=json_serial)
        assert actual_json == expected_json


if __name__ == "__main__":
    unittest.main()
