# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.transfers_entity import TransfersEntity
from fdxapi.models.transfer_entity import TransferEntity
from fdxapi.exceptions.error_exception import ErrorException


class InternalTransfersController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(InternalTransfersController, self).__init__(config)

    def search_for_transfers(self,
                             x_fapi_interaction_id,
                             fdx_api_actor_type=None,
                             updated_since=None,
                             offset=None,
                             limit=None,
                             search_start_transfer_date=None,
                             search_end_transfer_date=None,
                             search_from_account_ids=None,
                             search_to_account_ids=None,
                             search_statuses=None,
                             search_transfer_ids=None):
        """Does a GET request to /transfers.

        Search for transfers

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            updated_since (str, optional): Return items that have been created
                or updated since the nextUpdateId
            offset (str, optional): Opaque cursor used by the provider to send
                the next set of records
            limit (int, optional): Number of elements that the consumer wishes
                to receive. Providers should implement reasonable
                default/maximum/minimum values based on their internal
                architecture and update their documentation accordingly
            search_start_transfer_date (date, optional): Start time for use in
                retrieval of transfers by transfer date
            search_end_transfer_date (date, optional): End time for use in
                retrieval of transfers by transfer date
            search_from_account_ids (List[str], optional): Search for
                transfers by source account
            search_to_account_ids (List[str], optional): Search for transfers
                by source account
            search_statuses (List[PaymentStatus], optional): Search for
                transfers by source account
            search_transfer_ids (List[str], optional): Search for transfers by
                id

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Success

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/transfers')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('updatedSince')
                         .value(updated_since))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .query_param(Parameter()
                         .key('searchStartTransferDate')
                         .value(search_start_transfer_date))
            .query_param(Parameter()
                         .key('searchEndTransferDate')
                         .value(search_end_transfer_date))
            .query_param(Parameter()
                         .key('searchFromAccountIds')
                         .value(search_from_account_ids))
            .query_param(Parameter()
                         .key('searchToAccountIds')
                         .value(search_to_account_ids))
            .query_param(Parameter()
                         .key('searchStatuses')
                         .value(search_statuses))
            .query_param(Parameter()
                         .key('searchTransferIds')
                         .value(search_transfer_ids))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TransfersEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Start or end date value is not in the ISO 8601 format', ErrorException)
            .local_error('404', 'Data not found for request parameters', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def request_account_transfer(self,
                                 x_fapi_interaction_id,
                                 idempotency_key,
                                 fdx_api_actor_type=None,
                                 body=None):
        """Does a POST request to /transfers.

        Create a transfer between accounts

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            idempotency_key (str): Used to de-duplicate requests
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            body (TransferForCreateEntity1, optional): Data of the transfer
                request

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Initial
                status of the requested transfer

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/transfers')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .header_param(Parameter()
                          .key('idempotency-key')
                          .value(idempotency_key)
                          .is_required(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TransferEntity.from_dictionary)
            .is_api_response(True)
            .local_error('400', 'Source account does not have sufficient funds', ErrorException)
            .local_error('401', 'Account not authorized for transfer', ErrorException)
            .local_error('404', 'Requested transfer is invalid', ErrorException)
            .local_error('409', 'Duplicate transfer request', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()

    def get_transfer(self,
                     x_fapi_interaction_id,
                     transfer_id,
                     fdx_api_actor_type=None):
        """Does a GET request to /transfers/{transferId}.

        Get a transfer been accounts

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            transfer_id (str): Transfer identifier
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/transfers/{transferId}')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('transferId')
                            .value(transfer_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TransferEntity.from_dictionary)
            .is_api_response(True)
        ).execute()

    def cancel_transfer(self,
                        x_fapi_interaction_id,
                        transfer_id,
                        fdx_api_actor_type=None):
        """Does a DELETE request to /transfers/{transferId}.

        Cancel a transfer between accounts

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            transfer_id (str): Transfer identifier
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers. Ok

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.MONEYMOVEMENT)
            .path('/transfers/{transferId}')
            .http_method(HttpMethodEnum.DELETE)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('transferId')
                            .value(transfer_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(TransferEntity.from_dictionary)
            .is_api_response(True)
        ).execute()
