# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from fdxapi.api_helper import APIHelper
from fdxapi.configuration import Server
from fdxapi.http.api_response import ApiResponse
from fdxapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from fdxapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from fdxapi.models.asset_transfer_network_list import AssetTransferNetworkList
from fdxapi.models.array_of_account_payment_networks import ArrayOfAccountPaymentNetworks
from fdxapi.exceptions.error_exception import ErrorException


class MoneyMovementController(BaseController):

    """A Controller to access Endpoints in the fdxapi API."""
    def __init__(self, config):
        super(MoneyMovementController, self).__init__(config)

    def get_account_asset_transfer_networks(self,
                                            x_fapi_interaction_id,
                                            account_id,
                                            fdx_api_actor_type=None):
        """Does a GET request to /accounts/{accountId}/asset-transfer-networks.

        ...

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            account_id (str): Account Identifier
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers.
                Information required to facilitate asset transfer from this
                account

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CORE)
            .path('/accounts/{accountId}/asset-transfer-networks')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('accountId')
                            .value(account_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(AssetTransferNetworkList.from_dictionary)
            .is_api_response(True)
        ).execute()

    def get_account_payment_networks(self,
                                     x_fapi_interaction_id,
                                     account_id,
                                     fdx_api_actor_type=None,
                                     offset=None,
                                     limit=None):
        """Does a GET request to /accounts/{accountId}/payment-networks.

        Get payment networks supported by the account

        Args:
            x_fapi_interaction_id (uuid|str): Unique identifier for this
                interaction
            account_id (str): Account Identifier
            fdx_api_actor_type (FdxApiActorType, optional): Identifies whether
                the customer is present (USER) or it is a BATCH operation
            offset (str, optional): Opaque cursor used by the provider to send
                the next set of records
            limit (int, optional): Number of elements that the consumer wishes
                to receive. Providers should implement reasonable
                default/maximum/minimum values based on their internal
                architecture and update their documentation accordingly

        Returns:
            ApiResponse: An object with the response value as well as other
                useful information such as status codes and headers.
                Information required to execute a payment transaction against
                this account

        Raises:
            ApiException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.CORE)
            .path('/accounts/{accountId}/payment-networks')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('x-fapi-interaction-id')
                          .value(x_fapi_interaction_id)
                          .is_required(True))
            .template_param(Parameter()
                            .key('accountId')
                            .value(account_id)
                            .is_required(True)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('FDX-API-Actor-Type')
                          .value(fdx_api_actor_type))
            .query_param(Parameter()
                         .key('offset')
                         .value(offset))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('bearerAuth'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ArrayOfAccountPaymentNetworks.from_dictionary)
            .is_api_response(True)
            .local_error('404', 'Account with id not found', ErrorException)
            .local_error('500', 'Catch-all exception where request was not processed due to an internal outage/issue. Consider other more specific errors before using this error', ErrorException)
            .local_error('501', 'Error when FdxVersion in Header is not one of those implemented at backend', ErrorException)
            .local_error('503', 'System is down for maintenance', ErrorException)
        ).execute()
