# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.authentication.header_auth import HeaderAuth
from apimatic_core.utilities.auth_helper import AuthHelper


class TaxBasicAuth(HeaderAuth):

    @property
    def error_message(self):
        """Display error message on occurrence of authentication failure
        in TaxBasicAuth

        """
        return "TaxBasicAuth: Username or Password is undefined."

    def __init__(self, tax_basic_auth_credentials):
        auth_params = {}
        if tax_basic_auth_credentials is not None \
                and tax_basic_auth_credentials.username and tax_basic_auth_credentials.password:
            auth_params = {"Authorization": "Basic {}".format(
                AuthHelper.get_base64_encoded_value(tax_basic_auth_credentials.username, tax_basic_auth_credentials.password))}
        super().__init__(auth_params=auth_params)


class TaxBasicAuthCredentials:

    @property
    def username(self):
        return self._username

    @property
    def password(self):
        return self._password

    def __init__(self, username, password):
        if username is None:
            raise ValueError('username cannot be None')
        if password is None:
            raise ValueError('password cannot be None')
        self._username = username
        self._password = password

    def clone_with(self, username=None, password=None):
        return TaxBasicAuthCredentials(username or self.username,
                                       password or self.password)
