# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.logger.configuration.api_logging_configuration import (
    ApiLoggingConfiguration,
    ApiRequestLoggingConfiguration,
    ApiResponseLoggingConfiguration)


class RequestLoggingConfiguration(ApiRequestLoggingConfiguration):

    def __init__(self, log_body=False, log_headers=False, headers_to_include=None,
                 headers_to_exclude=None, headers_to_unmask=None,
                 include_query_in_path=False):
        """Default constructor.

        Args:
            log_body (bool): Controls the logging of the request body.
            log_headers (bool): Controls the logging of request headers.
            headers_to_include (List[str]): Includes only specified headers in the log output.
            headers_to_exclude (List[str]): Excludes specified headers from the log output.
            headers_to_unmask (List[str]): Logs specified headers without masking, revealing their actual values.
            include_query_in_path (bool): Determines whether to include query parameters in the logged request path.
        """
        super(RequestLoggingConfiguration, self).__init__(log_body, log_headers, headers_to_include,
                                                          headers_to_exclude, headers_to_unmask,
                                                          include_query_in_path)

    def clone_with(self, log_body=None, log_headers=None, headers_to_include=None,
                   headers_to_exclude=None, headers_to_unmask=None, include_query_in_path=False):
        log_body = log_body or self.log_body
        log_headers = log_headers or self.log_headers
        headers_to_include = headers_to_include or self.headers_to_include
        headers_to_exclude = headers_to_exclude or self.headers_to_exclude
        headers_to_unmask = headers_to_unmask or self.headers_to_unmask
        include_query_in_path = include_query_in_path or self.include_query_in_path

        return RequestLoggingConfiguration(log_body, log_headers, headers_to_include,
                                           headers_to_exclude, headers_to_unmask, include_query_in_path)


class ResponseLoggingConfiguration(ApiResponseLoggingConfiguration):

    def __init__(self, log_body=False, log_headers=False, headers_to_include=None,
                 headers_to_exclude=None, headers_to_unmask=None):
        """Default constructor.

        Args:
            log_body (bool): Controls the logging of the request body.
            log_headers (bool): Controls the logging of request headers.
            headers_to_include (List[str]): Includes only specified headers in the log output.
            headers_to_exclude (List[str]): Excludes specified headers from the log output.
            headers_to_unmask (List[str]): Logs specified headers without masking, revealing their actual values.
        """

        super(ResponseLoggingConfiguration, self).__init__(log_body, log_headers, headers_to_include,
                                                           headers_to_exclude, headers_to_unmask)

    def clone_with(self, log_body=None, log_headers=None, headers_to_include=None,
                   headers_to_exclude=None, headers_to_unmask=None):
        log_body = log_body or self.log_body
        log_headers = log_headers or self.log_headers
        headers_to_include = headers_to_include or self.headers_to_include
        headers_to_exclude = headers_to_exclude or self.headers_to_exclude
        headers_to_unmask = headers_to_unmask or self.headers_to_unmask

        return ResponseLoggingConfiguration(log_body, log_headers, headers_to_include,
                                            headers_to_exclude, headers_to_unmask)


class LoggingConfiguration(ApiLoggingConfiguration):

    def __init__(self, logger=None, log_level=None, mask_sensitive_headers=True,
                 request_logging_config=RequestLoggingConfiguration(),
                 response_logging_config=ResponseLoggingConfiguration()):
        """Default constructor.

        Args:
            logger (Logger): The logging implementation to log with.
            log_level (LogLevel): The log level to apply to the log message.
            mask_sensitive_headers (bool): Flag to control masking of sensitive headers.
            request_logging_config (RequestLoggingConfiguration): The API request logging configuration.
            response_logging_config (ResponseLoggingConfiguration): The API response logging configuration.
        """
        request_logging_config = request_logging_config or RequestLoggingConfiguration()
        response_logging_config = response_logging_config or ResponseLoggingConfiguration()
        super(LoggingConfiguration, self).__init__(logger, log_level, mask_sensitive_headers,
                                                   request_logging_config, response_logging_config)

    def clone_with(self, logger=None, log_level=None, mask_sensitive_headers=None,
                   request_logging_config=None, response_logging_config=None):
        logger = logger or self.logger
        log_level = log_level or self.log_level
        mask_sensitive_headers = mask_sensitive_headers or self.mask_sensitive_headers
        request_logging_config = request_logging_config or self.request_logging_config
        response_logging_config = response_logging_config or self.response_logging_config

        return LoggingConfiguration(logger, log_level, mask_sensitive_headers,
                                    request_logging_config, response_logging_config)
