# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.business_customer_entity import BusinessCustomerEntity
from fdxapi.models.customer_name_entity import CustomerNameEntity
from fdxapi.models.customer_to_account_relationship_entity import CustomerToAccountRelationshipEntity
from fdxapi.models.delivery_address import DeliveryAddress
from fdxapi.models.telephone_number import TelephoneNumber


class AccountHolderEntity(object):

    """Implementation of the 'Account Holder entity' model.

    Extends `Customer` and adds a `relationship` field to define the
    customer's relationship with an account

    Attributes:
        emails (List[str]): Array of the contact email addresses
        addresses (List[DeliveryAddress]): Array of the contact physical
            addresses
        telephones (List[TelephoneNumber]): Array of the contact telephone
            numbers
        date_of_birth (date): The person's date of birth
        tax_id (str): Country specific Tax Id associated with this customer
            (SIN or NAS in Canada, SSN or TIN in US, etc.)
        tax_id_country (Iso3166CountryCode1): Country originating the
            Customer's taxId element
        government_id (str): A federal (such as passport) or state (such as
            driver's license) issued identifier
        customer_id (str): Long-term persistent identity of the customer. This
            identity must be unique to the owning institution
        mtype (BusinessOrConsumerType): Type of entity. One of BUSINESS or
            CONSUMER
        name (CustomerNameEntity): The customer's name
        business_customer (BusinessCustomerEntity): The business customer
            information, only used if 'type' is 'BUSINESS'.
        customer_start_date (date): The customer's start date at the financial
            institution
        last_activity_date (date): The customer's date of last account
            activity at the financial institution
        accounts (List[CustomerToAccountRelationshipEntity]): List of accounts
            related to this customer
        relationship (AccountHolderRelationship1): Customer's relationship to
            the account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "emails": 'emails',
        "addresses": 'addresses',
        "telephones": 'telephones',
        "date_of_birth": 'dateOfBirth',
        "tax_id": 'taxId',
        "tax_id_country": 'taxIdCountry',
        "government_id": 'governmentId',
        "customer_id": 'customerId',
        "mtype": 'type',
        "name": 'name',
        "business_customer": 'businessCustomer',
        "customer_start_date": 'customerStartDate',
        "last_activity_date": 'lastActivityDate',
        "accounts": 'accounts',
        "relationship": 'relationship'
    }

    _optionals = [
        'emails',
        'addresses',
        'telephones',
        'date_of_birth',
        'tax_id',
        'tax_id_country',
        'government_id',
        'customer_id',
        'mtype',
        'name',
        'business_customer',
        'customer_start_date',
        'last_activity_date',
        'accounts',
        'relationship',
    ]

    def __init__(self,
                 emails=APIHelper.SKIP,
                 addresses=APIHelper.SKIP,
                 telephones=APIHelper.SKIP,
                 date_of_birth=APIHelper.SKIP,
                 tax_id=APIHelper.SKIP,
                 tax_id_country=APIHelper.SKIP,
                 government_id=APIHelper.SKIP,
                 customer_id=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 business_customer=APIHelper.SKIP,
                 customer_start_date=APIHelper.SKIP,
                 last_activity_date=APIHelper.SKIP,
                 accounts=APIHelper.SKIP,
                 relationship=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AccountHolderEntity class"""

        # Initialize members of the class
        if emails is not APIHelper.SKIP:
            self.emails = emails 
        if addresses is not APIHelper.SKIP:
            self.addresses = addresses 
        if telephones is not APIHelper.SKIP:
            self.telephones = telephones 
        if date_of_birth is not APIHelper.SKIP:
            self.date_of_birth = date_of_birth 
        if tax_id is not APIHelper.SKIP:
            self.tax_id = tax_id 
        if tax_id_country is not APIHelper.SKIP:
            self.tax_id_country = tax_id_country 
        if government_id is not APIHelper.SKIP:
            self.government_id = government_id 
        if customer_id is not APIHelper.SKIP:
            self.customer_id = customer_id 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if name is not APIHelper.SKIP:
            self.name = name 
        if business_customer is not APIHelper.SKIP:
            self.business_customer = business_customer 
        if customer_start_date is not APIHelper.SKIP:
            self.customer_start_date = customer_start_date 
        if last_activity_date is not APIHelper.SKIP:
            self.last_activity_date = last_activity_date 
        if accounts is not APIHelper.SKIP:
            self.accounts = accounts 
        if relationship is not APIHelper.SKIP:
            self.relationship = relationship 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        emails = dictionary.get("emails") if dictionary.get("emails") else APIHelper.SKIP
        addresses = None
        if dictionary.get('addresses') is not None:
            addresses = [DeliveryAddress.from_dictionary(x) for x in dictionary.get('addresses')]
        else:
            addresses = APIHelper.SKIP
        telephones = None
        if dictionary.get('telephones') is not None:
            telephones = [TelephoneNumber.from_dictionary(x) for x in dictionary.get('telephones')]
        else:
            telephones = APIHelper.SKIP
        date_of_birth = dateutil.parser.parse(dictionary.get('dateOfBirth')).date() if dictionary.get('dateOfBirth') else APIHelper.SKIP
        tax_id = dictionary.get("taxId") if dictionary.get("taxId") else APIHelper.SKIP
        tax_id_country = dictionary.get("taxIdCountry") if dictionary.get("taxIdCountry") else APIHelper.SKIP
        government_id = dictionary.get("governmentId") if dictionary.get("governmentId") else APIHelper.SKIP
        customer_id = dictionary.get("customerId") if dictionary.get("customerId") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        name = CustomerNameEntity.from_dictionary(dictionary.get('name')) if 'name' in dictionary.keys() else APIHelper.SKIP
        business_customer = BusinessCustomerEntity.from_dictionary(dictionary.get('businessCustomer')) if 'businessCustomer' in dictionary.keys() else APIHelper.SKIP
        customer_start_date = dateutil.parser.parse(dictionary.get('customerStartDate')).date() if dictionary.get('customerStartDate') else APIHelper.SKIP
        last_activity_date = dateutil.parser.parse(dictionary.get('lastActivityDate')).date() if dictionary.get('lastActivityDate') else APIHelper.SKIP
        accounts = None
        if dictionary.get('accounts') is not None:
            accounts = [CustomerToAccountRelationshipEntity.from_dictionary(x) for x in dictionary.get('accounts')]
        else:
            accounts = APIHelper.SKIP
        relationship = dictionary.get("relationship") if dictionary.get("relationship") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(emails,
                   addresses,
                   telephones,
                   date_of_birth,
                   tax_id,
                   tax_id_country,
                   government_id,
                   customer_id,
                   mtype,
                   name,
                   business_customer,
                   customer_start_date,
                   last_activity_date,
                   accounts,
                   relationship,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'emails={(self.emails if hasattr(self, "emails") else None)!r}, '
                f'addresses={(self.addresses if hasattr(self, "addresses") else None)!r}, '
                f'telephones={(self.telephones if hasattr(self, "telephones") else None)!r}, '
                f'date_of_birth={(self.date_of_birth if hasattr(self, "date_of_birth") else None)!r}, '
                f'tax_id={(self.tax_id if hasattr(self, "tax_id") else None)!r}, '
                f'tax_id_country={(self.tax_id_country if hasattr(self, "tax_id_country") else None)!r}, '
                f'government_id={(self.government_id if hasattr(self, "government_id") else None)!r}, '
                f'customer_id={(self.customer_id if hasattr(self, "customer_id") else None)!r}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'business_customer={(self.business_customer if hasattr(self, "business_customer") else None)!r}, '
                f'customer_start_date={(self.customer_start_date if hasattr(self, "customer_start_date") else None)!r}, '
                f'last_activity_date={(self.last_activity_date if hasattr(self, "last_activity_date") else None)!r}, '
                f'accounts={(self.accounts if hasattr(self, "accounts") else None)!r}, '
                f'relationship={(self.relationship if hasattr(self, "relationship") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'emails={(self.emails if hasattr(self, "emails") else None)!s}, '
                f'addresses={(self.addresses if hasattr(self, "addresses") else None)!s}, '
                f'telephones={(self.telephones if hasattr(self, "telephones") else None)!s}, '
                f'date_of_birth={(self.date_of_birth if hasattr(self, "date_of_birth") else None)!s}, '
                f'tax_id={(self.tax_id if hasattr(self, "tax_id") else None)!s}, '
                f'tax_id_country={(self.tax_id_country if hasattr(self, "tax_id_country") else None)!s}, '
                f'government_id={(self.government_id if hasattr(self, "government_id") else None)!s}, '
                f'customer_id={(self.customer_id if hasattr(self, "customer_id") else None)!s}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'business_customer={(self.business_customer if hasattr(self, "business_customer") else None)!s}, '
                f'customer_start_date={(self.customer_start_date if hasattr(self, "customer_start_date") else None)!s}, '
                f'last_activity_date={(self.last_activity_date if hasattr(self, "last_activity_date") else None)!s}, '
                f'accounts={(self.accounts if hasattr(self, "accounts") else None)!s}, '
                f'relationship={(self.relationship if hasattr(self, "relationship") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
