# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.page_metadata import PageMetadata
from fdxapi.models.page_metadata_links import PageMetadataLinks


class AccountsEntity(object):

    """Implementation of the 'Accounts entity' model.

    An optionally paginated array of accounts

    Attributes:
        page (PageMetadata): Offset IDs for navigating result sets
        links (PageMetadataLinks): Resource URLs for navigating result sets
        accounts (List[AnnuityAccountEntity | CommercialAccountEntity |
            DepositAccountEntity | DigitalWalletAccountEntity |
            InsuranceAccountEntity | InvestmentAccountEntity |
            LineOfCreditAccountEntity | LoanAccountEntity] | None): An array
            of accounts with entity types dependent on the account type
            (deposit, investment, loan, line of credit, annuity, insurance,
            commercial, or digital wallet)
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "page": 'page',
        "links": 'links',
        "accounts": 'accounts'
    }

    _optionals = [
        'page',
        'links',
        'accounts',
    ]

    def __init__(self,
                 page=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 accounts=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AccountsEntity class"""

        # Initialize members of the class
        if page is not APIHelper.SKIP:
            self.page = page 
        if links is not APIHelper.SKIP:
            self.links = links 
        if accounts is not APIHelper.SKIP:
            self.accounts = accounts 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        page = PageMetadata.from_dictionary(dictionary.get('page')) if 'page' in dictionary.keys() else APIHelper.SKIP
        links = PageMetadataLinks.from_dictionary(dictionary.get('links')) if 'links' in dictionary.keys() else APIHelper.SKIP
        accounts = APIHelper.deserialize_union_type(UnionTypeLookUp.get('AccountsEntityAccounts'), dictionary.get('accounts'), False) if dictionary.get('accounts') is not None else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(page,
                   links,
                   accounts,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'accounts={(self.accounts if hasattr(self, "accounts") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'accounts={(self.accounts if hasattr(self, "accounts") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
