# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.asset_transfer_network import AssetTransferNetwork


class AssetTransferNetworkList(object):

    """Implementation of the 'Asset Transfer Network List' model.

    An array of asset transfer network details for this account

    Attributes:
        asset_transfer_networks (List[AssetTransferNetwork]): Array of asset
            transfer networks
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "asset_transfer_networks": 'assetTransferNetworks'
    }

    _optionals = [
        'asset_transfer_networks',
    ]

    def __init__(self,
                 asset_transfer_networks=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AssetTransferNetworkList class"""

        # Initialize members of the class
        if asset_transfer_networks is not APIHelper.SKIP:
            self.asset_transfer_networks = asset_transfer_networks 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        asset_transfer_networks = None
        if dictionary.get('assetTransferNetworks') is not None:
            asset_transfer_networks = [AssetTransferNetwork.from_dictionary(x) for x in dictionary.get('assetTransferNetworks')]
        else:
            asset_transfer_networks = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(asset_transfer_networks,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'asset_transfer_networks={(self.asset_transfer_networks if hasattr(self, "asset_transfer_networks") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'asset_transfer_networks={(self.asset_transfer_networks if hasattr(self, "asset_transfer_networks") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
