# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.planned_availability_entity import PlannedAvailabilityEntity


class AvailabilityEntity1(object):

    """Implementation of the 'Availability entity1' model.

    Whether and how this API is currently supported

    Attributes:
        status (AvailabilityStatus3): Status of API availability
        description (str): Description of availability status
        operation_id (FdxResourceOperationId3): Operation ID (e.g. name) for
            this Availability
        planned_availability (List[PlannedAvailabilityEntity]): Provider's
            plan for API availability
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "status": 'status',
        "description": 'description',
        "operation_id": 'operationId',
        "planned_availability": 'plannedAvailability'
    }

    _optionals = [
        'status',
        'description',
        'operation_id',
        'planned_availability',
    ]

    def __init__(self,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 operation_id=APIHelper.SKIP,
                 planned_availability=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the AvailabilityEntity1 class"""

        # Initialize members of the class
        if status is not APIHelper.SKIP:
            self.status = status 
        if description is not APIHelper.SKIP:
            self.description = description 
        if operation_id is not APIHelper.SKIP:
            self.operation_id = operation_id 
        if planned_availability is not APIHelper.SKIP:
            self.planned_availability = planned_availability 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        operation_id = dictionary.get("operationId") if dictionary.get("operationId") else APIHelper.SKIP
        planned_availability = None
        if dictionary.get('plannedAvailability') is not None:
            planned_availability = [PlannedAvailabilityEntity.from_dictionary(x) for x in dictionary.get('plannedAvailability')]
        else:
            planned_availability = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(status,
                   description,
                   operation_id,
                   planned_availability,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'operation_id={(self.operation_id if hasattr(self, "operation_id") else None)!r}, '
                f'planned_availability={(self.planned_availability if hasattr(self, "planned_availability") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'operation_id={(self.operation_id if hasattr(self, "operation_id") else None)!s}, '
                f'planned_availability={(self.planned_availability if hasattr(self, "planned_availability") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
