# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.certification_metric_entity import CertificationMetricEntity


class CertificationMetricsEntity(object):

    """Implementation of the 'Certification Metrics entity' model.

    Response object for /certification-metrics API

    Attributes:
        metrics (List[CertificationMetricEntity]): Zero or more certification
            performance metrics
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "metrics": 'metrics'
    }

    _optionals = [
        'metrics',
    ]

    def __init__(self,
                 metrics=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CertificationMetricsEntity class"""

        # Initialize members of the class
        if metrics is not APIHelper.SKIP:
            self.metrics = metrics 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        metrics = None
        if dictionary.get('metrics') is not None:
            metrics = [CertificationMetricEntity.from_dictionary(x) for x in dictionary.get('metrics')]
        else:
            metrics = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(metrics,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'metrics={(self.metrics if hasattr(self, "metrics") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'metrics={(self.metrics if hasattr(self, "metrics") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
