# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.commercial_code_entity_1 import CommercialCodeEntity1


class CommercialBalanceEntity(object):

    """Implementation of the 'Commercial Balance entity' model.

    A specific treasury management defined balance

    Attributes:
        commercial_code (CommercialCodeEntity1): The code for a specific
            treasury management defined field
        amount (float): The treasury management balance amount
        memo (str): Memo field for the treasury management balance amount
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "commercial_code": 'commercialCode',
        "amount": 'amount',
        "memo": 'memo'
    }

    _optionals = [
        'commercial_code',
        'amount',
        'memo',
    ]

    def __init__(self,
                 commercial_code=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 memo=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CommercialBalanceEntity class"""

        # Initialize members of the class
        if commercial_code is not APIHelper.SKIP:
            self.commercial_code = commercial_code 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if memo is not APIHelper.SKIP:
            self.memo = memo 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        commercial_code = CommercialCodeEntity1.from_dictionary(dictionary.get('commercialCode')) if 'commercialCode' in dictionary.keys() else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        memo = dictionary.get("memo") if dictionary.get("memo") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(commercial_code,
                   amount,
                   memo,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'commercial_code={(self.commercial_code if hasattr(self, "commercial_code") else None)!r}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!r}, '
                f'memo={(self.memo if hasattr(self, "memo") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'commercial_code={(self.commercial_code if hasattr(self, "commercial_code") else None)!s}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!s}, '
                f'memo={(self.memo if hasattr(self, "memo") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
