# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class CurrencyEntity(object):

    """Implementation of the 'Currency entity' model.

    Represents an international currency

    Attributes:
        currency_rate (float): Currency rate between original and converted
            currency
        currency_code (Iso4217CurrencyCode): ISO 4217 currency code
        original_currency_code (Iso4217CurrencyCode1): Original ISO 4217
            currency code
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "currency_rate": 'currencyRate',
        "currency_code": 'currencyCode',
        "original_currency_code": 'originalCurrencyCode'
    }

    _optionals = [
        'currency_rate',
        'currency_code',
        'original_currency_code',
    ]

    def __init__(self,
                 currency_rate=APIHelper.SKIP,
                 currency_code=APIHelper.SKIP,
                 original_currency_code=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CurrencyEntity class"""

        # Initialize members of the class
        if currency_rate is not APIHelper.SKIP:
            self.currency_rate = currency_rate 
        if currency_code is not APIHelper.SKIP:
            self.currency_code = currency_code 
        if original_currency_code is not APIHelper.SKIP:
            self.original_currency_code = original_currency_code 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        currency_rate = dictionary.get("currencyRate") if dictionary.get("currencyRate") else APIHelper.SKIP
        currency_code = dictionary.get("currencyCode") if dictionary.get("currencyCode") else APIHelper.SKIP
        original_currency_code = dictionary.get("originalCurrencyCode") if dictionary.get("originalCurrencyCode") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(currency_rate,
                   currency_code,
                   original_currency_code,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'currency_rate={(self.currency_rate if hasattr(self, "currency_rate") else None)!r}, '
                f'currency_code={(self.currency_code if hasattr(self, "currency_code") else None)!r}, '
                f'original_currency_code={(self.original_currency_code if hasattr(self, "original_currency_code") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'currency_rate={(self.currency_rate if hasattr(self, "currency_rate") else None)!s}, '
                f'currency_code={(self.currency_code if hasattr(self, "currency_code") else None)!s}, '
                f'original_currency_code={(self.original_currency_code if hasattr(self, "original_currency_code") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
