# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.hateoas_link import HateoasLink


class CustomerToAccountRelationshipEntity(object):

    """Implementation of the 'Customer to Account Relationship entity' model.

    Describes an account related to a customer

    Attributes:
        account_id (str): Account ID of the related account
        links (List[HateoasLink]): Links to the account, or to invoke other
            APIs
        relationship (AccountHolderRelationship): Type of relationship to the
            account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_id": 'accountId',
        "links": 'links',
        "relationship": 'relationship'
    }

    _optionals = [
        'account_id',
        'links',
        'relationship',
    ]

    def __init__(self,
                 account_id=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 relationship=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the CustomerToAccountRelationshipEntity class"""

        # Initialize members of the class
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if links is not APIHelper.SKIP:
            self.links = links 
        if relationship is not APIHelper.SKIP:
            self.relationship = relationship 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        relationship = dictionary.get("relationship") if dictionary.get("relationship") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(account_id,
                   links,
                   relationship,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'relationship={(self.relationship if hasattr(self, "relationship") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'relationship={(self.relationship if hasattr(self, "relationship") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
