# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class DirectDepositEntity(object):

    """Implementation of the 'Direct Deposit entity' model.

    Direct deposit details

    Attributes:
        direct_deposit_id (str): Unique identifier of the direct deposit
            configuration
        registration_type_code (str): Type code of a registration for a direct
            deposit account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "direct_deposit_id": 'directDepositId',
        "registration_type_code": 'registrationTypeCode'
    }

    _optionals = [
        'direct_deposit_id',
        'registration_type_code',
    ]

    def __init__(self,
                 direct_deposit_id=APIHelper.SKIP,
                 registration_type_code=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the DirectDepositEntity class"""

        # Initialize members of the class
        if direct_deposit_id is not APIHelper.SKIP:
            self.direct_deposit_id = direct_deposit_id 
        if registration_type_code is not APIHelper.SKIP:
            self.registration_type_code = registration_type_code 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        direct_deposit_id = dictionary.get("directDepositId") if dictionary.get("directDepositId") else APIHelper.SKIP
        registration_type_code = dictionary.get("registrationTypeCode") if dictionary.get("registrationTypeCode") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(direct_deposit_id,
                   registration_type_code,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'direct_deposit_id={(self.direct_deposit_id if hasattr(self, "direct_deposit_id") else None)!r}, '
                f'registration_type_code={(self.registration_type_code if hasattr(self, "registration_type_code") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'direct_deposit_id={(self.direct_deposit_id if hasattr(self, "direct_deposit_id") else None)!s}, '
                f'registration_type_code={(self.registration_type_code if hasattr(self, "registration_type_code") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
