# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.employer_entity_1 import EmployerEntity1


class Employment(object):

    """Implementation of the 'Employment' model.

    Provides a person's employment details

    Attributes:
        employer (EmployerEntity1): The employer for the job/position
        job_title (str): The title of the job/position
        original_hire_date (date): The date when employee joined for the first
            time.
        most_recent_hire_date (date): The date when employee re-joined most
            recently.
        end_date (date): The employment end date
        status (ActiveInactiveStatus2): The employee's employment status,
            ACTIVE or INACTIVE
        supplemental_status (SupplementalStatus2): Supplemental detail of
            employee's employment status
        mtype (EmploymentType2): The employee's employment type, CONTRACTED,
            FULL-TIME, OTHER, PART-TIME, SEASONAL, TEMPORARY
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "employer": 'employer',
        "status": 'status',
        "job_title": 'jobTitle',
        "original_hire_date": 'originalHireDate',
        "most_recent_hire_date": 'mostRecentHireDate',
        "end_date": 'endDate',
        "supplemental_status": 'supplementalStatus',
        "mtype": 'type'
    }

    _optionals = [
        'job_title',
        'original_hire_date',
        'most_recent_hire_date',
        'end_date',
        'supplemental_status',
        'mtype',
    ]

    def __init__(self,
                 employer=None,
                 status=None,
                 job_title=APIHelper.SKIP,
                 original_hire_date=APIHelper.SKIP,
                 most_recent_hire_date=APIHelper.SKIP,
                 end_date=APIHelper.SKIP,
                 supplemental_status=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Employment class"""

        # Initialize members of the class
        self.employer = employer 
        if job_title is not APIHelper.SKIP:
            self.job_title = job_title 
        if original_hire_date is not APIHelper.SKIP:
            self.original_hire_date = original_hire_date 
        if most_recent_hire_date is not APIHelper.SKIP:
            self.most_recent_hire_date = most_recent_hire_date 
        if end_date is not APIHelper.SKIP:
            self.end_date = end_date 
        self.status = status 
        if supplemental_status is not APIHelper.SKIP:
            self.supplemental_status = supplemental_status 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        employer = EmployerEntity1.from_dictionary(dictionary.get('employer')) if dictionary.get('employer') else None
        status = dictionary.get("status") if dictionary.get("status") else None
        job_title = dictionary.get("jobTitle") if dictionary.get("jobTitle") else APIHelper.SKIP
        original_hire_date = dateutil.parser.parse(dictionary.get('originalHireDate')).date() if dictionary.get('originalHireDate') else APIHelper.SKIP
        most_recent_hire_date = dateutil.parser.parse(dictionary.get('mostRecentHireDate')).date() if dictionary.get('mostRecentHireDate') else APIHelper.SKIP
        end_date = dateutil.parser.parse(dictionary.get('endDate')).date() if dictionary.get('endDate') else APIHelper.SKIP
        supplemental_status = dictionary.get("supplementalStatus") if dictionary.get("supplementalStatus") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(employer,
                   status,
                   job_title,
                   original_hire_date,
                   most_recent_hire_date,
                   end_date,
                   supplemental_status,
                   mtype,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'employer={self.employer!r}, '
                f'job_title={(self.job_title if hasattr(self, "job_title") else None)!r}, '
                f'original_hire_date={(self.original_hire_date if hasattr(self, "original_hire_date") else None)!r}, '
                f'most_recent_hire_date={(self.most_recent_hire_date if hasattr(self, "most_recent_hire_date") else None)!r}, '
                f'end_date={(self.end_date if hasattr(self, "end_date") else None)!r}, '
                f'status={self.status!r}, '
                f'supplemental_status={(self.supplemental_status if hasattr(self, "supplemental_status") else None)!r}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'employer={self.employer!s}, '
                f'job_title={(self.job_title if hasattr(self, "job_title") else None)!s}, '
                f'original_hire_date={(self.original_hire_date if hasattr(self, "original_hire_date") else None)!s}, '
                f'most_recent_hire_date={(self.most_recent_hire_date if hasattr(self, "most_recent_hire_date") else None)!s}, '
                f'end_date={(self.end_date if hasattr(self, "end_date") else None)!s}, '
                f'status={self.status!s}, '
                f'supplemental_status={(self.supplemental_status if hasattr(self, "supplemental_status") else None)!s}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
