# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.security_detail_irs_form_1099_b import SecurityDetailIrsForm1099B
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099B(object):

    """Implementation of the 'Form 1099-B' model.

    Proceeds From Broker and Barter Exchange Transactions, from PAYER (1st-2nd
    boxes as issuer) to RECIPIENT (3rd-6th boxes)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 14-16,
            State and Local tax withholding
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        profit_on_closed_contracts (float): Box 8, Profit or (loss) realized
            in current year on closed contracts
        unrealized_profit_open_contracts_begin (float): Box 9, Unrealized
            profit or loss on open contracts at end of last year
        unrealized_profit_open_contracts_end (float): Box 10, Unrealized
            profit or loss on open contracts at end of current year
        aggregate_profit_on_contracts (float): Box 11, Aggregate profit or
            (loss) on contracts
        bartering (float): Box 13, Bartering
        security_details (List[SecurityDetailIrsForm1099B]): Boxes 1-3, 5-7,
            12, Security details
        second_tin_notice (bool): Second TIN Notice
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "state_and_local": 'stateAndLocal',
        "federal_tax_withheld": 'federalTaxWithheld',
        "profit_on_closed_contracts": 'profitOnClosedContracts',
        "unrealized_profit_open_contracts_begin": 'unrealizedProfitOpenContractsBegin',
        "unrealized_profit_open_contracts_end": 'unrealizedProfitOpenContractsEnd',
        "aggregate_profit_on_contracts": 'aggregateProfitOnContracts',
        "bartering": 'bartering',
        "security_details": 'securityDetails',
        "second_tin_notice": 'secondTinNotice'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'state_and_local',
        'federal_tax_withheld',
        'profit_on_closed_contracts',
        'unrealized_profit_open_contracts_begin',
        'unrealized_profit_open_contracts_end',
        'aggregate_profit_on_contracts',
        'bartering',
        'security_details',
        'second_tin_notice',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 profit_on_closed_contracts=APIHelper.SKIP,
                 unrealized_profit_open_contracts_begin=APIHelper.SKIP,
                 unrealized_profit_open_contracts_end=APIHelper.SKIP,
                 aggregate_profit_on_contracts=APIHelper.SKIP,
                 bartering=APIHelper.SKIP,
                 security_details=APIHelper.SKIP,
                 second_tin_notice=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099B class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if profit_on_closed_contracts is not APIHelper.SKIP:
            self.profit_on_closed_contracts = profit_on_closed_contracts 
        if unrealized_profit_open_contracts_begin is not APIHelper.SKIP:
            self.unrealized_profit_open_contracts_begin = unrealized_profit_open_contracts_begin 
        if unrealized_profit_open_contracts_end is not APIHelper.SKIP:
            self.unrealized_profit_open_contracts_end = unrealized_profit_open_contracts_end 
        if aggregate_profit_on_contracts is not APIHelper.SKIP:
            self.aggregate_profit_on_contracts = aggregate_profit_on_contracts 
        if bartering is not APIHelper.SKIP:
            self.bartering = bartering 
        if security_details is not APIHelper.SKIP:
            self.security_details = security_details 
        if second_tin_notice is not APIHelper.SKIP:
            self.second_tin_notice = second_tin_notice 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        profit_on_closed_contracts = dictionary.get("profitOnClosedContracts") if dictionary.get("profitOnClosedContracts") else APIHelper.SKIP
        unrealized_profit_open_contracts_begin = dictionary.get("unrealizedProfitOpenContractsBegin") if dictionary.get("unrealizedProfitOpenContractsBegin") else APIHelper.SKIP
        unrealized_profit_open_contracts_end = dictionary.get("unrealizedProfitOpenContractsEnd") if dictionary.get("unrealizedProfitOpenContractsEnd") else APIHelper.SKIP
        aggregate_profit_on_contracts = dictionary.get("aggregateProfitOnContracts") if dictionary.get("aggregateProfitOnContracts") else APIHelper.SKIP
        bartering = dictionary.get("bartering") if dictionary.get("bartering") else APIHelper.SKIP
        security_details = None
        if dictionary.get('securityDetails') is not None:
            security_details = [SecurityDetailIrsForm1099B.from_dictionary(x) for x in dictionary.get('securityDetails')]
        else:
            security_details = APIHelper.SKIP
        second_tin_notice = dictionary.get("secondTinNotice") if "secondTinNotice" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   state_and_local,
                   federal_tax_withheld,
                   profit_on_closed_contracts,
                   unrealized_profit_open_contracts_begin,
                   unrealized_profit_open_contracts_end,
                   aggregate_profit_on_contracts,
                   bartering,
                   security_details,
                   second_tin_notice,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'profit_on_closed_contracts={(self.profit_on_closed_contracts if hasattr(self, "profit_on_closed_contracts") else None)!r}, '
                f'unrealized_profit_open_contracts_begin={(self.unrealized_profit_open_contracts_begin if hasattr(self, "unrealized_profit_open_contracts_begin") else None)!r}, '
                f'unrealized_profit_open_contracts_end={(self.unrealized_profit_open_contracts_end if hasattr(self, "unrealized_profit_open_contracts_end") else None)!r}, '
                f'aggregate_profit_on_contracts={(self.aggregate_profit_on_contracts if hasattr(self, "aggregate_profit_on_contracts") else None)!r}, '
                f'bartering={(self.bartering if hasattr(self, "bartering") else None)!r}, '
                f'security_details={(self.security_details if hasattr(self, "security_details") else None)!r}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'profit_on_closed_contracts={(self.profit_on_closed_contracts if hasattr(self, "profit_on_closed_contracts") else None)!s}, '
                f'unrealized_profit_open_contracts_begin={(self.unrealized_profit_open_contracts_begin if hasattr(self, "unrealized_profit_open_contracts_begin") else None)!s}, '
                f'unrealized_profit_open_contracts_end={(self.unrealized_profit_open_contracts_end if hasattr(self, "unrealized_profit_open_contracts_end") else None)!s}, '
                f'aggregate_profit_on_contracts={(self.aggregate_profit_on_contracts if hasattr(self, "aggregate_profit_on_contracts") else None)!s}, '
                f'bartering={(self.bartering if hasattr(self, "bartering") else None)!s}, '
                f'security_details={(self.security_details if hasattr(self, "security_details") else None)!s}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
