# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099Cap1(object):

    """Implementation of the 'Form 1099-CAP1' model.

    Changes in Corporate Control and Capital Structure

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        date_of_sale (date): Box 1, Date of sale or exchange
        aggregate_amount (float): Box 2, Aggregate amount received
        number_of_shares (float): Box 3, Number of shares exchanged
        stock_classes (str): Box 4, Classes of stock exchanged
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "date_of_sale": 'dateOfSale',
        "aggregate_amount": 'aggregateAmount',
        "number_of_shares": 'numberOfShares',
        "stock_classes": 'stockClasses'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'date_of_sale',
        'aggregate_amount',
        'number_of_shares',
        'stock_classes',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 date_of_sale=APIHelper.SKIP,
                 aggregate_amount=APIHelper.SKIP,
                 number_of_shares=APIHelper.SKIP,
                 stock_classes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099Cap1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if date_of_sale is not APIHelper.SKIP:
            self.date_of_sale = date_of_sale 
        if aggregate_amount is not APIHelper.SKIP:
            self.aggregate_amount = aggregate_amount 
        if number_of_shares is not APIHelper.SKIP:
            self.number_of_shares = number_of_shares 
        if stock_classes is not APIHelper.SKIP:
            self.stock_classes = stock_classes 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        date_of_sale = dateutil.parser.parse(dictionary.get('dateOfSale')).date() if dictionary.get('dateOfSale') else APIHelper.SKIP
        aggregate_amount = dictionary.get("aggregateAmount") if dictionary.get("aggregateAmount") else APIHelper.SKIP
        number_of_shares = dictionary.get("numberOfShares") if dictionary.get("numberOfShares") else APIHelper.SKIP
        stock_classes = dictionary.get("stockClasses") if dictionary.get("stockClasses") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   date_of_sale,
                   aggregate_amount,
                   number_of_shares,
                   stock_classes,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'date_of_sale={(self.date_of_sale if hasattr(self, "date_of_sale") else None)!r}, '
                f'aggregate_amount={(self.aggregate_amount if hasattr(self, "aggregate_amount") else None)!r}, '
                f'number_of_shares={(self.number_of_shares if hasattr(self, "number_of_shares") else None)!r}, '
                f'stock_classes={(self.stock_classes if hasattr(self, "stock_classes") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'date_of_sale={(self.date_of_sale if hasattr(self, "date_of_sale") else None)!s}, '
                f'aggregate_amount={(self.aggregate_amount if hasattr(self, "aggregate_amount") else None)!s}, '
                f'number_of_shares={(self.number_of_shares if hasattr(self, "number_of_shares") else None)!s}, '
                f'stock_classes={(self.stock_classes if hasattr(self, "stock_classes") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
