# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding_2 import StateAndLocalTaxWithholding2
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1099Patr1(object):

    """Implementation of the 'Form 1099-PATR1' model.

    Taxable Distributions Received From Cooperatives

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        patronage_dividends (float): Box 1, Patronage dividends
        nonpatronage_distributions (float): Box 2, Nonpatronage distributions
        per_unit_retain_allocations (float): Box 3, Per-unit retain allocations
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        redemption (float): Box 5, Redemption of nonqualified notices and
            retain allocations
        section_199_deduction (float): Box 6, Section 199A(g) deduction
        qualified_payments (float): Box 7, Qualified payments
        section_199_qualified_items (float): Box 8, Section 199A(a) qualified
            items
        section_199_sstb_items (float): Box 9, Section 199A(a) SSTB (Specified
            Service Trade or Business) items
        investment_credit (float): Box 10, Investment credit
        work_opportunity_credit (float): Box 11, Work opportunity credit
        other_credits_and_deductions (float): Box 12, Other credits and
            deductions
        specified_coop (bool): Box 13, Specified Cooperative
        state_and_local (StateAndLocalTaxWithholding2): State and Local tax
            withholding, from IRS's IRIS schema
        second_tin_notice (bool): Second TIN Notice
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "patronage_dividends": 'patronageDividends',
        "nonpatronage_distributions": 'nonpatronageDistributions',
        "per_unit_retain_allocations": 'perUnitRetainAllocations',
        "federal_tax_withheld": 'federalTaxWithheld',
        "redemption": 'redemption',
        "section_199_deduction": 'section199Deduction',
        "qualified_payments": 'qualifiedPayments',
        "section_199_qualified_items": 'section199QualifiedItems',
        "section_199_sstb_items": 'section199SstbItems',
        "investment_credit": 'investmentCredit',
        "work_opportunity_credit": 'workOpportunityCredit',
        "other_credits_and_deductions": 'otherCreditsAndDeductions',
        "specified_coop": 'specifiedCoop',
        "state_and_local": 'stateAndLocal',
        "second_tin_notice": 'secondTinNotice'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'patronage_dividends',
        'nonpatronage_distributions',
        'per_unit_retain_allocations',
        'federal_tax_withheld',
        'redemption',
        'section_199_deduction',
        'qualified_payments',
        'section_199_qualified_items',
        'section_199_sstb_items',
        'investment_credit',
        'work_opportunity_credit',
        'other_credits_and_deductions',
        'specified_coop',
        'state_and_local',
        'second_tin_notice',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 patronage_dividends=APIHelper.SKIP,
                 nonpatronage_distributions=APIHelper.SKIP,
                 per_unit_retain_allocations=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 redemption=APIHelper.SKIP,
                 section_199_deduction=APIHelper.SKIP,
                 qualified_payments=APIHelper.SKIP,
                 section_199_qualified_items=APIHelper.SKIP,
                 section_199_sstb_items=APIHelper.SKIP,
                 investment_credit=APIHelper.SKIP,
                 work_opportunity_credit=APIHelper.SKIP,
                 other_credits_and_deductions=APIHelper.SKIP,
                 specified_coop=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 second_tin_notice=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1099Patr1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if patronage_dividends is not APIHelper.SKIP:
            self.patronage_dividends = patronage_dividends 
        if nonpatronage_distributions is not APIHelper.SKIP:
            self.nonpatronage_distributions = nonpatronage_distributions 
        if per_unit_retain_allocations is not APIHelper.SKIP:
            self.per_unit_retain_allocations = per_unit_retain_allocations 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if redemption is not APIHelper.SKIP:
            self.redemption = redemption 
        if section_199_deduction is not APIHelper.SKIP:
            self.section_199_deduction = section_199_deduction 
        if qualified_payments is not APIHelper.SKIP:
            self.qualified_payments = qualified_payments 
        if section_199_qualified_items is not APIHelper.SKIP:
            self.section_199_qualified_items = section_199_qualified_items 
        if section_199_sstb_items is not APIHelper.SKIP:
            self.section_199_sstb_items = section_199_sstb_items 
        if investment_credit is not APIHelper.SKIP:
            self.investment_credit = investment_credit 
        if work_opportunity_credit is not APIHelper.SKIP:
            self.work_opportunity_credit = work_opportunity_credit 
        if other_credits_and_deductions is not APIHelper.SKIP:
            self.other_credits_and_deductions = other_credits_and_deductions 
        if specified_coop is not APIHelper.SKIP:
            self.specified_coop = specified_coop 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 
        if second_tin_notice is not APIHelper.SKIP:
            self.second_tin_notice = second_tin_notice 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        patronage_dividends = dictionary.get("patronageDividends") if dictionary.get("patronageDividends") else APIHelper.SKIP
        nonpatronage_distributions = dictionary.get("nonpatronageDistributions") if dictionary.get("nonpatronageDistributions") else APIHelper.SKIP
        per_unit_retain_allocations = dictionary.get("perUnitRetainAllocations") if dictionary.get("perUnitRetainAllocations") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        redemption = dictionary.get("redemption") if dictionary.get("redemption") else APIHelper.SKIP
        section_199_deduction = dictionary.get("section199Deduction") if dictionary.get("section199Deduction") else APIHelper.SKIP
        qualified_payments = dictionary.get("qualifiedPayments") if dictionary.get("qualifiedPayments") else APIHelper.SKIP
        section_199_qualified_items = dictionary.get("section199QualifiedItems") if dictionary.get("section199QualifiedItems") else APIHelper.SKIP
        section_199_sstb_items = dictionary.get("section199SstbItems") if dictionary.get("section199SstbItems") else APIHelper.SKIP
        investment_credit = dictionary.get("investmentCredit") if dictionary.get("investmentCredit") else APIHelper.SKIP
        work_opportunity_credit = dictionary.get("workOpportunityCredit") if dictionary.get("workOpportunityCredit") else APIHelper.SKIP
        other_credits_and_deductions = dictionary.get("otherCreditsAndDeductions") if dictionary.get("otherCreditsAndDeductions") else APIHelper.SKIP
        specified_coop = dictionary.get("specifiedCoop") if "specifiedCoop" in dictionary.keys() else APIHelper.SKIP
        state_and_local = StateAndLocalTaxWithholding2.from_dictionary(dictionary.get('stateAndLocal')) if 'stateAndLocal' in dictionary.keys() else APIHelper.SKIP
        second_tin_notice = dictionary.get("secondTinNotice") if "secondTinNotice" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   patronage_dividends,
                   nonpatronage_distributions,
                   per_unit_retain_allocations,
                   federal_tax_withheld,
                   redemption,
                   section_199_deduction,
                   qualified_payments,
                   section_199_qualified_items,
                   section_199_sstb_items,
                   investment_credit,
                   work_opportunity_credit,
                   other_credits_and_deductions,
                   specified_coop,
                   state_and_local,
                   second_tin_notice,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'patronage_dividends={(self.patronage_dividends if hasattr(self, "patronage_dividends") else None)!r}, '
                f'nonpatronage_distributions={(self.nonpatronage_distributions if hasattr(self, "nonpatronage_distributions") else None)!r}, '
                f'per_unit_retain_allocations={(self.per_unit_retain_allocations if hasattr(self, "per_unit_retain_allocations") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'redemption={(self.redemption if hasattr(self, "redemption") else None)!r}, '
                f'section_199_deduction={(self.section_199_deduction if hasattr(self, "section_199_deduction") else None)!r}, '
                f'qualified_payments={(self.qualified_payments if hasattr(self, "qualified_payments") else None)!r}, '
                f'section_199_qualified_items={(self.section_199_qualified_items if hasattr(self, "section_199_qualified_items") else None)!r}, '
                f'section_199_sstb_items={(self.section_199_sstb_items if hasattr(self, "section_199_sstb_items") else None)!r}, '
                f'investment_credit={(self.investment_credit if hasattr(self, "investment_credit") else None)!r}, '
                f'work_opportunity_credit={(self.work_opportunity_credit if hasattr(self, "work_opportunity_credit") else None)!r}, '
                f'other_credits_and_deductions={(self.other_credits_and_deductions if hasattr(self, "other_credits_and_deductions") else None)!r}, '
                f'specified_coop={(self.specified_coop if hasattr(self, "specified_coop") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'patronage_dividends={(self.patronage_dividends if hasattr(self, "patronage_dividends") else None)!s}, '
                f'nonpatronage_distributions={(self.nonpatronage_distributions if hasattr(self, "nonpatronage_distributions") else None)!s}, '
                f'per_unit_retain_allocations={(self.per_unit_retain_allocations if hasattr(self, "per_unit_retain_allocations") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'redemption={(self.redemption if hasattr(self, "redemption") else None)!s}, '
                f'section_199_deduction={(self.section_199_deduction if hasattr(self, "section_199_deduction") else None)!s}, '
                f'qualified_payments={(self.qualified_payments if hasattr(self, "qualified_payments") else None)!s}, '
                f'section_199_qualified_items={(self.section_199_qualified_items if hasattr(self, "section_199_qualified_items") else None)!s}, '
                f'section_199_sstb_items={(self.section_199_sstb_items if hasattr(self, "section_199_sstb_items") else None)!s}, '
                f'investment_credit={(self.investment_credit if hasattr(self, "investment_credit") else None)!s}, '
                f'work_opportunity_credit={(self.work_opportunity_credit if hasattr(self, "work_opportunity_credit") else None)!s}, '
                f'other_credits_and_deductions={(self.other_credits_and_deductions if hasattr(self, "other_credits_and_deductions") else None)!s}, '
                f'specified_coop={(self.specified_coop if hasattr(self, "specified_coop") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'second_tin_notice={(self.second_tin_notice if hasattr(self, "second_tin_notice") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
