# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.code_and_amount import CodeAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form1120SK1(object):

    """Implementation of the 'Form 1120-S K-1' model.

    Shareholder's Share of Income, Deductions, Credits, etc., from Corporation
    (boxes A-B as issuer) to Shareholder (boxes E-F as recipient)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        final_k_1 (bool): Final K-1
        amended_k_1 (bool): Amended K-1
        fiscal_year_begin (date): Fiscal year begin date
        fiscal_year_end (date): Fiscal year end date
        irs_center (str): Box C, IRS Center where corporation filed return
        corporation_beginning_shares (float): Box D, Corporation's total
            number of shares, Beginning of tax year
        corporation_ending_shares (float): Box D, Corporation's total number
            of shares, End of tax year
        percent_ownership (float): Box G, Current year allocation percentage
        beginning_shares (float): Box H, Shareholder's number of shares,
            Beginning of tax year
        ending_shares (float): Box H, Shareholder's number of shares, End of
            tax year
        beginning_loans (float): Box I, Loans from shareholder, Beginning of
            tax year
        ending_loans (float): Box I, Loans from shareholder, Ending of tax year
        ordinary_income (float): Box 1, Ordinary business income (loss)
        net_rental_real_estate_income (float): Box 2, Net rental real estate
            income (loss)
        other_rental_income (float): Box 3, Other net rental income (loss)
        interest_income (float): Box 4, Interest income
        ordinary_dividends (float): Box 5a, Ordinary dividends
        qualified_dividends (float): Box 5b, Qualified dividends
        royalties (float): Box 6, Royalties
        net_short_term_gain (float): Box 7, Net short-term capital gain (loss)
        net_long_term_gain (float): Box 8a, Net long-term capital gain (loss)
        collectibles_gain (float): Box 8b, Collectibles (28%) gain (loss)
        unrecaptured_1250_gain (float): Box 8c, Unrecaptured section 1250 gain
        net_1231_gain (float): Box 9, Net section 1231 gain (loss)
        other_income (List[CodeAndAmount]): Box 10, Other income (loss)
        section_179_deduction (float): Box 11, Section 179 deduction
        other_deductions (List[CodeAndAmount]): Box 12, Other deductions
        credits (List[CodeAndAmount]): Box 13, Credits
        schedule_k_3 (bool): Box 14, Schedule K-3 is attached
        amt_items (List[CodeAndAmount]): Box 15, Alternative minimum tax (AMT)
            items
        basis_items (List[CodeAndAmount]): Box 16, Items affecting shareholder
            basis
        other_info (List[CodeAndAmount]): Box 17, Other information
        multiple_at_risk_activities (bool): Box 18, More than one activity for
            at-risk purposes
        multiple_passive_activities (bool): Box 19, More than one activity for
            passive activity purposes
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "final_k_1": 'finalK1',
        "amended_k_1": 'amendedK1',
        "fiscal_year_begin": 'fiscalYearBegin',
        "fiscal_year_end": 'fiscalYearEnd',
        "irs_center": 'irsCenter',
        "corporation_beginning_shares": 'corporationBeginningShares',
        "corporation_ending_shares": 'corporationEndingShares',
        "percent_ownership": 'percentOwnership',
        "beginning_shares": 'beginningShares',
        "ending_shares": 'endingShares',
        "beginning_loans": 'beginningLoans',
        "ending_loans": 'endingLoans',
        "ordinary_income": 'ordinaryIncome',
        "net_rental_real_estate_income": 'netRentalRealEstateIncome',
        "other_rental_income": 'otherRentalIncome',
        "interest_income": 'interestIncome',
        "ordinary_dividends": 'ordinaryDividends',
        "qualified_dividends": 'qualifiedDividends',
        "royalties": 'royalties',
        "net_short_term_gain": 'netShortTermGain',
        "net_long_term_gain": 'netLongTermGain',
        "collectibles_gain": 'collectiblesGain',
        "unrecaptured_1250_gain": 'unrecaptured1250Gain',
        "net_1231_gain": 'net1231Gain',
        "other_income": 'otherIncome',
        "section_179_deduction": 'section179Deduction',
        "other_deductions": 'otherDeductions',
        "credits": 'credits',
        "schedule_k_3": 'scheduleK3',
        "amt_items": 'amtItems',
        "basis_items": 'basisItems',
        "other_info": 'otherInfo',
        "multiple_at_risk_activities": 'multipleAtRiskActivities',
        "multiple_passive_activities": 'multiplePassiveActivities'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'final_k_1',
        'amended_k_1',
        'fiscal_year_begin',
        'fiscal_year_end',
        'irs_center',
        'corporation_beginning_shares',
        'corporation_ending_shares',
        'percent_ownership',
        'beginning_shares',
        'ending_shares',
        'beginning_loans',
        'ending_loans',
        'ordinary_income',
        'net_rental_real_estate_income',
        'other_rental_income',
        'interest_income',
        'ordinary_dividends',
        'qualified_dividends',
        'royalties',
        'net_short_term_gain',
        'net_long_term_gain',
        'collectibles_gain',
        'unrecaptured_1250_gain',
        'net_1231_gain',
        'other_income',
        'section_179_deduction',
        'other_deductions',
        'credits',
        'schedule_k_3',
        'amt_items',
        'basis_items',
        'other_info',
        'multiple_at_risk_activities',
        'multiple_passive_activities',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 final_k_1=APIHelper.SKIP,
                 amended_k_1=APIHelper.SKIP,
                 fiscal_year_begin=APIHelper.SKIP,
                 fiscal_year_end=APIHelper.SKIP,
                 irs_center=APIHelper.SKIP,
                 corporation_beginning_shares=APIHelper.SKIP,
                 corporation_ending_shares=APIHelper.SKIP,
                 percent_ownership=APIHelper.SKIP,
                 beginning_shares=APIHelper.SKIP,
                 ending_shares=APIHelper.SKIP,
                 beginning_loans=APIHelper.SKIP,
                 ending_loans=APIHelper.SKIP,
                 ordinary_income=APIHelper.SKIP,
                 net_rental_real_estate_income=APIHelper.SKIP,
                 other_rental_income=APIHelper.SKIP,
                 interest_income=APIHelper.SKIP,
                 ordinary_dividends=APIHelper.SKIP,
                 qualified_dividends=APIHelper.SKIP,
                 royalties=APIHelper.SKIP,
                 net_short_term_gain=APIHelper.SKIP,
                 net_long_term_gain=APIHelper.SKIP,
                 collectibles_gain=APIHelper.SKIP,
                 unrecaptured_1250_gain=APIHelper.SKIP,
                 net_1231_gain=APIHelper.SKIP,
                 other_income=APIHelper.SKIP,
                 section_179_deduction=APIHelper.SKIP,
                 other_deductions=APIHelper.SKIP,
                 credits=APIHelper.SKIP,
                 schedule_k_3=APIHelper.SKIP,
                 amt_items=APIHelper.SKIP,
                 basis_items=APIHelper.SKIP,
                 other_info=APIHelper.SKIP,
                 multiple_at_risk_activities=APIHelper.SKIP,
                 multiple_passive_activities=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form1120SK1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if final_k_1 is not APIHelper.SKIP:
            self.final_k_1 = final_k_1 
        if amended_k_1 is not APIHelper.SKIP:
            self.amended_k_1 = amended_k_1 
        if fiscal_year_begin is not APIHelper.SKIP:
            self.fiscal_year_begin = fiscal_year_begin 
        if fiscal_year_end is not APIHelper.SKIP:
            self.fiscal_year_end = fiscal_year_end 
        if irs_center is not APIHelper.SKIP:
            self.irs_center = irs_center 
        if corporation_beginning_shares is not APIHelper.SKIP:
            self.corporation_beginning_shares = corporation_beginning_shares 
        if corporation_ending_shares is not APIHelper.SKIP:
            self.corporation_ending_shares = corporation_ending_shares 
        if percent_ownership is not APIHelper.SKIP:
            self.percent_ownership = percent_ownership 
        if beginning_shares is not APIHelper.SKIP:
            self.beginning_shares = beginning_shares 
        if ending_shares is not APIHelper.SKIP:
            self.ending_shares = ending_shares 
        if beginning_loans is not APIHelper.SKIP:
            self.beginning_loans = beginning_loans 
        if ending_loans is not APIHelper.SKIP:
            self.ending_loans = ending_loans 
        if ordinary_income is not APIHelper.SKIP:
            self.ordinary_income = ordinary_income 
        if net_rental_real_estate_income is not APIHelper.SKIP:
            self.net_rental_real_estate_income = net_rental_real_estate_income 
        if other_rental_income is not APIHelper.SKIP:
            self.other_rental_income = other_rental_income 
        if interest_income is not APIHelper.SKIP:
            self.interest_income = interest_income 
        if ordinary_dividends is not APIHelper.SKIP:
            self.ordinary_dividends = ordinary_dividends 
        if qualified_dividends is not APIHelper.SKIP:
            self.qualified_dividends = qualified_dividends 
        if royalties is not APIHelper.SKIP:
            self.royalties = royalties 
        if net_short_term_gain is not APIHelper.SKIP:
            self.net_short_term_gain = net_short_term_gain 
        if net_long_term_gain is not APIHelper.SKIP:
            self.net_long_term_gain = net_long_term_gain 
        if collectibles_gain is not APIHelper.SKIP:
            self.collectibles_gain = collectibles_gain 
        if unrecaptured_1250_gain is not APIHelper.SKIP:
            self.unrecaptured_1250_gain = unrecaptured_1250_gain 
        if net_1231_gain is not APIHelper.SKIP:
            self.net_1231_gain = net_1231_gain 
        if other_income is not APIHelper.SKIP:
            self.other_income = other_income 
        if section_179_deduction is not APIHelper.SKIP:
            self.section_179_deduction = section_179_deduction 
        if other_deductions is not APIHelper.SKIP:
            self.other_deductions = other_deductions 
        if credits is not APIHelper.SKIP:
            self.credits = credits 
        if schedule_k_3 is not APIHelper.SKIP:
            self.schedule_k_3 = schedule_k_3 
        if amt_items is not APIHelper.SKIP:
            self.amt_items = amt_items 
        if basis_items is not APIHelper.SKIP:
            self.basis_items = basis_items 
        if other_info is not APIHelper.SKIP:
            self.other_info = other_info 
        if multiple_at_risk_activities is not APIHelper.SKIP:
            self.multiple_at_risk_activities = multiple_at_risk_activities 
        if multiple_passive_activities is not APIHelper.SKIP:
            self.multiple_passive_activities = multiple_passive_activities 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        final_k_1 = dictionary.get("finalK1") if "finalK1" in dictionary.keys() else APIHelper.SKIP
        amended_k_1 = dictionary.get("amendedK1") if "amendedK1" in dictionary.keys() else APIHelper.SKIP
        fiscal_year_begin = dateutil.parser.parse(dictionary.get('fiscalYearBegin')).date() if dictionary.get('fiscalYearBegin') else APIHelper.SKIP
        fiscal_year_end = dateutil.parser.parse(dictionary.get('fiscalYearEnd')).date() if dictionary.get('fiscalYearEnd') else APIHelper.SKIP
        irs_center = dictionary.get("irsCenter") if dictionary.get("irsCenter") else APIHelper.SKIP
        corporation_beginning_shares = dictionary.get("corporationBeginningShares") if dictionary.get("corporationBeginningShares") else APIHelper.SKIP
        corporation_ending_shares = dictionary.get("corporationEndingShares") if dictionary.get("corporationEndingShares") else APIHelper.SKIP
        percent_ownership = dictionary.get("percentOwnership") if dictionary.get("percentOwnership") else APIHelper.SKIP
        beginning_shares = dictionary.get("beginningShares") if dictionary.get("beginningShares") else APIHelper.SKIP
        ending_shares = dictionary.get("endingShares") if dictionary.get("endingShares") else APIHelper.SKIP
        beginning_loans = dictionary.get("beginningLoans") if dictionary.get("beginningLoans") else APIHelper.SKIP
        ending_loans = dictionary.get("endingLoans") if dictionary.get("endingLoans") else APIHelper.SKIP
        ordinary_income = dictionary.get("ordinaryIncome") if dictionary.get("ordinaryIncome") else APIHelper.SKIP
        net_rental_real_estate_income = dictionary.get("netRentalRealEstateIncome") if dictionary.get("netRentalRealEstateIncome") else APIHelper.SKIP
        other_rental_income = dictionary.get("otherRentalIncome") if dictionary.get("otherRentalIncome") else APIHelper.SKIP
        interest_income = dictionary.get("interestIncome") if dictionary.get("interestIncome") else APIHelper.SKIP
        ordinary_dividends = dictionary.get("ordinaryDividends") if dictionary.get("ordinaryDividends") else APIHelper.SKIP
        qualified_dividends = dictionary.get("qualifiedDividends") if dictionary.get("qualifiedDividends") else APIHelper.SKIP
        royalties = dictionary.get("royalties") if dictionary.get("royalties") else APIHelper.SKIP
        net_short_term_gain = dictionary.get("netShortTermGain") if dictionary.get("netShortTermGain") else APIHelper.SKIP
        net_long_term_gain = dictionary.get("netLongTermGain") if dictionary.get("netLongTermGain") else APIHelper.SKIP
        collectibles_gain = dictionary.get("collectiblesGain") if dictionary.get("collectiblesGain") else APIHelper.SKIP
        unrecaptured_1250_gain = dictionary.get("unrecaptured1250Gain") if dictionary.get("unrecaptured1250Gain") else APIHelper.SKIP
        net_1231_gain = dictionary.get("net1231Gain") if dictionary.get("net1231Gain") else APIHelper.SKIP
        other_income = None
        if dictionary.get('otherIncome') is not None:
            other_income = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('otherIncome')]
        else:
            other_income = APIHelper.SKIP
        section_179_deduction = dictionary.get("section179Deduction") if dictionary.get("section179Deduction") else APIHelper.SKIP
        other_deductions = None
        if dictionary.get('otherDeductions') is not None:
            other_deductions = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('otherDeductions')]
        else:
            other_deductions = APIHelper.SKIP
        credits = None
        if dictionary.get('credits') is not None:
            credits = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('credits')]
        else:
            credits = APIHelper.SKIP
        schedule_k_3 = dictionary.get("scheduleK3") if "scheduleK3" in dictionary.keys() else APIHelper.SKIP
        amt_items = None
        if dictionary.get('amtItems') is not None:
            amt_items = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('amtItems')]
        else:
            amt_items = APIHelper.SKIP
        basis_items = None
        if dictionary.get('basisItems') is not None:
            basis_items = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('basisItems')]
        else:
            basis_items = APIHelper.SKIP
        other_info = None
        if dictionary.get('otherInfo') is not None:
            other_info = [CodeAndAmount.from_dictionary(x) for x in dictionary.get('otherInfo')]
        else:
            other_info = APIHelper.SKIP
        multiple_at_risk_activities = dictionary.get("multipleAtRiskActivities") if "multipleAtRiskActivities" in dictionary.keys() else APIHelper.SKIP
        multiple_passive_activities = dictionary.get("multiplePassiveActivities") if "multiplePassiveActivities" in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   final_k_1,
                   amended_k_1,
                   fiscal_year_begin,
                   fiscal_year_end,
                   irs_center,
                   corporation_beginning_shares,
                   corporation_ending_shares,
                   percent_ownership,
                   beginning_shares,
                   ending_shares,
                   beginning_loans,
                   ending_loans,
                   ordinary_income,
                   net_rental_real_estate_income,
                   other_rental_income,
                   interest_income,
                   ordinary_dividends,
                   qualified_dividends,
                   royalties,
                   net_short_term_gain,
                   net_long_term_gain,
                   collectibles_gain,
                   unrecaptured_1250_gain,
                   net_1231_gain,
                   other_income,
                   section_179_deduction,
                   other_deductions,
                   credits,
                   schedule_k_3,
                   amt_items,
                   basis_items,
                   other_info,
                   multiple_at_risk_activities,
                   multiple_passive_activities,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'final_k_1={(self.final_k_1 if hasattr(self, "final_k_1") else None)!r}, '
                f'amended_k_1={(self.amended_k_1 if hasattr(self, "amended_k_1") else None)!r}, '
                f'fiscal_year_begin={(self.fiscal_year_begin if hasattr(self, "fiscal_year_begin") else None)!r}, '
                f'fiscal_year_end={(self.fiscal_year_end if hasattr(self, "fiscal_year_end") else None)!r}, '
                f'irs_center={(self.irs_center if hasattr(self, "irs_center") else None)!r}, '
                f'corporation_beginning_shares={(self.corporation_beginning_shares if hasattr(self, "corporation_beginning_shares") else None)!r}, '
                f'corporation_ending_shares={(self.corporation_ending_shares if hasattr(self, "corporation_ending_shares") else None)!r}, '
                f'percent_ownership={(self.percent_ownership if hasattr(self, "percent_ownership") else None)!r}, '
                f'beginning_shares={(self.beginning_shares if hasattr(self, "beginning_shares") else None)!r}, '
                f'ending_shares={(self.ending_shares if hasattr(self, "ending_shares") else None)!r}, '
                f'beginning_loans={(self.beginning_loans if hasattr(self, "beginning_loans") else None)!r}, '
                f'ending_loans={(self.ending_loans if hasattr(self, "ending_loans") else None)!r}, '
                f'ordinary_income={(self.ordinary_income if hasattr(self, "ordinary_income") else None)!r}, '
                f'net_rental_real_estate_income={(self.net_rental_real_estate_income if hasattr(self, "net_rental_real_estate_income") else None)!r}, '
                f'other_rental_income={(self.other_rental_income if hasattr(self, "other_rental_income") else None)!r}, '
                f'interest_income={(self.interest_income if hasattr(self, "interest_income") else None)!r}, '
                f'ordinary_dividends={(self.ordinary_dividends if hasattr(self, "ordinary_dividends") else None)!r}, '
                f'qualified_dividends={(self.qualified_dividends if hasattr(self, "qualified_dividends") else None)!r}, '
                f'royalties={(self.royalties if hasattr(self, "royalties") else None)!r}, '
                f'net_short_term_gain={(self.net_short_term_gain if hasattr(self, "net_short_term_gain") else None)!r}, '
                f'net_long_term_gain={(self.net_long_term_gain if hasattr(self, "net_long_term_gain") else None)!r}, '
                f'collectibles_gain={(self.collectibles_gain if hasattr(self, "collectibles_gain") else None)!r}, '
                f'unrecaptured_1250_gain={(self.unrecaptured_1250_gain if hasattr(self, "unrecaptured_1250_gain") else None)!r}, '
                f'net_1231_gain={(self.net_1231_gain if hasattr(self, "net_1231_gain") else None)!r}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!r}, '
                f'section_179_deduction={(self.section_179_deduction if hasattr(self, "section_179_deduction") else None)!r}, '
                f'other_deductions={(self.other_deductions if hasattr(self, "other_deductions") else None)!r}, '
                f'credits={(self.credits if hasattr(self, "credits") else None)!r}, '
                f'schedule_k_3={(self.schedule_k_3 if hasattr(self, "schedule_k_3") else None)!r}, '
                f'amt_items={(self.amt_items if hasattr(self, "amt_items") else None)!r}, '
                f'basis_items={(self.basis_items if hasattr(self, "basis_items") else None)!r}, '
                f'other_info={(self.other_info if hasattr(self, "other_info") else None)!r}, '
                f'multiple_at_risk_activities={(self.multiple_at_risk_activities if hasattr(self, "multiple_at_risk_activities") else None)!r}, '
                f'multiple_passive_activities={(self.multiple_passive_activities if hasattr(self, "multiple_passive_activities") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'final_k_1={(self.final_k_1 if hasattr(self, "final_k_1") else None)!s}, '
                f'amended_k_1={(self.amended_k_1 if hasattr(self, "amended_k_1") else None)!s}, '
                f'fiscal_year_begin={(self.fiscal_year_begin if hasattr(self, "fiscal_year_begin") else None)!s}, '
                f'fiscal_year_end={(self.fiscal_year_end if hasattr(self, "fiscal_year_end") else None)!s}, '
                f'irs_center={(self.irs_center if hasattr(self, "irs_center") else None)!s}, '
                f'corporation_beginning_shares={(self.corporation_beginning_shares if hasattr(self, "corporation_beginning_shares") else None)!s}, '
                f'corporation_ending_shares={(self.corporation_ending_shares if hasattr(self, "corporation_ending_shares") else None)!s}, '
                f'percent_ownership={(self.percent_ownership if hasattr(self, "percent_ownership") else None)!s}, '
                f'beginning_shares={(self.beginning_shares if hasattr(self, "beginning_shares") else None)!s}, '
                f'ending_shares={(self.ending_shares if hasattr(self, "ending_shares") else None)!s}, '
                f'beginning_loans={(self.beginning_loans if hasattr(self, "beginning_loans") else None)!s}, '
                f'ending_loans={(self.ending_loans if hasattr(self, "ending_loans") else None)!s}, '
                f'ordinary_income={(self.ordinary_income if hasattr(self, "ordinary_income") else None)!s}, '
                f'net_rental_real_estate_income={(self.net_rental_real_estate_income if hasattr(self, "net_rental_real_estate_income") else None)!s}, '
                f'other_rental_income={(self.other_rental_income if hasattr(self, "other_rental_income") else None)!s}, '
                f'interest_income={(self.interest_income if hasattr(self, "interest_income") else None)!s}, '
                f'ordinary_dividends={(self.ordinary_dividends if hasattr(self, "ordinary_dividends") else None)!s}, '
                f'qualified_dividends={(self.qualified_dividends if hasattr(self, "qualified_dividends") else None)!s}, '
                f'royalties={(self.royalties if hasattr(self, "royalties") else None)!s}, '
                f'net_short_term_gain={(self.net_short_term_gain if hasattr(self, "net_short_term_gain") else None)!s}, '
                f'net_long_term_gain={(self.net_long_term_gain if hasattr(self, "net_long_term_gain") else None)!s}, '
                f'collectibles_gain={(self.collectibles_gain if hasattr(self, "collectibles_gain") else None)!s}, '
                f'unrecaptured_1250_gain={(self.unrecaptured_1250_gain if hasattr(self, "unrecaptured_1250_gain") else None)!s}, '
                f'net_1231_gain={(self.net_1231_gain if hasattr(self, "net_1231_gain") else None)!s}, '
                f'other_income={(self.other_income if hasattr(self, "other_income") else None)!s}, '
                f'section_179_deduction={(self.section_179_deduction if hasattr(self, "section_179_deduction") else None)!s}, '
                f'other_deductions={(self.other_deductions if hasattr(self, "other_deductions") else None)!s}, '
                f'credits={(self.credits if hasattr(self, "credits") else None)!s}, '
                f'schedule_k_3={(self.schedule_k_3 if hasattr(self, "schedule_k_3") else None)!s}, '
                f'amt_items={(self.amt_items if hasattr(self, "amt_items") else None)!s}, '
                f'basis_items={(self.basis_items if hasattr(self, "basis_items") else None)!s}, '
                f'other_info={(self.other_info if hasattr(self, "other_info") else None)!s}, '
                f'multiple_at_risk_activities={(self.multiple_at_risk_activities if hasattr(self, "multiple_at_risk_activities") else None)!s}, '
                f'multiple_passive_activities={(self.multiple_passive_activities if hasattr(self, "multiple_passive_activities") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
