# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class Form5498Qa1(object):

    """Implementation of the 'Form 5498-QA1' model.

    ABLE Account Contribution Information

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        account_number (str): Account number
        able_contributions (float): Box 1, ABLE contributions
        rollovers (float): Box 2, ABLE to ABLE Rollovers
        cumulative_contributions (float): Box 3, Cumulative contributions
        fair_market_value (float): Box 4, Fair market value
        opened_in_tax_year (bool): Box 5, Check if account opened in current
            tax year
        basis_of_disability_code (str): Box 6, Basis of eligibility
        type_of_disability_code (str): Box 7, Code
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "account_number": 'accountNumber',
        "able_contributions": 'ableContributions',
        "rollovers": 'rollovers',
        "cumulative_contributions": 'cumulativeContributions',
        "fair_market_value": 'fairMarketValue',
        "opened_in_tax_year": 'openedInTaxYear',
        "basis_of_disability_code": 'basisOfDisabilityCode',
        "type_of_disability_code": 'typeOfDisabilityCode'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'account_number',
        'able_contributions',
        'rollovers',
        'cumulative_contributions',
        'fair_market_value',
        'opened_in_tax_year',
        'basis_of_disability_code',
        'type_of_disability_code',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 able_contributions=APIHelper.SKIP,
                 rollovers=APIHelper.SKIP,
                 cumulative_contributions=APIHelper.SKIP,
                 fair_market_value=APIHelper.SKIP,
                 opened_in_tax_year=APIHelper.SKIP,
                 basis_of_disability_code=APIHelper.SKIP,
                 type_of_disability_code=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Form5498Qa1 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if able_contributions is not APIHelper.SKIP:
            self.able_contributions = able_contributions 
        if rollovers is not APIHelper.SKIP:
            self.rollovers = rollovers 
        if cumulative_contributions is not APIHelper.SKIP:
            self.cumulative_contributions = cumulative_contributions 
        if fair_market_value is not APIHelper.SKIP:
            self.fair_market_value = fair_market_value 
        if opened_in_tax_year is not APIHelper.SKIP:
            self.opened_in_tax_year = opened_in_tax_year 
        if basis_of_disability_code is not APIHelper.SKIP:
            self.basis_of_disability_code = basis_of_disability_code 
        if type_of_disability_code is not APIHelper.SKIP:
            self.type_of_disability_code = type_of_disability_code 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        able_contributions = dictionary.get("ableContributions") if dictionary.get("ableContributions") else APIHelper.SKIP
        rollovers = dictionary.get("rollovers") if dictionary.get("rollovers") else APIHelper.SKIP
        cumulative_contributions = dictionary.get("cumulativeContributions") if dictionary.get("cumulativeContributions") else APIHelper.SKIP
        fair_market_value = dictionary.get("fairMarketValue") if dictionary.get("fairMarketValue") else APIHelper.SKIP
        opened_in_tax_year = dictionary.get("openedInTaxYear") if "openedInTaxYear" in dictionary.keys() else APIHelper.SKIP
        basis_of_disability_code = dictionary.get("basisOfDisabilityCode") if dictionary.get("basisOfDisabilityCode") else APIHelper.SKIP
        type_of_disability_code = dictionary.get("typeOfDisabilityCode") if dictionary.get("typeOfDisabilityCode") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   account_number,
                   able_contributions,
                   rollovers,
                   cumulative_contributions,
                   fair_market_value,
                   opened_in_tax_year,
                   basis_of_disability_code,
                   type_of_disability_code,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'able_contributions={(self.able_contributions if hasattr(self, "able_contributions") else None)!r}, '
                f'rollovers={(self.rollovers if hasattr(self, "rollovers") else None)!r}, '
                f'cumulative_contributions={(self.cumulative_contributions if hasattr(self, "cumulative_contributions") else None)!r}, '
                f'fair_market_value={(self.fair_market_value if hasattr(self, "fair_market_value") else None)!r}, '
                f'opened_in_tax_year={(self.opened_in_tax_year if hasattr(self, "opened_in_tax_year") else None)!r}, '
                f'basis_of_disability_code={(self.basis_of_disability_code if hasattr(self, "basis_of_disability_code") else None)!r}, '
                f'type_of_disability_code={(self.type_of_disability_code if hasattr(self, "type_of_disability_code") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'able_contributions={(self.able_contributions if hasattr(self, "able_contributions") else None)!s}, '
                f'rollovers={(self.rollovers if hasattr(self, "rollovers") else None)!s}, '
                f'cumulative_contributions={(self.cumulative_contributions if hasattr(self, "cumulative_contributions") else None)!s}, '
                f'fair_market_value={(self.fair_market_value if hasattr(self, "fair_market_value") else None)!s}, '
                f'opened_in_tax_year={(self.opened_in_tax_year if hasattr(self, "opened_in_tax_year") else None)!s}, '
                f'basis_of_disability_code={(self.basis_of_disability_code if hasattr(self, "basis_of_disability_code") else None)!s}, '
                f'type_of_disability_code={(self.type_of_disability_code if hasattr(self, "type_of_disability_code") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
