# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.form_w_21 import FormW21
from fdxapi.models.form_w_22 import FormW22
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.individual_name import IndividualName
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class FormW2C(object):

    """Implementation of the 'Form W-2c' model.

    IRS form W-2c, Corrected Wage and Tax Statement, from Employer (boxes a-b
    as issuer) to Employee (boxes d, h-i as recipient)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        corrected_tin_or_name (bool): Box e, Corrected SSN and/or name
        previous_employee_tin (str): Box f, Employee's previously reported SSN
        previous_employee_name (IndividualName): Box g, Employee's previously
            reported name
        original_w_2 (FormW21): Boxes 1-20 of Previously reported Wage and Tax
            Statement
        corrected_w_2 (FormW22): Boxes 1-20 of Correct information Wage and
            Tax Statement
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "corrected_tin_or_name": 'correctedTinOrName',
        "previous_employee_tin": 'previousEmployeeTin',
        "previous_employee_name": 'previousEmployeeName',
        "original_w_2": 'originalW2',
        "corrected_w_2": 'correctedW2'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'corrected_tin_or_name',
        'previous_employee_tin',
        'previous_employee_name',
        'original_w_2',
        'corrected_w_2',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 corrected_tin_or_name=APIHelper.SKIP,
                 previous_employee_tin=APIHelper.SKIP,
                 previous_employee_name=APIHelper.SKIP,
                 original_w_2=APIHelper.SKIP,
                 corrected_w_2=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the FormW2C class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if corrected_tin_or_name is not APIHelper.SKIP:
            self.corrected_tin_or_name = corrected_tin_or_name 
        if previous_employee_tin is not APIHelper.SKIP:
            self.previous_employee_tin = previous_employee_tin 
        if previous_employee_name is not APIHelper.SKIP:
            self.previous_employee_name = previous_employee_name 
        if original_w_2 is not APIHelper.SKIP:
            self.original_w_2 = original_w_2 
        if corrected_w_2 is not APIHelper.SKIP:
            self.corrected_w_2 = corrected_w_2 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        corrected_tin_or_name = dictionary.get("correctedTinOrName") if "correctedTinOrName" in dictionary.keys() else APIHelper.SKIP
        previous_employee_tin = dictionary.get("previousEmployeeTin") if dictionary.get("previousEmployeeTin") else APIHelper.SKIP
        previous_employee_name = IndividualName.from_dictionary(dictionary.get('previousEmployeeName')) if 'previousEmployeeName' in dictionary.keys() else APIHelper.SKIP
        original_w_2 = FormW21.from_dictionary(dictionary.get('originalW2')) if 'originalW2' in dictionary.keys() else APIHelper.SKIP
        corrected_w_2 = FormW22.from_dictionary(dictionary.get('correctedW2')) if 'correctedW2' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   corrected_tin_or_name,
                   previous_employee_tin,
                   previous_employee_name,
                   original_w_2,
                   corrected_w_2,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'corrected_tin_or_name={(self.corrected_tin_or_name if hasattr(self, "corrected_tin_or_name") else None)!r}, '
                f'previous_employee_tin={(self.previous_employee_tin if hasattr(self, "previous_employee_tin") else None)!r}, '
                f'previous_employee_name={(self.previous_employee_name if hasattr(self, "previous_employee_name") else None)!r}, '
                f'original_w_2={(self.original_w_2 if hasattr(self, "original_w_2") else None)!r}, '
                f'corrected_w_2={(self.corrected_w_2 if hasattr(self, "corrected_w_2") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'corrected_tin_or_name={(self.corrected_tin_or_name if hasattr(self, "corrected_tin_or_name") else None)!s}, '
                f'previous_employee_tin={(self.previous_employee_tin if hasattr(self, "previous_employee_tin") else None)!s}, '
                f'previous_employee_name={(self.previous_employee_name if hasattr(self, "previous_employee_name") else None)!s}, '
                f'original_w_2={(self.original_w_2 if hasattr(self, "original_w_2") else None)!s}, '
                f'corrected_w_2={(self.corrected_w_2 if hasattr(self, "corrected_w_2") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
