# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.state_and_local_tax_withholding import StateAndLocalTaxWithholding
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class FormW2G(object):

    """Implementation of the 'Form W-2G' model.

    Certain Gambling Winnings, from PAYER (1st-3rd boxes as issuer) to WINNER
    (boxes 4th-6th and 9 as recipient)

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        winnings (float): Box 1, Reportable winnings
        date_won (date): Box 2, Date won
        type_of_wager (str): Box 3, Type of wager
        federal_tax_withheld (float): Box 4, Federal income tax withheld
        transaction (str): Box 5, Transaction
        race (str): Box 6, Race
        identical_winnings (float): Box 7, Winnings from identical wagers
        cashier (str): Box 8, Cashier
        window (str): Box 10, Window
        first_id (str): Box 11, First I.D.
        second_id (str): Box 12, Second I.D.
        state_and_local (List[StateAndLocalTaxWithholding]): Boxes 13-18,
            State and Local tax withholding, use income fields for state (box
            14) and local (box 16) winnings amounts
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "winnings": 'winnings',
        "date_won": 'dateWon',
        "type_of_wager": 'typeOfWager',
        "federal_tax_withheld": 'federalTaxWithheld',
        "transaction": 'transaction',
        "race": 'race',
        "identical_winnings": 'identicalWinnings',
        "cashier": 'cashier',
        "window": 'window',
        "first_id": 'firstId',
        "second_id": 'secondId',
        "state_and_local": 'stateAndLocal'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'winnings',
        'date_won',
        'type_of_wager',
        'federal_tax_withheld',
        'transaction',
        'race',
        'identical_winnings',
        'cashier',
        'window',
        'first_id',
        'second_id',
        'state_and_local',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 winnings=APIHelper.SKIP,
                 date_won=APIHelper.SKIP,
                 type_of_wager=APIHelper.SKIP,
                 federal_tax_withheld=APIHelper.SKIP,
                 transaction=APIHelper.SKIP,
                 race=APIHelper.SKIP,
                 identical_winnings=APIHelper.SKIP,
                 cashier=APIHelper.SKIP,
                 window=APIHelper.SKIP,
                 first_id=APIHelper.SKIP,
                 second_id=APIHelper.SKIP,
                 state_and_local=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the FormW2G class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if winnings is not APIHelper.SKIP:
            self.winnings = winnings 
        if date_won is not APIHelper.SKIP:
            self.date_won = date_won 
        if type_of_wager is not APIHelper.SKIP:
            self.type_of_wager = type_of_wager 
        if federal_tax_withheld is not APIHelper.SKIP:
            self.federal_tax_withheld = federal_tax_withheld 
        if transaction is not APIHelper.SKIP:
            self.transaction = transaction 
        if race is not APIHelper.SKIP:
            self.race = race 
        if identical_winnings is not APIHelper.SKIP:
            self.identical_winnings = identical_winnings 
        if cashier is not APIHelper.SKIP:
            self.cashier = cashier 
        if window is not APIHelper.SKIP:
            self.window = window 
        if first_id is not APIHelper.SKIP:
            self.first_id = first_id 
        if second_id is not APIHelper.SKIP:
            self.second_id = second_id 
        if state_and_local is not APIHelper.SKIP:
            self.state_and_local = state_and_local 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        winnings = dictionary.get("winnings") if dictionary.get("winnings") else APIHelper.SKIP
        date_won = dateutil.parser.parse(dictionary.get('dateWon')).date() if dictionary.get('dateWon') else APIHelper.SKIP
        type_of_wager = dictionary.get("typeOfWager") if dictionary.get("typeOfWager") else APIHelper.SKIP
        federal_tax_withheld = dictionary.get("federalTaxWithheld") if dictionary.get("federalTaxWithheld") else APIHelper.SKIP
        transaction = dictionary.get("transaction") if dictionary.get("transaction") else APIHelper.SKIP
        race = dictionary.get("race") if dictionary.get("race") else APIHelper.SKIP
        identical_winnings = dictionary.get("identicalWinnings") if dictionary.get("identicalWinnings") else APIHelper.SKIP
        cashier = dictionary.get("cashier") if dictionary.get("cashier") else APIHelper.SKIP
        window = dictionary.get("window") if dictionary.get("window") else APIHelper.SKIP
        first_id = dictionary.get("firstId") if dictionary.get("firstId") else APIHelper.SKIP
        second_id = dictionary.get("secondId") if dictionary.get("secondId") else APIHelper.SKIP
        state_and_local = None
        if dictionary.get('stateAndLocal') is not None:
            state_and_local = [StateAndLocalTaxWithholding.from_dictionary(x) for x in dictionary.get('stateAndLocal')]
        else:
            state_and_local = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   winnings,
                   date_won,
                   type_of_wager,
                   federal_tax_withheld,
                   transaction,
                   race,
                   identical_winnings,
                   cashier,
                   window,
                   first_id,
                   second_id,
                   state_and_local,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'winnings={(self.winnings if hasattr(self, "winnings") else None)!r}, '
                f'date_won={(self.date_won if hasattr(self, "date_won") else None)!r}, '
                f'type_of_wager={(self.type_of_wager if hasattr(self, "type_of_wager") else None)!r}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!r}, '
                f'transaction={(self.transaction if hasattr(self, "transaction") else None)!r}, '
                f'race={(self.race if hasattr(self, "race") else None)!r}, '
                f'identical_winnings={(self.identical_winnings if hasattr(self, "identical_winnings") else None)!r}, '
                f'cashier={(self.cashier if hasattr(self, "cashier") else None)!r}, '
                f'window={(self.window if hasattr(self, "window") else None)!r}, '
                f'first_id={(self.first_id if hasattr(self, "first_id") else None)!r}, '
                f'second_id={(self.second_id if hasattr(self, "second_id") else None)!r}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'winnings={(self.winnings if hasattr(self, "winnings") else None)!s}, '
                f'date_won={(self.date_won if hasattr(self, "date_won") else None)!s}, '
                f'type_of_wager={(self.type_of_wager if hasattr(self, "type_of_wager") else None)!s}, '
                f'federal_tax_withheld={(self.federal_tax_withheld if hasattr(self, "federal_tax_withheld") else None)!s}, '
                f'transaction={(self.transaction if hasattr(self, "transaction") else None)!s}, '
                f'race={(self.race if hasattr(self, "race") else None)!s}, '
                f'identical_winnings={(self.identical_winnings if hasattr(self, "identical_winnings") else None)!s}, '
                f'cashier={(self.cashier if hasattr(self, "cashier") else None)!s}, '
                f'window={(self.window if hasattr(self, "window") else None)!s}, '
                f'first_id={(self.first_id if hasattr(self, "first_id") else None)!s}, '
                f'second_id={(self.second_id if hasattr(self, "second_id") else None)!s}, '
                f'state_and_local={(self.state_and_local if hasattr(self, "state_and_local") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
