# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class GenericAccountIdentificationEntity(object):

    """Implementation of the 'Generic Account Identification entity' model.

    Generic account identifier entity

    Attributes:
        account_id (str): Account identifier
        issuer_name (str): Name of the issuer
        id_scheme (ExternalAccountIdSchemeEntity |
            ProprietaryAccountIdSchemeEntity | None): Identification scheme
            associated with the generic account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_id": 'accountId',
        "issuer_name": 'issuerName',
        "id_scheme": 'idScheme'
    }

    _optionals = [
        'account_id',
        'issuer_name',
        'id_scheme',
    ]

    def __init__(self,
                 account_id=APIHelper.SKIP,
                 issuer_name=APIHelper.SKIP,
                 id_scheme=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the GenericAccountIdentificationEntity class"""

        # Initialize members of the class
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if issuer_name is not APIHelper.SKIP:
            self.issuer_name = issuer_name 
        if id_scheme is not APIHelper.SKIP:
            self.id_scheme = id_scheme 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        issuer_name = dictionary.get("issuerName") if dictionary.get("issuerName") else APIHelper.SKIP
        id_scheme = APIHelper.deserialize_union_type(UnionTypeLookUp.get('GenericAccountIdentificationEntityIdScheme'), dictionary.get('idScheme'), False) if dictionary.get('idScheme') is not None else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(account_id,
                   issuer_name,
                   id_scheme,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'issuer_name={(self.issuer_name if hasattr(self, "issuer_name") else None)!r}, '
                f'id_scheme={(self.id_scheme if hasattr(self, "id_scheme") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'issuer_name={(self.issuer_name if hasattr(self, "issuer_name") else None)!s}, '
                f'id_scheme={(self.id_scheme if hasattr(self, "id_scheme") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
