# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class GenericFinancialInstitutionIdEntity(object):

    """Implementation of the 'Generic Financial Institution Id entity' model.

    Generic financial institution identifier entity

    Attributes:
        fi_id (str): Financial institution identifier
        issuer_name (str): Issuer name
        id_scheme (ExternalFinancialInstitutionIdSchemeEntity |
            ProprietaryFinancialInstitutionIdSchemeEntity | None):
            Identification scheme associated with the generic financial
            institution
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "fi_id": 'fiId',
        "issuer_name": 'issuerName',
        "id_scheme": 'idScheme'
    }

    _optionals = [
        'fi_id',
        'issuer_name',
        'id_scheme',
    ]

    def __init__(self,
                 fi_id=APIHelper.SKIP,
                 issuer_name=APIHelper.SKIP,
                 id_scheme=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the GenericFinancialInstitutionIdEntity class"""

        # Initialize members of the class
        if fi_id is not APIHelper.SKIP:
            self.fi_id = fi_id 
        if issuer_name is not APIHelper.SKIP:
            self.issuer_name = issuer_name 
        if id_scheme is not APIHelper.SKIP:
            self.id_scheme = id_scheme 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        fi_id = dictionary.get("fiId") if dictionary.get("fiId") else APIHelper.SKIP
        issuer_name = dictionary.get("issuerName") if dictionary.get("issuerName") else APIHelper.SKIP
        id_scheme = APIHelper.deserialize_union_type(UnionTypeLookUp.get('GenericFinancialInstitutionIdEntityIdScheme'), dictionary.get('idScheme'), False) if dictionary.get('idScheme') is not None else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(fi_id,
                   issuer_name,
                   id_scheme,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'fi_id={(self.fi_id if hasattr(self, "fi_id") else None)!r}, '
                f'issuer_name={(self.issuer_name if hasattr(self, "issuer_name") else None)!r}, '
                f'id_scheme={(self.id_scheme if hasattr(self, "id_scheme") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'fi_id={(self.fi_id if hasattr(self, "fi_id") else None)!s}, '
                f'issuer_name={(self.issuer_name if hasattr(self, "issuer_name") else None)!s}, '
                f'id_scheme={(self.id_scheme if hasattr(self, "id_scheme") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
