# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.currency_entity_1 import CurrencyEntity1
from fdxapi.models.fi_attribute_entity import FiAttributeEntity
from fdxapi.models.fi_portion_entity import FiPortionEntity
from fdxapi.models.portion_entity import PortionEntity
from fdxapi.models.security_id_entity import SecurityIdEntity
from fdxapi.models.tax_lot_entity import TaxLotEntity


class HoldingEntity(object):

    """Implementation of the 'Holding entity' model.

    A holding in an investment account

    Attributes:
        holding_id (str): Long term persistent identity of the holding
        security_ids (List[SecurityIdEntity]): Unique identifiers for the
            security
        holding_name (str): Holding name or security name
        holding_type (HoldingType2): ANNUITY, BOND, CD, DIGITALASSET,
            MUTUALFUND, OPTION, OTHER, STOCK
        holding_sub_type (HoldingSubType2): MONEYMARKET, CASH
        position_type (PositionType1): LONG, SHORT
        held_in_account (HeldInAccount2): Sub-account CASH, MARGIN, SHORT,
            OTHER
        description (str): The description of the holding
        symbol (str): Ticker / Market symbol
        original_purchase_date (date): Date of original purchase
        purchased_price (float): Price of holding at the time of purchase
        current_amortization_factor (float): Ranges from 0.0 - 1.0 indicates
            the adjustment to the calculation of the market value.
            'currentUnitPrice * quantity * currentAmortizationFactor = 
            marketValue'
        current_unit_price (float): Current unit price
        change_in_price (float): Change in current price compared to previous
            day's close
        current_unit_price_date (date): Current unit price as of date
        units (float): Required for stock, mutual funds. Number of shares
            (with decimals)
        market_value (float): Market value at the time of data retrieved
        face_value (float): Required for bonds. Face value at the time of data
            retrieved
        average_cost (bool): Cost is average of all purchases for holding
        cash_account (bool): If true, indicates that this holding is used to
            maintain proceeds from sales, dividends, and other cash postings
            to the investment account
        rate (float): For CDs, bonds, and other rate based holdings
        expiration_date (date): For CDs, bonds, and other time-based holdings
        inv_401_k_source (Investment401KSourceType4): Source for money for
            this security. One of PRETAX, AFTERTAX, MATCH, PROFITSHARING,
            ROLLOVER, OTHERVEST, OTHERNONVEST
        currency (CurrencyEntity1): Currency information if it is different
            from Account entity
        asset_classes (List[PortionEntity]): Percent breakdown by asset class
        fi_asset_classes (List[FiPortionEntity]): Percent breakdown by
            FI-specific asset class percentage breakdown
        fi_attributes (List[FiAttributeEntity]): Array of FI-specific
            attributes
        tax_lots (List[TaxLotEntity]): Breakdown by tax lot
        digital_units (str): Specify units to full precision with unlimited
            digits after decimal point
        security (DebtSecurityEntity | MutualFundSecurityEntity |
            OptionSecurityEntity | OtherSecurityEntity | StockSecurityEntity |
            SweepSecurityEntity | None): The security of the Holding; one of
            DebtSecurity, MutualFundSecurity OptionSecurity, OtherSecurity,
            StockSecurity or SweepSecurity
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "holding_id": 'holdingId',
        "security_ids": 'securityIds',
        "holding_name": 'holdingName',
        "holding_type": 'holdingType',
        "holding_sub_type": 'holdingSubType',
        "position_type": 'positionType',
        "held_in_account": 'heldInAccount',
        "description": 'description',
        "symbol": 'symbol',
        "original_purchase_date": 'originalPurchaseDate',
        "purchased_price": 'purchasedPrice',
        "current_amortization_factor": 'currentAmortizationFactor',
        "current_unit_price": 'currentUnitPrice',
        "change_in_price": 'changeInPrice',
        "current_unit_price_date": 'currentUnitPriceDate',
        "units": 'units',
        "market_value": 'marketValue',
        "face_value": 'faceValue',
        "average_cost": 'averageCost',
        "cash_account": 'cashAccount',
        "rate": 'rate',
        "expiration_date": 'expirationDate',
        "inv_401_k_source": 'inv401kSource',
        "currency": 'currency',
        "asset_classes": 'assetClasses',
        "fi_asset_classes": 'fiAssetClasses',
        "fi_attributes": 'fiAttributes',
        "tax_lots": 'taxLots',
        "digital_units": 'digitalUnits',
        "security": 'security'
    }

    _optionals = [
        'holding_id',
        'security_ids',
        'holding_name',
        'holding_type',
        'holding_sub_type',
        'position_type',
        'held_in_account',
        'description',
        'symbol',
        'original_purchase_date',
        'purchased_price',
        'current_amortization_factor',
        'current_unit_price',
        'change_in_price',
        'current_unit_price_date',
        'units',
        'market_value',
        'face_value',
        'average_cost',
        'cash_account',
        'rate',
        'expiration_date',
        'inv_401_k_source',
        'currency',
        'asset_classes',
        'fi_asset_classes',
        'fi_attributes',
        'tax_lots',
        'digital_units',
        'security',
    ]

    def __init__(self,
                 holding_id=APIHelper.SKIP,
                 security_ids=APIHelper.SKIP,
                 holding_name=APIHelper.SKIP,
                 holding_type=APIHelper.SKIP,
                 holding_sub_type=APIHelper.SKIP,
                 position_type=APIHelper.SKIP,
                 held_in_account=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 symbol=APIHelper.SKIP,
                 original_purchase_date=APIHelper.SKIP,
                 purchased_price=APIHelper.SKIP,
                 current_amortization_factor=1,
                 current_unit_price=APIHelper.SKIP,
                 change_in_price=APIHelper.SKIP,
                 current_unit_price_date=APIHelper.SKIP,
                 units=APIHelper.SKIP,
                 market_value=APIHelper.SKIP,
                 face_value=APIHelper.SKIP,
                 average_cost=APIHelper.SKIP,
                 cash_account=APIHelper.SKIP,
                 rate=APIHelper.SKIP,
                 expiration_date=APIHelper.SKIP,
                 inv_401_k_source=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 asset_classes=APIHelper.SKIP,
                 fi_asset_classes=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 tax_lots=APIHelper.SKIP,
                 digital_units=APIHelper.SKIP,
                 security=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the HoldingEntity class"""

        # Initialize members of the class
        if holding_id is not APIHelper.SKIP:
            self.holding_id = holding_id 
        if security_ids is not APIHelper.SKIP:
            self.security_ids = security_ids 
        if holding_name is not APIHelper.SKIP:
            self.holding_name = holding_name 
        if holding_type is not APIHelper.SKIP:
            self.holding_type = holding_type 
        if holding_sub_type is not APIHelper.SKIP:
            self.holding_sub_type = holding_sub_type 
        if position_type is not APIHelper.SKIP:
            self.position_type = position_type 
        if held_in_account is not APIHelper.SKIP:
            self.held_in_account = held_in_account 
        if description is not APIHelper.SKIP:
            self.description = description 
        if symbol is not APIHelper.SKIP:
            self.symbol = symbol 
        if original_purchase_date is not APIHelper.SKIP:
            self.original_purchase_date = original_purchase_date 
        if purchased_price is not APIHelper.SKIP:
            self.purchased_price = purchased_price 
        self.current_amortization_factor = current_amortization_factor 
        if current_unit_price is not APIHelper.SKIP:
            self.current_unit_price = current_unit_price 
        if change_in_price is not APIHelper.SKIP:
            self.change_in_price = change_in_price 
        if current_unit_price_date is not APIHelper.SKIP:
            self.current_unit_price_date = current_unit_price_date 
        if units is not APIHelper.SKIP:
            self.units = units 
        if market_value is not APIHelper.SKIP:
            self.market_value = market_value 
        if face_value is not APIHelper.SKIP:
            self.face_value = face_value 
        if average_cost is not APIHelper.SKIP:
            self.average_cost = average_cost 
        if cash_account is not APIHelper.SKIP:
            self.cash_account = cash_account 
        if rate is not APIHelper.SKIP:
            self.rate = rate 
        if expiration_date is not APIHelper.SKIP:
            self.expiration_date = expiration_date 
        if inv_401_k_source is not APIHelper.SKIP:
            self.inv_401_k_source = inv_401_k_source 
        if currency is not APIHelper.SKIP:
            self.currency = currency 
        if asset_classes is not APIHelper.SKIP:
            self.asset_classes = asset_classes 
        if fi_asset_classes is not APIHelper.SKIP:
            self.fi_asset_classes = fi_asset_classes 
        if fi_attributes is not APIHelper.SKIP:
            self.fi_attributes = fi_attributes 
        if tax_lots is not APIHelper.SKIP:
            self.tax_lots = tax_lots 
        if digital_units is not APIHelper.SKIP:
            self.digital_units = digital_units 
        if security is not APIHelper.SKIP:
            self.security = security 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        holding_id = dictionary.get("holdingId") if dictionary.get("holdingId") else APIHelper.SKIP
        security_ids = None
        if dictionary.get('securityIds') is not None:
            security_ids = [SecurityIdEntity.from_dictionary(x) for x in dictionary.get('securityIds')]
        else:
            security_ids = APIHelper.SKIP
        holding_name = dictionary.get("holdingName") if dictionary.get("holdingName") else APIHelper.SKIP
        holding_type = dictionary.get("holdingType") if dictionary.get("holdingType") else APIHelper.SKIP
        holding_sub_type = dictionary.get("holdingSubType") if dictionary.get("holdingSubType") else APIHelper.SKIP
        position_type = dictionary.get("positionType") if dictionary.get("positionType") else APIHelper.SKIP
        held_in_account = dictionary.get("heldInAccount") if dictionary.get("heldInAccount") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        symbol = dictionary.get("symbol") if dictionary.get("symbol") else APIHelper.SKIP
        original_purchase_date = dateutil.parser.parse(dictionary.get('originalPurchaseDate')).date() if dictionary.get('originalPurchaseDate') else APIHelper.SKIP
        purchased_price = dictionary.get("purchasedPrice") if dictionary.get("purchasedPrice") else APIHelper.SKIP
        current_amortization_factor = dictionary.get("currentAmortizationFactor") if dictionary.get("currentAmortizationFactor") else 1
        current_unit_price = dictionary.get("currentUnitPrice") if dictionary.get("currentUnitPrice") else APIHelper.SKIP
        change_in_price = dictionary.get("changeInPrice") if dictionary.get("changeInPrice") else APIHelper.SKIP
        current_unit_price_date = dateutil.parser.parse(dictionary.get('currentUnitPriceDate')).date() if dictionary.get('currentUnitPriceDate') else APIHelper.SKIP
        units = dictionary.get("units") if dictionary.get("units") else APIHelper.SKIP
        market_value = dictionary.get("marketValue") if dictionary.get("marketValue") else APIHelper.SKIP
        face_value = dictionary.get("faceValue") if dictionary.get("faceValue") else APIHelper.SKIP
        average_cost = dictionary.get("averageCost") if "averageCost" in dictionary.keys() else APIHelper.SKIP
        cash_account = dictionary.get("cashAccount") if "cashAccount" in dictionary.keys() else APIHelper.SKIP
        rate = dictionary.get("rate") if dictionary.get("rate") else APIHelper.SKIP
        expiration_date = dateutil.parser.parse(dictionary.get('expirationDate')).date() if dictionary.get('expirationDate') else APIHelper.SKIP
        inv_401_k_source = dictionary.get("inv401kSource") if dictionary.get("inv401kSource") else APIHelper.SKIP
        currency = CurrencyEntity1.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        asset_classes = None
        if dictionary.get('assetClasses') is not None:
            asset_classes = [PortionEntity.from_dictionary(x) for x in dictionary.get('assetClasses')]
        else:
            asset_classes = APIHelper.SKIP
        fi_asset_classes = None
        if dictionary.get('fiAssetClasses') is not None:
            fi_asset_classes = [FiPortionEntity.from_dictionary(x) for x in dictionary.get('fiAssetClasses')]
        else:
            fi_asset_classes = APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        tax_lots = None
        if dictionary.get('taxLots') is not None:
            tax_lots = [TaxLotEntity.from_dictionary(x) for x in dictionary.get('taxLots')]
        else:
            tax_lots = APIHelper.SKIP
        digital_units = dictionary.get("digitalUnits") if dictionary.get("digitalUnits") else APIHelper.SKIP
        security = APIHelper.deserialize_union_type(UnionTypeLookUp.get('HoldingEntitySecurity'), dictionary.get('security'), False) if dictionary.get('security') is not None else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(holding_id,
                   security_ids,
                   holding_name,
                   holding_type,
                   holding_sub_type,
                   position_type,
                   held_in_account,
                   description,
                   symbol,
                   original_purchase_date,
                   purchased_price,
                   current_amortization_factor,
                   current_unit_price,
                   change_in_price,
                   current_unit_price_date,
                   units,
                   market_value,
                   face_value,
                   average_cost,
                   cash_account,
                   rate,
                   expiration_date,
                   inv_401_k_source,
                   currency,
                   asset_classes,
                   fi_asset_classes,
                   fi_attributes,
                   tax_lots,
                   digital_units,
                   security,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'holding_id={(self.holding_id if hasattr(self, "holding_id") else None)!r}, '
                f'security_ids={(self.security_ids if hasattr(self, "security_ids") else None)!r}, '
                f'holding_name={(self.holding_name if hasattr(self, "holding_name") else None)!r}, '
                f'holding_type={(self.holding_type if hasattr(self, "holding_type") else None)!r}, '
                f'holding_sub_type={(self.holding_sub_type if hasattr(self, "holding_sub_type") else None)!r}, '
                f'position_type={(self.position_type if hasattr(self, "position_type") else None)!r}, '
                f'held_in_account={(self.held_in_account if hasattr(self, "held_in_account") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!r}, '
                f'original_purchase_date={(self.original_purchase_date if hasattr(self, "original_purchase_date") else None)!r}, '
                f'purchased_price={(self.purchased_price if hasattr(self, "purchased_price") else None)!r}, '
                f'current_amortization_factor={(self.current_amortization_factor if hasattr(self, "current_amortization_factor") else None)!r}, '
                f'current_unit_price={(self.current_unit_price if hasattr(self, "current_unit_price") else None)!r}, '
                f'change_in_price={(self.change_in_price if hasattr(self, "change_in_price") else None)!r}, '
                f'current_unit_price_date={(self.current_unit_price_date if hasattr(self, "current_unit_price_date") else None)!r}, '
                f'units={(self.units if hasattr(self, "units") else None)!r}, '
                f'market_value={(self.market_value if hasattr(self, "market_value") else None)!r}, '
                f'face_value={(self.face_value if hasattr(self, "face_value") else None)!r}, '
                f'average_cost={(self.average_cost if hasattr(self, "average_cost") else None)!r}, '
                f'cash_account={(self.cash_account if hasattr(self, "cash_account") else None)!r}, '
                f'rate={(self.rate if hasattr(self, "rate") else None)!r}, '
                f'expiration_date={(self.expiration_date if hasattr(self, "expiration_date") else None)!r}, '
                f'inv_401_k_source={(self.inv_401_k_source if hasattr(self, "inv_401_k_source") else None)!r}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!r}, '
                f'asset_classes={(self.asset_classes if hasattr(self, "asset_classes") else None)!r}, '
                f'fi_asset_classes={(self.fi_asset_classes if hasattr(self, "fi_asset_classes") else None)!r}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!r}, '
                f'tax_lots={(self.tax_lots if hasattr(self, "tax_lots") else None)!r}, '
                f'digital_units={(self.digital_units if hasattr(self, "digital_units") else None)!r}, '
                f'security={(self.security if hasattr(self, "security") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'holding_id={(self.holding_id if hasattr(self, "holding_id") else None)!s}, '
                f'security_ids={(self.security_ids if hasattr(self, "security_ids") else None)!s}, '
                f'holding_name={(self.holding_name if hasattr(self, "holding_name") else None)!s}, '
                f'holding_type={(self.holding_type if hasattr(self, "holding_type") else None)!s}, '
                f'holding_sub_type={(self.holding_sub_type if hasattr(self, "holding_sub_type") else None)!s}, '
                f'position_type={(self.position_type if hasattr(self, "position_type") else None)!s}, '
                f'held_in_account={(self.held_in_account if hasattr(self, "held_in_account") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'symbol={(self.symbol if hasattr(self, "symbol") else None)!s}, '
                f'original_purchase_date={(self.original_purchase_date if hasattr(self, "original_purchase_date") else None)!s}, '
                f'purchased_price={(self.purchased_price if hasattr(self, "purchased_price") else None)!s}, '
                f'current_amortization_factor={(self.current_amortization_factor if hasattr(self, "current_amortization_factor") else None)!s}, '
                f'current_unit_price={(self.current_unit_price if hasattr(self, "current_unit_price") else None)!s}, '
                f'change_in_price={(self.change_in_price if hasattr(self, "change_in_price") else None)!s}, '
                f'current_unit_price_date={(self.current_unit_price_date if hasattr(self, "current_unit_price_date") else None)!s}, '
                f'units={(self.units if hasattr(self, "units") else None)!s}, '
                f'market_value={(self.market_value if hasattr(self, "market_value") else None)!s}, '
                f'face_value={(self.face_value if hasattr(self, "face_value") else None)!s}, '
                f'average_cost={(self.average_cost if hasattr(self, "average_cost") else None)!s}, '
                f'cash_account={(self.cash_account if hasattr(self, "cash_account") else None)!s}, '
                f'rate={(self.rate if hasattr(self, "rate") else None)!s}, '
                f'expiration_date={(self.expiration_date if hasattr(self, "expiration_date") else None)!s}, '
                f'inv_401_k_source={(self.inv_401_k_source if hasattr(self, "inv_401_k_source") else None)!s}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!s}, '
                f'asset_classes={(self.asset_classes if hasattr(self, "asset_classes") else None)!s}, '
                f'fi_asset_classes={(self.fi_asset_classes if hasattr(self, "fi_asset_classes") else None)!s}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!s}, '
                f'tax_lots={(self.tax_lots if hasattr(self, "tax_lots") else None)!s}, '
                f'digital_units={(self.digital_units if hasattr(self, "digital_units") else None)!s}, '
                f'security={(self.security if hasattr(self, "security") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
