# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class Iban2007IdentifierEntity(object):

    """Implementation of the 'IBAN 2007 Identifier entity' model.

    IBAN 2007 account identifier

    Attributes:
        iban_2007_id (str): Value of the account identifier
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "iban_2007_id": 'iban2007Id'
    }

    _optionals = [
        'iban_2007_id',
    ]

    def __init__(self,
                 iban_2007_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Iban2007IdentifierEntity class"""

        # Initialize members of the class
        if iban_2007_id is not APIHelper.SKIP:
            self.iban_2007_id = iban_2007_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        iban_2007_id = dictionary.get("iban2007Id") if dictionary.get("iban2007Id") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(iban_2007_id,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'iban_2007_id={(self.iban_2007_id if hasattr(self, "iban_2007_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'iban_2007_id={(self.iban_2007_id if hasattr(self, "iban_2007_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
