# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.registry_reference import RegistryReference


class Intermediary(object):

    """Implementation of the 'Intermediary' model.

    Data Access Platform, Service Provider, or any other entity in the data
    sharing chain between a Data Provider to a Data Recipient. Properties in
    this structure use 'snake_case' names to match the properties in [IETF RFC
    7591](https://datatracker.ietf.org/doc/rfc7591/)

    Attributes:
        name (str): Name of intermediary party
        description (str): A short description of the intermediary
        uri (str): A URL string of a web page providing information about the
            intermediary
        logo_uri (str): A URL string that references a logo for this
            intermediary
        contacts (List[str]): Array of strings representing ways to contact
            people responsible for this intermediary
        registry_references (List[RegistryReference]): Registry references for
            this intermediary
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "description": 'description',
        "uri": 'uri',
        "logo_uri": 'logo_uri',
        "contacts": 'contacts',
        "registry_references": 'registry_references'
    }

    _optionals = [
        'name',
        'description',
        'uri',
        'logo_uri',
        'contacts',
        'registry_references',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 uri=APIHelper.SKIP,
                 logo_uri=APIHelper.SKIP,
                 contacts=APIHelper.SKIP,
                 registry_references=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the Intermediary class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if description is not APIHelper.SKIP:
            self.description = description 
        if uri is not APIHelper.SKIP:
            self.uri = uri 
        if logo_uri is not APIHelper.SKIP:
            self.logo_uri = logo_uri 
        if contacts is not APIHelper.SKIP:
            self.contacts = contacts 
        if registry_references is not APIHelper.SKIP:
            self.registry_references = registry_references 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        uri = dictionary.get("uri") if dictionary.get("uri") else APIHelper.SKIP
        logo_uri = dictionary.get("logo_uri") if dictionary.get("logo_uri") else APIHelper.SKIP
        contacts = dictionary.get("contacts") if dictionary.get("contacts") else APIHelper.SKIP
        registry_references = None
        if dictionary.get('registry_references') is not None:
            registry_references = [RegistryReference.from_dictionary(x) for x in dictionary.get('registry_references')]
        else:
            registry_references = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   description,
                   uri,
                   logo_uri,
                   contacts,
                   registry_references,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'uri={(self.uri if hasattr(self, "uri") else None)!r}, '
                f'logo_uri={(self.logo_uri if hasattr(self, "logo_uri") else None)!r}, '
                f'contacts={(self.contacts if hasattr(self, "contacts") else None)!r}, '
                f'registry_references={(self.registry_references if hasattr(self, "registry_references") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'uri={(self.uri if hasattr(self, "uri") else None)!s}, '
                f'logo_uri={(self.logo_uri if hasattr(self, "logo_uri") else None)!s}, '
                f'contacts={(self.contacts if hasattr(self, "contacts") else None)!s}, '
                f'registry_references={(self.registry_references if hasattr(self, "registry_references") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
