# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.currency_entity_2 import CurrencyEntity2


class InvestmentBalanceEntity(object):

    """Implementation of the 'Investment Balance entity' model.

    A point-in-time balance of the investment account

    Attributes:
        balance_name (str): Name of the balance
        balance_description (str): Description of balance
        balance_type (InvestmentBalanceType2): AMOUNT, PERCENTAGE
        balance_value (float): Value of named balance
        balance_date (date): Date as of this balance
        currency (CurrencyEntity2): Currency if different from that of account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "balance_name": 'balanceName',
        "balance_description": 'balanceDescription',
        "balance_type": 'balanceType',
        "balance_value": 'balanceValue',
        "balance_date": 'balanceDate',
        "currency": 'currency'
    }

    _optionals = [
        'balance_name',
        'balance_description',
        'balance_type',
        'balance_value',
        'balance_date',
        'currency',
    ]

    def __init__(self,
                 balance_name=APIHelper.SKIP,
                 balance_description=APIHelper.SKIP,
                 balance_type=APIHelper.SKIP,
                 balance_value=APIHelper.SKIP,
                 balance_date=APIHelper.SKIP,
                 currency=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the InvestmentBalanceEntity class"""

        # Initialize members of the class
        if balance_name is not APIHelper.SKIP:
            self.balance_name = balance_name 
        if balance_description is not APIHelper.SKIP:
            self.balance_description = balance_description 
        if balance_type is not APIHelper.SKIP:
            self.balance_type = balance_type 
        if balance_value is not APIHelper.SKIP:
            self.balance_value = balance_value 
        if balance_date is not APIHelper.SKIP:
            self.balance_date = balance_date 
        if currency is not APIHelper.SKIP:
            self.currency = currency 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        balance_name = dictionary.get("balanceName") if dictionary.get("balanceName") else APIHelper.SKIP
        balance_description = dictionary.get("balanceDescription") if dictionary.get("balanceDescription") else APIHelper.SKIP
        balance_type = dictionary.get("balanceType") if dictionary.get("balanceType") else APIHelper.SKIP
        balance_value = dictionary.get("balanceValue") if dictionary.get("balanceValue") else APIHelper.SKIP
        balance_date = dateutil.parser.parse(dictionary.get('balanceDate')).date() if dictionary.get('balanceDate') else APIHelper.SKIP
        currency = CurrencyEntity2.from_dictionary(dictionary.get('currency')) if 'currency' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(balance_name,
                   balance_description,
                   balance_type,
                   balance_value,
                   balance_date,
                   currency,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'balance_name={(self.balance_name if hasattr(self, "balance_name") else None)!r}, '
                f'balance_description={(self.balance_description if hasattr(self, "balance_description") else None)!r}, '
                f'balance_type={(self.balance_type if hasattr(self, "balance_type") else None)!r}, '
                f'balance_value={(self.balance_value if hasattr(self, "balance_value") else None)!r}, '
                f'balance_date={(self.balance_date if hasattr(self, "balance_date") else None)!r}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'balance_name={(self.balance_name if hasattr(self, "balance_name") else None)!s}, '
                f'balance_description={(self.balance_description if hasattr(self, "balance_description") else None)!s}, '
                f'balance_type={(self.balance_type if hasattr(self, "balance_type") else None)!s}, '
                f'balance_value={(self.balance_value if hasattr(self, "balance_value") else None)!s}, '
                f'balance_date={(self.balance_date if hasattr(self, "balance_date") else None)!s}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
