# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.party_entity import PartyEntity


class NotificationSubscriptionEntity(object):

    """Implementation of the 'Notification Subscription entity' model.

    Provides the fields of a notification subscription

    Attributes:
        mtype (NotificationType): Type of notification
        category (NotificationCategory1): Category of notification
        callback_url (str): Callback URL. Previous callback URL will be
            updated with latest.
        subscriber (PartyEntity): The Party who is subscribing to the
            notification
        effective_date (date): Effective date of notification
        subscription_id (str): Subscription id of notification
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "category": 'category',
        "callback_url": 'callbackUrl',
        "subscriber": 'subscriber',
        "effective_date": 'effectiveDate',
        "subscription_id": 'subscriptionId'
    }

    _optionals = [
        'effective_date',
        'subscription_id',
    ]

    def __init__(self,
                 mtype=None,
                 category=None,
                 callback_url=None,
                 subscriber=None,
                 effective_date=APIHelper.SKIP,
                 subscription_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the NotificationSubscriptionEntity class"""

        # Initialize members of the class
        self.mtype = mtype 
        self.category = category 
        self.callback_url = callback_url 
        self.subscriber = subscriber 
        if effective_date is not APIHelper.SKIP:
            self.effective_date = effective_date 
        if subscription_id is not APIHelper.SKIP:
            self.subscription_id = subscription_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get("type") if dictionary.get("type") else None
        category = dictionary.get("category") if dictionary.get("category") else None
        callback_url = dictionary.get("callbackUrl") if dictionary.get("callbackUrl") else None
        subscriber = PartyEntity.from_dictionary(dictionary.get('subscriber')) if dictionary.get('subscriber') else None
        effective_date = dateutil.parser.parse(dictionary.get('effectiveDate')).date() if dictionary.get('effectiveDate') else APIHelper.SKIP
        subscription_id = dictionary.get("subscriptionId") if dictionary.get("subscriptionId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(mtype,
                   category,
                   callback_url,
                   subscriber,
                   effective_date,
                   subscription_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={self.mtype!r}, '
                f'category={self.category!r}, '
                f'callback_url={self.callback_url!r}, '
                f'subscriber={self.subscriber!r}, '
                f'effective_date={(self.effective_date if hasattr(self, "effective_date") else None)!r}, '
                f'subscription_id={(self.subscription_id if hasattr(self, "subscription_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={self.mtype!s}, '
                f'category={self.category!s}, '
                f'callback_url={self.callback_url!s}, '
                f'subscriber={self.subscriber!s}, '
                f'effective_date={(self.effective_date if hasattr(self, "effective_date") else None)!s}, '
                f'subscription_id={(self.subscription_id if hasattr(self, "subscription_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
