# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.availability_entity_1 import AvailabilityEntity1
from fdxapi.models.hateoas_link import HateoasLink


class OperationEntity(object):

    """Implementation of the 'Operation entity' model.

    Definition of a supported API for the /capability response object

    Attributes:
        id (FdxResourceOperationId1): Operation ID (e.g. name) of this API
        availability (AvailabilityEntity1): Whether and how this API is
            currently supported
        also_supported (List[FdxResourceOperationId]): Additional FDX API
            endpoints supported at this API, e.g. Transactions within
            Accounts, or TxImages within Transactions
        version (str): Data provider's implementation version number for this
            operation, which is unrelated to the FDX API version
        fdx_versions (List[FdxVersion]): FDX schema versions supported at this
            endpoint
        cut_off_time (datetime): Cut off time for same-day execution of
            activity request submitted to this API. Alternatively, the as-of
            time when EOD account balances are typically set
        link (HateoasLink): General HATEOAS link for this API, specifying
            supported action (GET, POST, etc) and contentTypes
            (application/json, image/png, etc), but without any path parameter
            values
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "availability": 'availability',
        "also_supported": 'alsoSupported',
        "version": 'version',
        "fdx_versions": 'fdxVersions',
        "cut_off_time": 'cutOffTime',
        "link": 'link'
    }

    _optionals = [
        'id',
        'availability',
        'also_supported',
        'version',
        'fdx_versions',
        'cut_off_time',
        'link',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 availability=APIHelper.SKIP,
                 also_supported=APIHelper.SKIP,
                 version=APIHelper.SKIP,
                 fdx_versions=APIHelper.SKIP,
                 cut_off_time=APIHelper.SKIP,
                 link=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the OperationEntity class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if availability is not APIHelper.SKIP:
            self.availability = availability 
        if also_supported is not APIHelper.SKIP:
            self.also_supported = also_supported 
        if version is not APIHelper.SKIP:
            self.version = version 
        if fdx_versions is not APIHelper.SKIP:
            self.fdx_versions = fdx_versions 
        if cut_off_time is not APIHelper.SKIP:
            self.cut_off_time = APIHelper.apply_datetime_converter(cut_off_time, APIHelper.RFC3339DateTime) if cut_off_time else None 
        if link is not APIHelper.SKIP:
            self.link = link 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        availability = AvailabilityEntity1.from_dictionary(dictionary.get('availability')) if 'availability' in dictionary.keys() else APIHelper.SKIP
        also_supported = dictionary.get("alsoSupported") if dictionary.get("alsoSupported") else APIHelper.SKIP
        version = dictionary.get("version") if dictionary.get("version") else APIHelper.SKIP
        fdx_versions = dictionary.get("fdxVersions") if dictionary.get("fdxVersions") else APIHelper.SKIP
        cut_off_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("cutOffTime")).datetime if dictionary.get("cutOffTime") else APIHelper.SKIP
        link = HateoasLink.from_dictionary(dictionary.get('link')) if 'link' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(id,
                   availability,
                   also_supported,
                   version,
                   fdx_versions,
                   cut_off_time,
                   link,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'id={(self.id if hasattr(self, "id") else None)!r}, '
                f'availability={(self.availability if hasattr(self, "availability") else None)!r}, '
                f'also_supported={(self.also_supported if hasattr(self, "also_supported") else None)!r}, '
                f'version={(self.version if hasattr(self, "version") else None)!r}, '
                f'fdx_versions={(self.fdx_versions if hasattr(self, "fdx_versions") else None)!r}, '
                f'cut_off_time={(self.cut_off_time if hasattr(self, "cut_off_time") else None)!r}, '
                f'link={(self.link if hasattr(self, "link") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'id={(self.id if hasattr(self, "id") else None)!s}, '
                f'availability={(self.availability if hasattr(self, "availability") else None)!s}, '
                f'also_supported={(self.also_supported if hasattr(self, "also_supported") else None)!s}, '
                f'version={(self.version if hasattr(self, "version") else None)!s}, '
                f'fdx_versions={(self.fdx_versions if hasattr(self, "fdx_versions") else None)!s}, '
                f'cut_off_time={(self.cut_off_time if hasattr(self, "cut_off_time") else None)!s}, '
                f'link={(self.link if hasattr(self, "link") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
