# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class OrganizationNameEntity(object):

    """Implementation of the 'Organization Name entity' model.

    Logical grouping of name attributes that are particular to
    an Organization type of payment initiation party

    Attributes:
        company_name (str): Name value of the organization
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "company_name": 'companyName'
    }

    _optionals = [
        'company_name',
    ]

    def __init__(self,
                 company_name=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the OrganizationNameEntity class"""

        # Initialize members of the class
        if company_name is not APIHelper.SKIP:
            self.company_name = company_name 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        company_name = dictionary.get("companyName") if dictionary.get("companyName") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(company_name,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'company_name={(self.company_name if hasattr(self, "company_name") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'company_name={(self.company_name if hasattr(self, "company_name") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
