# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class OtherMonetaryAmount(object):

    """Implementation of the 'Other Monetary Amount' model.

    A monetary amount with its source name and its currency code

    Attributes:
        amount (float): The monetary amount
        currency (Iso4217CurrencyCode): Currency code of the monetary amount
        name (str): The source name of this monetary amount
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "amount": 'amount',
        "currency": 'currency',
        "name": 'name'
    }

    _optionals = [
        'currency',
        'name',
    ]

    def __init__(self,
                 amount=None,
                 currency=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the OtherMonetaryAmount class"""

        # Initialize members of the class
        self.amount = amount 
        if currency is not APIHelper.SKIP:
            self.currency = currency 
        if name is not APIHelper.SKIP:
            self.name = name 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        amount = dictionary.get("amount") if dictionary.get("amount") else None
        currency = dictionary.get("currency") if dictionary.get("currency") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(amount,
                   currency,
                   name,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'amount={self.amount!r}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'amount={self.amount!s}, '
                f'currency={(self.currency if hasattr(self, "currency") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
