# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PageMetadata(object):

    """Implementation of the 'Page Metadata' model.

    Offset IDs for navigating result sets

    Attributes:
        next_offset (str): Opaque identifier. Does not need to be numeric or
            have any specific pattern. Implementation specific
        prev_offset (str): Opaque identifier. Does not need to be numeric or
            have any specific pattern. Implementation specific
        total_elements (int): Total number of elements
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "next_offset": 'nextOffset',
        "prev_offset": 'prevOffset',
        "total_elements": 'totalElements'
    }

    _optionals = [
        'next_offset',
        'prev_offset',
        'total_elements',
    ]

    def __init__(self,
                 next_offset=APIHelper.SKIP,
                 prev_offset=APIHelper.SKIP,
                 total_elements=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PageMetadata class"""

        # Initialize members of the class
        if next_offset is not APIHelper.SKIP:
            self.next_offset = next_offset 
        if prev_offset is not APIHelper.SKIP:
            self.prev_offset = prev_offset 
        if total_elements is not APIHelper.SKIP:
            self.total_elements = total_elements 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        next_offset = dictionary.get("nextOffset") if dictionary.get("nextOffset") else APIHelper.SKIP
        prev_offset = dictionary.get("prevOffset") if dictionary.get("prevOffset") else APIHelper.SKIP
        total_elements = dictionary.get("totalElements") if dictionary.get("totalElements") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(next_offset,
                   prev_offset,
                   total_elements,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'next_offset={(self.next_offset if hasattr(self, "next_offset") else None)!r}, '
                f'prev_offset={(self.prev_offset if hasattr(self, "prev_offset") else None)!r}, '
                f'total_elements={(self.total_elements if hasattr(self, "total_elements") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'next_offset={(self.next_offset if hasattr(self, "next_offset") else None)!s}, '
                f'prev_offset={(self.prev_offset if hasattr(self, "prev_offset") else None)!s}, '
                f'total_elements={(self.total_elements if hasattr(self, "total_elements") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
