# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class PaymentForUpdateEntity(object):

    """Implementation of the 'Payment For Update entity' model.

    Payment entity used for creation and update of a payment

    Attributes:
        from_account_id (str): ID of the account used to source funds for
            payment
        to_payee_id (str): ID of the payee to receive funds for the payment
        amount (float): Amount for the payment. Must be positive
        merchant_account_id (str): User's account identifier with the merchant
        due_date (date): Date that the funds are scheduled to be delivered
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "from_account_id": 'fromAccountId',
        "to_payee_id": 'toPayeeId',
        "amount": 'amount',
        "due_date": 'dueDate',
        "merchant_account_id": 'merchantAccountId'
    }

    _optionals = [
        'merchant_account_id',
    ]

    def __init__(self,
                 from_account_id=None,
                 to_payee_id=None,
                 amount=None,
                 due_date=None,
                 merchant_account_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentForUpdateEntity class"""

        # Initialize members of the class
        self.from_account_id = from_account_id 
        self.to_payee_id = to_payee_id 
        self.amount = amount 
        if merchant_account_id is not APIHelper.SKIP:
            self.merchant_account_id = merchant_account_id 
        self.due_date = due_date 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        from_account_id = dictionary.get("fromAccountId") if dictionary.get("fromAccountId") else None
        to_payee_id = dictionary.get("toPayeeId") if dictionary.get("toPayeeId") else None
        amount = dictionary.get("amount") if dictionary.get("amount") else None
        due_date = dateutil.parser.parse(dictionary.get('dueDate')).date() if dictionary.get('dueDate') else None
        merchant_account_id = dictionary.get("merchantAccountId") if dictionary.get("merchantAccountId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(from_account_id,
                   to_payee_id,
                   amount,
                   due_date,
                   merchant_account_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'from_account_id={self.from_account_id!r}, '
                f'to_payee_id={self.to_payee_id!r}, '
                f'amount={self.amount!r}, '
                f'merchant_account_id={(self.merchant_account_id if hasattr(self, "merchant_account_id") else None)!r}, '
                f'due_date={self.due_date!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'from_account_id={self.from_account_id!s}, '
                f'to_payee_id={self.to_payee_id!s}, '
                f'amount={self.amount!s}, '
                f'merchant_account_id={(self.merchant_account_id if hasattr(self, "merchant_account_id") else None)!s}, '
                f'due_date={self.due_date!s}, '
                f'additional_properties={self.additional_properties!s})')
