# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.branch_entity_1 import BranchEntity1


class PaymentGenericAccountEntity(object):

    """Implementation of the 'Payment Generic Account entity' model.

    Payment Generic Account information

    Attributes:
        account_number (str): Unique identifier of the account number
        account_type (AccountType): Account type
        name (str): Account name
        currency_code (Iso4217CurrencyCode): ISO 4217 currency code
        id (Iban2007IdentifierEntity | GenericAccountIdentificationEntity |
            None): Identifier of the payment generic account
        branch (BranchEntity1): Branch details associated with this account
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_number": 'accountNumber',
        "account_type": 'accountType',
        "name": 'name',
        "currency_code": 'currencyCode',
        "id": 'id',
        "branch": 'branch'
    }

    _optionals = [
        'account_number',
        'account_type',
        'name',
        'currency_code',
        'id',
        'branch',
    ]

    def __init__(self,
                 account_number=APIHelper.SKIP,
                 account_type=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 currency_code=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 branch=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentGenericAccountEntity class"""

        # Initialize members of the class
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if account_type is not APIHelper.SKIP:
            self.account_type = account_type 
        if name is not APIHelper.SKIP:
            self.name = name 
        if currency_code is not APIHelper.SKIP:
            self.currency_code = currency_code 
        if id is not APIHelper.SKIP:
            self.id = id 
        if branch is not APIHelper.SKIP:
            self.branch = branch 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_type = dictionary.get("accountType") if dictionary.get("accountType") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        currency_code = dictionary.get("currencyCode") if dictionary.get("currencyCode") else APIHelper.SKIP
        id = APIHelper.deserialize_union_type(UnionTypeLookUp.get('PaymentGenericAccountEntityId'), dictionary.get('id'), False) if dictionary.get('id') is not None else APIHelper.SKIP
        branch = BranchEntity1.from_dictionary(dictionary.get('branch')) if 'branch' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(account_number,
                   account_type,
                   name,
                   currency_code,
                   id,
                   branch,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'account_type={(self.account_type if hasattr(self, "account_type") else None)!r}, '
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'currency_code={(self.currency_code if hasattr(self, "currency_code") else None)!r}, '
                f'id={(self.id if hasattr(self, "id") else None)!r}, '
                f'branch={(self.branch if hasattr(self, "branch") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'account_type={(self.account_type if hasattr(self, "account_type") else None)!s}, '
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'currency_code={(self.currency_code if hasattr(self, "currency_code") else None)!s}, '
                f'id={(self.id if hasattr(self, "id") else None)!s}, '
                f'branch={(self.branch if hasattr(self, "branch") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
